<?php
// /erp_task_system/api/user_salary.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }
$meRole = $_SESSION['user']['role'] ?? '';
if (!in_array($meRole, ['admin','manager'])) { echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit; }

$user_id = (int)($_POST['user_id'] ?? 0);
if ($user_id <= 0) { echo json_encode(['ok'=>false,'msg'=>'bad_user']); exit; }

$salary = (isset($_POST['salary']) && $_POST['salary'] !== '') ? (float)$_POST['salary'] : null;

$component_ids = $_POST['component_ids']   ?? [];  // [ids]
$values        = $_POST['component_value'] ?? [];  // [id => value]
$notes         = $_POST['component_notes'] ?? [];  // [id => note]

try {
  $conn->beginTransaction();

  // ما نحدّث users.salary — نخزّن الراتب الأساسي كبند BASIC
  // احذف البنود القديمة لهالموظف
  $del = $conn->prepare("DELETE FROM employee_salary_items WHERE employee_id = ?");
  $del->execute([$user_id]);

  // جيب معرّف بند BASIC
  $stmt = $conn->prepare("
    SELECT id FROM salary_components
    WHERE is_active = 1 AND (code = 'BASIC' OR name LIKE :n)
    ORDER BY (code = 'BASIC') DESC
    LIMIT 1
  ");
  $stmt->execute([':n' => '%الراتب الأساسي%']);
  $basicId = $stmt->fetchColumn();

  // جهّز الصفوف: [employee_id, component_id, value, notes]
  $rows = [];

  if (is_array($component_ids)) {
    foreach ($component_ids as $compId) {
      $cid  = (int)$compId;
      $val  = isset($values[$cid]) ? (float)$values[$cid] : 0.0;
      $note = isset($notes[$cid])  ? trim($notes[$cid])  : null;
      $rows[] = [$user_id, $cid, $val, $note];
    }
  }

  // لو جتنا قيمة salary، خزّنها كبند BASIC
  if ($salary !== null && $basicId) {
    $found = false;
    foreach ($rows as &$r) {
      // r = [employee_id, component_id, value, notes]
      if ((int)$r[1] === (int)$basicId) {
        $r[2] = (float)$salary; // حدّث قيمة الأساسي لو كان موجود
        $found = true;
        break;
      }
    }
    unset($r);

    if (!$found) {
      $rows[] = [$user_id, (int)$basicId, (float)$salary, null];
    }
  }

  // إدخال الصفوف
  if (!empty($rows)) {
    $ins = $conn->prepare("
      INSERT INTO employee_salary_items (employee_id, component_id, value, notes, created_at)
      VALUES (?, ?, ?, ?, NOW())
    ");
    foreach ($rows as $r) { $ins->execute($r); }
  }

  $conn->commit();
  echo json_encode(['ok'=>true, 'saved'=>count($rows)]);
} catch (Throwable $e) {
  if ($conn->inTransaction()) $conn->rollBack();
  echo json_encode(['ok'=>false,'msg'=>'error','err'=>$e->getMessage()]);
}
