<?php
// /erp_task_system/api/users_basic_create.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }
$meRole = $_SESSION['user']['role'] ?? '';
if (!in_array($meRole, ['admin','manager'])) { echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit; }

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* جذر الموقع لاستخدامه في مسارات الملفات */
$root = rtrim($_SERVER['DOCUMENT_ROOT'] ?? '', '/');

/* ========== 1) استلام القيم من النموذج ========== */
$name   = trim($_POST['name']  ?? '');
$email  = trim($_POST['email'] ?? '');
$pass   = $_POST['password'] ?? '';

$role   = $_POST['role'] ?? 'employee';
$allowedRoles = ['admin','manager','employee','user'];
if (!in_array($role, $allowedRoles)) $role = 'employee';
if ($role === 'user') $role = 'employee';

$department_id = !empty($_POST['department_id']) ? (int)$_POST['department_id'] : null;
$work_shift_id = !empty($_POST['work_shift_id']) ? (int)$_POST['work_shift_id'] : null;
$location_id   = !empty($_POST['location_id']) ? (int)$_POST['location_id'] : null;
$day_off       = (isset($_POST['day_off']) && $_POST['day_off']!=='') ? (int)$_POST['day_off'] : null;

/* شخصي */
$personal_email = trim($_POST['personal_email'] ?? '');
$personal_phone = trim($_POST['personal_phone'] ?? '');

/* عمل */
$work_email = trim($_POST['work_email'] ?? '');
$work_phone = trim($_POST['work_phone'] ?? '');

$gender         = trim($_POST['gender'] ?? '');
$religion       = trim($_POST['religion'] ?? '');
$marital_status = trim($_POST['marital_status'] ?? '');
$nationality    = trim($_POST['nationality'] ?? '');

$job_title         = trim($_POST['job_title'] ?? '');
$hire_date         = trim($_POST['hire_date'] ?? '');
$employment_status = $_POST['employment_status'] ?? 'نشط';
$salary            = ($_POST['salary'] ?? '') !== '' ? floatval($_POST['salary']) : null;
$employee_number   = trim($_POST['employee_number'] ?? ''); // تقدر تخليه فاضي للتوليد الآلي

// هوية
$national_id            = trim($_POST['national_id'] ?? '');
$national_id_issue_date = trim($_POST['national_id_issue_date'] ?? '');
$national_id_place      = trim($_POST['national_id_place'] ?? '');

// جواز
$passport_number     = trim($_POST['passport_number'] ?? '');
$passport_place      = trim($_POST['passport_place'] ?? '');
$passport_country    = trim($_POST['passport_country'] ?? '');
$passport_issue_date = trim($_POST['passport_issue_date'] ?? '');
$passport_expire_date= trim($_POST['passport_expire_date'] ?? '');

// العنوان الوطني
$address_building          = trim($_POST['address_building'] ?? '');
$address_street            = trim($_POST['address_street'] ?? '');
$address_district          = trim($_POST['address_district'] ?? '');
$address_city              = trim($_POST['address_city'] ?? '');
$address_zip               = trim($_POST['address_zip'] ?? '');
$address_additional_number = trim($_POST['address_additional_number'] ?? '');

// بنكي
$bank_account = trim($_POST['bank_account'] ?? '');
$iban         = strtoupper(str_replace(' ','', $_POST['iban'] ?? ''));
$bank_name    = trim($_POST['bank_name'] ?? '');

// فلاغات
$can_sign           = !empty($_POST['can_sign']) ? 1 : 0;
$can_transfer_tasks = !empty($_POST['can_transfer_tasks']) ? 1 : 0;
$secret_level       = $_POST['secret_level'] ?? 'normal';

/* ========== 2) تحققات بسيطة ========== */
if ($name==='' || $email==='' || $pass==='') { echo json_encode(['ok'=>false,'msg'=>'required']); exit; }

$chk = $conn->prepare("SELECT 1 FROM users WHERE email=? LIMIT 1");
$chk->execute([$email]);
if ($chk->fetch()) { echo json_encode(['ok'=>false,'msg'=>'email_in_use']); exit; }

if ($national_id !== '' && !preg_match('/^\d{10}$/', $national_id)) {
  echo json_encode(['ok'=>false,'msg'=>'bad_nid']); exit;
}
if ($iban !== '' && !preg_match('/^[A-Z]{2}\d{2}[A-Z0-9]{1,30}$/', $iban)) {
  echo json_encode(['ok'=>false,'msg'=>'bad_iban']); exit;
}

$hash = password_hash($pass, PASSWORD_DEFAULT);

/* ========== 3) رفع الصور (اختياري) ========== */
/* صورة الموظف */
$profile_image = null;
if (!empty($_FILES['profile_image']['name']) && $_FILES['profile_image']['error']===0) {
  $uploadDir = $root . '/erp_task_system/users/img/';
  if (!is_dir($uploadDir)) @mkdir($uploadDir, 0775, true);
  $ext = strtolower(pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION));
  $newName = uniqid('uimg_').'.'.$ext;
  if (is_uploaded_file($_FILES['profile_image']['tmp_name']) &&
      move_uploaded_file($_FILES['profile_image']['tmp_name'], $uploadDir.$newName)) {
    $profile_image = $newName;
  }
}

/* توقيع */
$signature_path = null;
if ($can_sign && !empty($_FILES['signature_file']['name']) && $_FILES['signature_file']['error']===0) {
  $sigDir = $root . '/erp_task_system/uploads/signatures/';
  if (!is_dir($sigDir)) @mkdir($sigDir, 0775, true);
  $ext = strtolower(pathinfo($_FILES['signature_file']['name'], PATHINFO_EXTENSION));
  $sigName = uniqid('sig_').'.'.$ext;
  if (is_uploaded_file($_FILES['signature_file']['tmp_name']) &&
      move_uploaded_file($_FILES['signature_file']['tmp_name'], $sigDir.$sigName)) {
    $signature_path = $sigName;
  }
}

/* ========== 4) الإدراج ========== */
try {
  $sql = "INSERT INTO users (
      name, email, password, role,
      department_id, work_shift_id, location_id, day_off,
      personal_email, personal_phone,
      work_email, work_phone,
      job_title, gender, religion, marital_status, nationality,
      hire_date, employment_status, salary,
      employee_number,
      national_id, national_id_issue_date, national_id_place,
      passport_number, passport_place, passport_country, passport_issue_date, passport_expire_date,
      address_building, address_street, address_district, address_city, address_zip, address_additional_number,
      bank_account, iban, bank_name,
      can_sign, signature_path, can_transfer_tasks, secret_level, profile_image,
      created_at
    ) VALUES (
      :name, :email, :password, :role,
      :department_id, :work_shift_id, :location_id, :day_off,
      :personal_email, :personal_phone,
      :work_email, :work_phone,
      :job_title, :gender, :religion, :marital_status, :nationality,
      :hire_date, :employment_status, :salary,
      :employee_number,
      :national_id, :national_id_issue_date, :national_id_place,
      :passport_number, :passport_place, :passport_country, :passport_issue_date, :passport_expire_date,
      :address_building, :address_street, :address_district, :address_city, :address_zip, :address_additional_number,
      :bank_account, :iban, :bank_name,
      :can_sign, :signature_path, :can_transfer_tasks, :secret_level, :profile_image,
      NOW()
    )";

  $st = $conn->prepare($sql);
  $st->execute([
    ':name' => $name, ':email'=>$email, ':password'=>$hash, ':role'=>$role,
    ':department_id'=>$department_id, ':work_shift_id'=>$work_shift_id,
    ':location_id'=>$location_id, ':day_off'=>$day_off,

    ':personal_email'=>$personal_email ?: null,
    ':personal_phone'=>$personal_phone ?: null,

    ':work_email'=>$work_email ?: null,
    ':work_phone'=>$work_phone ?: null,

    ':job_title'=>$job_title ?: null,
    ':gender'=>$gender ?: null,
    ':religion'=>$religion ?: null,
    ':marital_status'=>$marital_status ?: null,
    ':nationality'=>$nationality ?: null,

    ':hire_date'=>$hire_date ?: null,
    ':employment_status'=>$employment_status ?: null,
    ':salary'=>$salary,

    ':employee_number'=>($employee_number!==''?$employee_number:null),

    ':national_id'=>($national_id!==''?$national_id:null),
    ':national_id_issue_date'=>$national_id_issue_date ?: null,
    ':national_id_place'=>$national_id_place ?: null,

    ':passport_number'=>$passport_number ?: null,
    ':passport_place'=>$passport_place ?: null,
    ':passport_country'=>$passport_country ?: null,
    ':passport_issue_date'=>$passport_issue_date ?: null,
    ':passport_expire_date'=>$passport_expire_date ?: null,

    ':address_building'=>$address_building ?: null,
    ':address_street'=>$address_street ?: null,
    ':address_district'=>$address_district ?: null,
    ':address_city'=>$address_city ?: null,
    ':address_zip'=>$address_zip ?: null,
    ':address_additional_number'=>$address_additional_number ?: null,

    ':bank_account'=>$bank_account ?: null,
    ':iban'=>$iban ?: null,
    ':bank_name'=>$bank_name ?: null,

    ':can_sign'=>$can_sign,
    ':signature_path'=>$signature_path,
    ':can_transfer_tasks'=>$can_transfer_tasks,
    ':secret_level'=>$secret_level,
    ':profile_image'=>$profile_image,
  ]);

  $new_id = (int)$conn->lastInsertId();

  /* ====== حفظ شهادات الآيبان/العنوان بعد الإنشاء ====== */
  $folderKey = ($employee_number !== '' ? $employee_number : ('uid_'.$new_id));
  $relDir    = "/erp_task_system/users/employee_files/{$folderKey}/";
  $absDir    = $root . $relDir;
  $baseDir   = $root . "/erp_task_system/users/employee_files/";
  if (!is_dir($absDir)) { @mkdir($absDir, 0775, true); }

  $allowed = ['pdf','jpg','jpeg','png','gif','webp'];

  $saveAfterInsert = function($fieldName, $prefix) use ($absDir, $relDir, $baseDir, $folderKey, $allowed) {
      $path    = null;
      $orig    = $_FILES[$fieldName]['name'] ?? '';
      $tmp     = $_FILES[$fieldName]['tmp_name'] ?? '';
      $ext     = strtolower(pathinfo($orig, PATHINFO_EXTENSION));

      if ($ext && in_array($ext, $allowed)) {
          $newName = $prefix.'_'.date('Ymd_His')."_{$folderKey}.".$ext;
          $target  = $absDir.$newName;

          if ($tmp && is_uploaded_file($tmp) && @move_uploaded_file($tmp, $target)) {
              $path = $relDir.$newName;
          } else {
              // fallback: لو الملف انحط بالغلط قبل الإدراج
              $cand = glob($baseDir.$prefix.'_*'.($ext?('.'.$ext):''));
              if ($cand) {
                  usort($cand, fn($a,$b)=>@filemtime($b)<=>@filemtime($a));
                  $now = time();
                  foreach ($cand as $c) {
                      if (!is_file($c)) continue;
                      if (($now - (@filemtime($c) ?: $now)) > 600) continue; // آخر 10 دقايق
                      $newName = $prefix.'_'.date('Ymd_His')."_{$folderKey}.".$ext;
                      if (@rename($c, $absDir.$newName)) { $path = $relDir.$newName; break; }
                  }
              }
          }
      }
      return $path;
  };

  $ibanCertPath = $saveAfterInsert('iban_certificate', 'iban_cert');
  $addrCertPath = $saveAfterInsert('national_address_certificate', 'nataddr_cert');

  if ($ibanCertPath || $addrCertPath) {
      $stmt = $conn->prepare("
          UPDATE users
             SET iban_cert_file = COALESCE(?, iban_cert_file),
                 national_address_cert_file = COALESCE(?, national_address_cert_file)
           WHERE id = ?
      ");
      $stmt->execute([$ibanCertPath, $addrCertPath, $new_id]);
  }

  // رصيد الإجازات الأولي
  $annual = isset($_POST['annual_leave_days']) ? floatval($_POST['annual_leave_days']) : 31;
  if ($annual <= 0) $annual = 31;
  $accrual_start = $hire_date ?: date('Y-m-d');
  $conn->prepare("UPDATE users
                  SET annual_leave_days=?, leave_balance=0, leave_accrual_start=?, leave_last_accrual=NULL
                  WHERE id=?")->execute([$annual,$accrual_start,$new_id]);

  // مجلد الموظف حسب الرقم الوظيفي (اختياري)
  if ($employee_number!=='') {
    $empFolder = $root . '/erp_task_system/users/employee_files/'.$employee_number;
    if (!is_dir($empFolder)) @mkdir($empFolder, 0775, true);
  }

  echo json_encode(['ok'=>true,'id'=>$new_id]);

} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>'error','err'=>$e->getMessage()]);
}