// بدل DOMContentLoaded نستخدم setTimeout للتأكد من وجود الزر بعد تحميل المحتوى
setTimeout(() => {

  const btn = document.getElementById("signTemplateBtn");
  if (!btn) return;

  btn.addEventListener("click", function (e) {
    e.preventDefault();
    e.stopPropagation();

    const taskId = btn.dataset.taskId;
    const templateId = btn.dataset.templateId;

    btn.disabled = true;
    btn.innerText = "⏳ جاري التوقيع...";

    fetch("../templates/sign_template.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: `task_id=${taskId}&template_id=${templateId}`
    })
.then(res => res.json())
.then(res => {
  if (res.success) {
    alert(res.message);
    if (typeof loadAttachments === 'function') loadAttachments();
  } else {
    alert("❌ فشل التوقيع:\n" + res.message);
  }
})
      .catch(err => {
        alert("❌ خطأ في الاتصال بالسيرفر");
        console.error(err);
      })
      .finally(() => {
        btn.disabled = false;
        btn.innerText = "✍️ توقيع النموذج";
      });
  });
}, 500); // انتظر نصف ثانية لتضمن أن الزر ظهر
