// تحميل المرفقات
window.loadAttachments = function() {
  if (typeof taskId === 'undefined') return;

  fetch(`../api/get_attachments_api.php?task_id=${taskId}&t=${Date.now()}`)
    .then(res => res.json())
    .then(res => {
      const list = document.getElementById("attachmentList");
      if (!list) return;
      list.innerHTML = "";
      if (res.success) {
        res.attachments.forEach(file => {
          const ext = file.file_path.split('.').pop().toLowerCase();
          const isImage = ['jpg','jpeg','png','gif','webp'].includes(ext);
          const fileUrl = `../${file.file_path}?t=${Date.now()}`;

          const box = document.createElement("div");
          box.className = "border rounded overflow-hidden text-sm relative";

          let html = isImage
            ? `<a href="${fileUrl}" target="_blank"><img src="${fileUrl}" class="w-full h-24 object-cover"></a>`
            : `<a href="${fileUrl}" target="_blank" class='flex items-center justify-center h-24 bg-gray-100 hover:bg-gray-200'>📄 ${ext.toUpperCase()}</a>`;

          if (isManager) {
            html += `<button type="button" onclick="deleteAttachment(${file.id})" class="absolute top-1 right-1 bg-red-600 text-white text-xs px-1 rounded-full">×</button>`;
          }

          box.innerHTML = html;
          list.appendChild(box);
        });
      }
    });
};

// تحميل التعليقات
window.loadComments = function() {
  if (typeof taskId === 'undefined') return;

  fetch(`../api/get_comments_api.php?task_id=${taskId}&t=${Date.now()}`)
    .then(res => res.json())
    .then(res => {
      const list = document.getElementById("commentsList");
      if (!list) return;
      list.innerHTML = "";
      if (res.success && res.comments.length > 0) {
        res.comments.forEach(comment => {
          const div = document.createElement("div");
          div.className = "border rounded p-2 card text relative";
          div.innerHTML = `<strong>${comment.author_name}</strong><br>${comment.comment}`;
          if (isManager) {
            div.innerHTML += `<button type="button" onclick="deleteComment(${comment.id})" class="absolute top-1 left-1 bg-red-600 text-white text-xs px-1 rounded-full">×</button>`;
          }
          list.appendChild(div);
        });
      } else {
        list.innerHTML = "<p class='text-gray-500'>لا توجد تعليقات بعد.</p>";
      }
    });
}

// إرسال تعليق
window.submitComment = function() {
  const contentInput = document.getElementById("newComment");
  if (!contentInput || !contentInput.value.trim()) return alert("❗ الرجاء كتابة تعليق");

  fetch("../api/add_comment_api.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ task_id: taskId, content: contentInput.value })
  })
  .then(res => res.json())
  .then(res => {
    if (res.success) {
      contentInput.value = "";
      loadComments();
      showModalAlert("✅ تم إرسال التعليق بنجاح", 'success');
    } else {
      alert("❌ فشل في إرسال التعليق");
    }
  });
}

// رفع مرفق
window.uploadAttachment = function () {
  const input = document.querySelector("#attachmentInput");
  if (!input || input.files.length === 0) {
    alert("❗ الرجاء اختيار ملف");
    return;
  }

  const file = input.files[0];
  const data = new FormData();
  data.append("file", file);
  data.append("task_id", taskId);

  const uploadBtn = document.getElementById("uploadAttachmentBtn");
  uploadBtn.disabled = true;
  uploadBtn.textContent = "📤 جاري الرفع...";

  fetch("../api/upload_attachment_api.php", {
    method: "POST",
    body: data
  })
    .then(res => res.json())
    .then(res => {
      uploadBtn.disabled = false;
      uploadBtn.textContent = "رفع";
      input.value = "";
      if (res.success) {
        loadAttachments();
        showModalAlert("✅ تم رفع المرفق بنجاح", 'success');
      } else {
        alert("❌ فشل في رفع المرفق");
      }
    })
    .catch(() => {
      uploadBtn.disabled = false;
      uploadBtn.textContent = "رفع";
      alert("⚠️ حصل خطأ أثناء الاتصال بالسيرفر");
    });
};

// حذف تعليق
window.deleteComment = function(id) {
  if (!confirm("هل أنت متأكد من حذف هذا التعليق؟")) return;

  fetch(`../api/delete_comment_api.php?id=${id}`)
    .then(res => res.json())
    .then(res => {
      if (res.success) {
        showModalAlert("✅ تم حذف التعليق بنجاح", 'success');
        loadComments();
      } else {
        alert("❌ فشل في حذف التعليق");
      }
    })
    .catch(err => {
      console.error("🔥 خطأ في حذف التعليق:", err);
    });
}

// حذف مرفق
window.deleteAttachment = function(id) {
  if (!confirm("هل أنت متأكد من حذف هذا المرفق؟")) return;

  fetch(`../api/delete_attachment_api.php?id=${id}`)
    .then(res => res.json())
    .then(res => {
      if (res.success) {
        showModalAlert("✅ تم حذف المرفق بنجاح", 'success');
        setTimeout(loadAttachments, 100);
      } else {
        alert("❌ فشل في حذف المرفق");
      }
    })
    .catch(err => {
      console.error("🔥 خطأ في حذف المرفق:", err);
    });
}
window.showLogs = function () {
  document.getElementById('commentsSection').classList.add('hidden');
  document.getElementById('logsSection').classList.remove('hidden');
  loadLogs();
};

window.loadLogs = function () {
  fetch(`../api/get_task_logs.php?task_id=${taskId}`)
    .then(res => res.json())
    .then(res => {
      const logsList = document.getElementById('logsList');
      if (!logsList) return;
      logsList.innerHTML = '';
      if (res.success && res.logs.length > 0) {
        res.logs.forEach(log => {
          logsList.innerHTML += `
            <div class="border p-2 rounded bg-gray-100">
              <div class="font-semibold">${log.user_name}</div>
              <div>${log.action_type} - ${log.action_details}</div>
              <div class="text-xs text-gray-500 mt-1">${log.created_at}</div>
            </div>
          `;
        });
      } else {
        logsList.innerHTML = '<p class="text-gray-500 text-sm">لا يوجد سجلات حتى الآن.</p>';
      }
    });
};


// عرض تنبيه في المودال
function showModalAlert(message, type = 'success') {
  const alertBox = document.getElementById("modalAlert");
  if (!alertBox) return;

  alertBox.textContent = message;
  alertBox.className = `mb-3 px-4 py-2 rounded text-sm font-medium ${
    type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'
  }`;
  alertBox.classList.remove("hidden");

  setTimeout(() => {
    alertBox.classList.add("hidden");
  }, 300);
}
// عرض  التوقيع في المودل
function loadTemplatePreview(taskId, templateId) {
  fetch(`../templates/view_template_modal.php?task_id=${taskId}&template_id=${templateId}`)
    .then(res => res.text())
    .then(html => {
      document.getElementById("modalContent").innerHTML = html;

      // إعادة تنفيذ السكربتات لو احتاجت
      const scripts = document.getElementById("modalContent").querySelectorAll("script");
      scripts.forEach(old => {
        const script = document.createElement("script");
        script.text = old.text;
        document.body.appendChild(script);
      });
    });
}
