<?php
// auth.php

// تأكد إن الجلسة مفعلة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// تحقق من وجود جلسة مستخدم
if (!isset($_SESSION['user']) || !is_array($_SESSION['user'])) {
    // مافيه جلسة دخول --> رجعه لصفحة تسجيل الدخول
    header('Location: ../unauthorized.php'); // غير المسار حسب مكان صفحة تسجيل الدخول عندك
    exit;
}

// تحقق من المعلومات الأساسية
if (
    !isset($_SESSION['user']['id']) ||
    !isset($_SESSION['user']['role']) ||
!isset($_SESSION['user']['department_id']) && $_SESSION['user']['role'] != 'admin'
) {
    // لو ناقص بيانات --> رجعه تسجيل دخول
    session_unset();
    session_destroy();
    header('Location: unauthorized.php');
    exit;
}

// ممكن هنا تضيف حماية إضافية لو تبي (مثلاً منع حسابات معينة أو تحقق من active account)
