<?php
// authorize.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function allow_roles($roles) {
    if (
        !isset($_SESSION['user']) ||
        !is_array($_SESSION['user']) ||
        !isset($_SESSION['user']['id'], $_SESSION['user']['role']) ||
        !is_numeric($_SESSION['user']['id']) ||
        !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user']) ||  // هنا صححناه
        !in_array($_SESSION['user']['role'], $roles)
    ) {
        session_unset();
        session_destroy();
        header('Location: ../../unauthorized.php');
        exit;
    }
}
