<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $_GET['department_id'] ?? $user['department_id'];

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
$users = $conn->query("SELECT id, name FROM users")->fetchAll(PDO::FETCH_ASSOC);
$stageStmt = $conn->prepare("SELECT name FROM stages WHERE department_id = ?");
$stageStmt->execute([$department_id]);
$stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);

$customFieldsStmt = $conn->prepare("SELECT * FROM custom_fields WHERE department_id = ?");
$customFieldsStmt->execute([$department_id]);
$customFields = $customFieldsStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div id="addTaskModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
  <div class="bg-white w-full max-w-2xl p-6 rounded shadow-lg">
    <div class="flex justify-between items-center mb-4">
      <h2 class="text-xl font-bold">➕ إضافة مهمة</h2>
      <button onclick="document.getElementById('addTaskModal').classList.add('hidden')" class="text-red-500 font-bold">×</button>
    </div>

    <form method="POST" action="store.php" class="space-y-4">
      <div>
        <label class="block text-sm font-medium mb-1">العنوان</label>
        <input type="text" name="title" required class="w-full border rounded px-3 py-2">
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">الوصف</label>
        <textarea name="description" rows="3" required class="w-full border rounded px-3 py-2"></textarea>
      </div>
      <div class="grid grid-cols-2 gap-4">
        <div>
          <label class="block text-sm font-medium mb-1">المرحلة</label>
          <select name="status" class="w-full border rounded px-3 py-2">
            <?php foreach ($stages as $stage): ?>
              <option value="<?= htmlspecialchars($stage['name']) ?>"><?= htmlspecialchars($stage['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">الأولوية</label>
          <select name="priority" class="w-full border rounded px-3 py-2">
            <option value="low">منخفضة</option>
            <option value="medium">متوسطة</option>
            <option value="high">عالية</option>
          </select>
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">السرية</label>
          <select name="secret_level" class="w-full border rounded px-3 py-2">
            <option value="normal">عادية</option>
            <option value="secret">سرية</option>
            <option value="top_secret">سرية جداً</option>
          </select>
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">تاريخ الاستحقاق</label>
          <input type="date" name="due_date" class="w-full border rounded px-3 py-2">
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">الإدارة</label>
          <select name="department_id" class="w-full border rounded px-3 py-2">
            <?php foreach ($departments as $dep): ?>
              <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $department_id ? 'selected' : '' ?>><?= $dep['name'] ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">تعيين إلى</label>
          <select name="assigned_to" class="w-full border rounded px-3 py-2">
            <?php foreach ($users as $u): ?>
              <option value="<?= $u['id'] ?>"><?= $u['name'] ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <?php foreach ($customFields as $field): ?>
        <div>
          <label class="block text-sm font-medium mb-1"><?= htmlspecialchars($field['label']) ?></label>
          <?php if ($field['type'] === 'text'): ?>
            <input type="text" name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'number'): ?>
            <input type="number" name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'date'): ?>
            <input type="date" name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
          <?php endif; ?>
        </div>
      <?php endforeach; ?>

      <div class="text-center pt-4">
        <button type="submit" class=" text-white px-6 py-2 rounded hover:bg-green-700" style="background-color: #7be667;">💾 حفظ المهمة</button>
      </div>
    </form>
  </div>
</div>

<script>
  function openAddTaskModal() {
    document.getElementById('addTaskModal').classList.remove('hidden');
  }
</script>
