<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once 'layout.php';

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];
$user_id = $user['id'];
$user_secret_level = $user['secret_level'];

$levels = ['normal' => 1, 'secret' => 2, 'top_secret' => 3];
$max_level = $levels[$user_secret_level];

$departments = [];
$tasks_by_dept = [];

if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
} elseif ($role === 'manager') {
  $departments = $conn->prepare("SELECT id, name FROM departments WHERE id = ?");
  $departments->execute([$department_id]);
  $departments = $departments->fetchAll(PDO::FETCH_ASSOC);
} else {
  $departments = [['id' => 0, 'name' => 'مهامي']];
}

foreach ($departments as $dep) {
  $dep_id = $dep['id'];

  $stages = $conn->prepare("SELECT name, color FROM stages WHERE department_id = ?");
  $stages->execute([$dep_id]);
  $stages = $stages->fetchAll(PDO::FETCH_ASSOC);

  $stage_names = array_column($stages, 'name');

  if ($role === 'admin' || $role === 'manager') {
    $query = "SELECT t.*, u.name AS assigned_name FROM tasks t 
              LEFT JOIN users u ON t.assigned_to = u.id
              WHERE t.department_id = ? AND t.is_deleted = 0
              AND (CASE t.secret_level WHEN 'normal' THEN 1 WHEN 'secret' THEN 2 WHEN 'top_secret' THEN 3 END) <= ?";
    $stmt = $conn->prepare($query);
    $stmt->execute([$dep_id, $max_level]);
  } else {
    $query = "SELECT t.*, u.name AS assigned_name FROM tasks t 
              LEFT JOIN users u ON t.assigned_to = u.id
              WHERE t.assigned_to = ? AND t.is_deleted = 0
              AND (CASE t.secret_level WHEN 'normal' THEN 1 WHEN 'secret' THEN 2 WHEN 'top_secret' THEN 3 END) <= ?";
    $stmt = $conn->prepare($query);
    $stmt->execute([$user_id, $max_level]);
  }

  $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

  $grouped = [];
  foreach ($stages as $stage) {
    $grouped[$stage['name']] = [
      'label' => $stage['name'],
      'color' => $stage['color'],
      'tasks' => []
    ];
  }
  foreach ($tasks as $task) {
    if (isset($grouped[$task['status']])) {
      $grouped[$task['status']]['tasks'][] = $task;
    }
  }
  $tasks_by_dept[] = [
    'department' => $dep['name'],
    'columns' => $grouped
  ];
}
?>

<div class="p-6">
  <h2 class="text-xl font-bold mb-4">📌 عرض المهام - كانبان</h2>

  <?php foreach ($tasks_by_dept as $block): ?>
    <h3 class="text-lg font-bold mb-2">🏢 <?= htmlspecialchars($block['department']) ?></h3>
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4 mb-8">
      <?php foreach ($block['columns'] as $col): ?>
        <div class="rounded p-2 shadow text-sm" style="background-color: <?= $col['color'] ?>22; border: 2px solid <?= $col['color'] ?>">
          <h4 class="text-center font-semibold mb-2" style="color:<?= $col['color'] ?>;"> <?= $col['label'] ?> </h4>
          <div class="space-y-2">
            <?php foreach ($col['tasks'] as $task): ?>
              <div class="bg-white border rounded shadow-sm p-2">
                <strong><?= htmlspecialchars($task['title']) ?></strong><br>
                <span class="text-xs text-gray-600">📋 <?= htmlspecialchars($task['description']) ?></span>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endforeach; ?>
</div>
