<?php
require_once '../config/db.php';

$department_id = $_GET['department_id'] ?? null;

if (!$department_id) {
  exit("<p class='text-red-600'>❌ لم يتم تحديد الإدارة.</p>");
}

// جلب النموذج الخاص بالإدارة
$stmt = $conn->prepare("SELECT * FROM custom_forms WHERE department_id = ? ORDER BY id DESC LIMIT 1");
$stmt->execute([$department_id]);
$form = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$form) {
  exit("<p class='text-red-600'>❌ لا يوجد نموذج لهذه الإدارة.</p>");
}

$fields = json_decode($form['fields'], true);
?>

<form action="custom_forms/submit_portal_request.php" method="POST" enctype="multipart/form-data" class="space-y-4  p-4 rounded">
  <input type="hidden" name="department_id" value="<?= $department_id ?>">
  <input type="hidden" name="form_id" value="<?= $form['id'] ?>">

  <h3 class="text-lg font-semibold mb-2"><?= htmlspecialchars($form['title']) ?></h3>

  <?php foreach ($fields as $field): ?>
    <div>
      <label class="block mb-1 font-medium"><?= htmlspecialchars($field['label']) ?><?= !empty($field['required']) ? ' *' : '' ?></label>
      <?php if ($field['type'] === 'text'): ?>
        <input type="text" name="<?= htmlspecialchars($field['name']) ?>" class="w-full border p-2 rounded" <?= $field['required'] ? 'required' : '' ?>>
      <?php elseif ($field['type'] === 'number'): ?>
        <input type="number" name="<?= htmlspecialchars($field['name']) ?>" class="w-full border p-2 rounded" <?= $field['required'] ? 'required' : '' ?>>
      <?php elseif ($field['type'] === 'select'): ?>
        <select name="<?= htmlspecialchars($field['name']) ?>" class="w-full border p-2 rounded" <?= $field['required'] ? 'required' : '' ?>>
          <option value="">-- اختر --</option>
          <?php foreach ($field['options'] as $opt): ?>
            <option value="<?= htmlspecialchars($opt) ?>"><?= htmlspecialchars($opt) ?></option>
          <?php endforeach; ?>
        </select>
      <?php endif; ?>
    </div>
  <?php endforeach; ?>

  <div>
    <label class="block mb-1 font-medium">📎 مرفق (اختياري):</label>
    <input type="file" name="attachment" class="w-full">
  </div>

  <div>
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">📨 إرسال الطلب</button>
  </div>
</form>