<?php
require_once '../config/db.php';
require_once '../auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $department_id = $_POST['department_id'] ?? null;
  $title = $_POST['title'] ?? '';
  $fields_json = $_POST['fields_json'] ?? '';

  if (!$department_id || !$title || !$fields_json) {
    die('❌ البيانات ناقصة.');
  }

  // تحقق من أن JSON صحيح
  $fields_array = json_decode($fields_json, true);
  if (json_last_error() !== JSON_ERROR_NONE || !is_array($fields_array)) {
    die('❌ خطأ في تنسيق الحقول.');
  }

  // التحقق من وجود نموذج سابق لهذه الإدارة
  $check = $conn->prepare("SELECT COUNT(*) FROM custom_forms WHERE department_id = ?");
  $check->execute([$department_id]);
  if ($check->fetchColumn() > 0) {
    die("<p class='text-yellow-600 p-4'>⚠️ يوجد نموذج بالفعل لهذه الإدارة. يُرجى تعديله بدلاً من إضافة جديد.</p><a href='manage_portal_forms.php' class='text-blue-600 underline'>🔙 الرجوع</a>");
  }

  // حفظ النموذج
  $stmt = $conn->prepare("INSERT INTO custom_forms (department_id, title, fields) VALUES (?, ?, ?)");
  $stmt->execute([$department_id, $title, $fields_json]);

  echo "<p class='text-green-600 p-4'>✅ تم حفظ النموذج بنجاح!</p>";
  echo "<a href='manage_portal_forms.php' class='text-blue-600 underline'>🔙 الرجوع</a>";

} else {
  echo "🚫 طريقة الطلب غير صحيحة.";
}
