<?php
require_once '../config/db.php';

$department_id = $_POST['department_id'] ?? null;
$form_id = $_POST['form_id'] ?? null;

if (!$department_id || !$form_id) {
  exit("❌ بيانات ناقصة.");
}

$stmt = $conn->prepare("SELECT * FROM custom_forms WHERE id = ? AND department_id = ?");
$stmt->execute([$form_id, $department_id]);
$form = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$form) {
  exit("❌ النموذج غير موجود.");
}

$fields = json_decode($form['fields'], true);

$task_title = "طلب من البوابة - " . date("Y-m-d H:i");
$task_description = "تفاصيل الطلب:

";

foreach ($fields as $field) {
  $value = $_POST[$field['name']] ?? '';
  $task_description .= "- " . $field['label'] . ": " . htmlspecialchars($value) . "
";
}

$stmt = $conn->prepare("INSERT INTO tasks (title, description, department_id, status, created_at) VALUES (?, ?, ?, ?, NOW())");
$stmt->execute([$task_title, $task_description, $department_id, 'جديد']);

$task_id = $conn->lastInsertId();

if (!empty($_FILES['attachment']['name'])) {
  $upload_dir = 'uploads/';
  $filename = uniqid() . "_" . basename($_FILES['attachment']['name']);
  $target_path = $upload_dir . $filename;

  if (move_uploaded_file($_FILES['attachment']['tmp_name'], $target_path)) {
    $stmt = $conn->prepare("INSERT INTO attachments (task_id, file_name, file_path, uploaded_at) VALUES (?, ?, ?, NOW())");
    $stmt->execute([$task_id, $filename, $target_path]);
  }
}

echo "<div class='p-6 bg-white max-w-xl mx-auto mt-10 text-center rounded shadow'>";
echo "<p class='text-green-600 font-bold text-lg mb-4'>✅ تم إرسال الطلب بنجاح!</p>";
echo "<a href='../custom_forms/portal.php' class='text-blue-600 underline'>🔙 العودة إلى البوابة</a>";
echo "</div>";