<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  require_once '../config/db.php';

  $name = $_POST['name'] ?? '';
  $parent_id = !empty($_POST['parent_id']) ? $_POST['parent_id'] : null;

  if ($name) {
    $stmt = $conn->prepare("INSERT INTO departments (name, parent_id) VALUES (?, ?)");
    $stmt->execute([$name, $parent_id]);
    header("Location: index.php");
    exit;
  }
}

// جلب الإدارات الرئيسية فقط (اللي ما لها parent_id)
require_once '../config/db.php';
$mainDepartments = $conn->query("SELECT id, name FROM departments WHERE parent_id IS NULL")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إضافة إدارة</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
  .move-button {
    background-color: #4d70f4;
    border-radius: 15px !important;
  }
</style>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-xl mx-auto">
    <h1 class="text-xl font-bold mb-4">➕ إضافة إدارة جديدة</h1>
    <form method="POST" class="space-y-4 bg-white p-4 rounded shadow">
      <div>
        <label class="block mb-1 text-sm">اسم الإدارة</label>
        <input type="text" name="name" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block mb-1 text-sm">تابعة لـ</label>
        <select name="parent_id" class="w-full border rounded px-3 py-2">
          <option value="">إدارة رئيسية</option>
          <?php foreach ($mainDepartments as $dept): ?>
            <option value="<?= $dept['id'] ?>"><?= htmlspecialchars($dept['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <button type="submit" class=" text-white px-4 py-1 rounded hover:bg-blue-700 move-button">حفظ</button>
    </form>
  </div>
</body>
</html>
