<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// التحقق من الجلسة
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['name']) || !isset($_SESSION['user']['email']) || !isset($_SESSION['user']['role']) || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];
$user_secret_level = $user['secret_level'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$currentUserColorId = $user['color_id'];

allow_roles(['admin']);

$departments = $conn->query("SELECT * FROM departments ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة أوقات دوام الإدارات</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class=" text-right">

  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class=" p-10">

<div class="max-w-3xl mx-auto mt-12 main-card p-8">
  <h1 class="text-2xl font-bold mb-8">أوقات دوام الإدارات</h1>
  <table class="w-full border text-center">
    <thead>
      <tr class="bg-gray-200">
        <th class="p-2">#</th>
        <th class="p-2">اسم الإدارة</th>
        <th class="p-2">إجراءات</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($departments as $dep): ?>
      <tr>
        <td class="p-2"><?= $dep['id'] ?></td>
        <td class="p-2"><?= htmlspecialchars($dep['name']) ?></td>
        <td class="p-2">
          <button class="bg-blue-600 text-white px-4 py-1 rounded workdays-btn"
                  data-id="<?= $dep['id'] ?>"
                  data-name="<?= htmlspecialchars($dep['name']) ?>">
            إدارة الدوام
          </button>
        </td>
      </tr>
      <?php endforeach ?>
    </tbody>
  </table>
</div>

<!-- مودال إدارة الدوام -->
<div id="workdays-modal" class="fixed inset-0 bg-black bg-opacity-40 flex justify-center items-center z-50 hidden">
  <div class="bg-white rounded-xl w-[480px] max-w-full p-6 relative">
    <button onclick="$('#workdays-modal').addClass('hidden')" class="absolute left-2 top-2 text-xl">&times;</button>
    <h2 class="text-xl font-bold mb-4" id="modal-title">إدارة أوقات الدوام</h2>
    <form id="workdays-form">
      <input type="hidden" name="department_id" id="modal-department-id">
      <table class="w-full border mb-4">
        <thead>
          <tr>
            <th>اليوم</th>
            <th>عمل؟</th>
            <th>الشفت</th>
            <th>من</th>
            <th>إلى</th>
          </tr>
        </thead>
        <tbody id="days-table">
          <!-- يعبى بالجافاسكربت -->
        </tbody>
      </table>
      <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded">حفظ التعديلات</button>
    </form>
  </div>
</div>

<script>
const weekDays = [
  {val: 0, name: 'الأحد'}, {val: 1, name: 'الإثنين'},
  {val: 2, name: 'الثلاثاء'}, {val: 3, name: 'الأربعاء'},
  {val: 4, name: 'الخميس'}, {val: 5, name: 'الجمعة'}, {val: 6, name: 'السبت'}
];

// فتح المودال وطلب بيانات الدوام
$('.workdays-btn').on('click', function() {
  const depId = $(this).data('id');
  const depName = $(this).data('name');
  $('#modal-title').text('إدارة أوقات دوام: ' + depName);
  $('#modal-department-id').val(depId);

  // AJAX يجيب الجدول الحالي
  $.get('get_department_workdays.php', {department_id: depId}, function(data){
    let days = data && data.length ? data : [];
    let html = '';
    for (let i = 0; i < 7; i++) {
      let row = days.find(d => parseInt(d.day_of_week) === i) || {};
      html += `<tr>
        <td>${weekDays[i].name}</td>
        <td><input type="checkbox" name="is_working[${i}]" value="1" ${row.is_working==1?'checked':''}></td>
        <td>
          <select name="shift_type[${i}]" class="border rounded">
            <option value="morning" ${row.shift_type=='morning'?'selected':''}>صباحي</option>
            <option value="evening" ${row.shift_type=='evening'?'selected':''}>مسائي</option>
            <option value="full"    ${row.shift_type=='full'?'selected':''}>كامل</option>
          </select>
        </td>
        <td><input type="time" name="start_time[${i}]" value="${row.start_time||''}" class="border rounded w-24"></td>
        <td><input type="time" name="end_time[${i}]" value="${row.end_time||''}" class="border rounded w-24"></td>
      </tr>`;
    }
    $('#days-table').html(html);
    $('#workdays-modal').removeClass('hidden');
  }, 'json');
});

// حفظ التعديلات
$('#workdays-form').on('submit', function(e){
  e.preventDefault();
  $.post('save_department_workdays.php', $(this).serialize(), function(res){
    alert(res.success ? 'تم حفظ الدوام بنجاح' : 'خطأ في الحفظ');
    $('#workdays-modal').addClass('hidden');
  },'json');
});
</script>

</body>
</html>
