<?php
require_once '../config/db.php';

$id = $_GET['id'] ?? null;
if (!$id) die("معرف غير صالح");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'] ?? '';
  $parent_id = !empty($_POST['parent_id']) ? $_POST['parent_id'] : null;

  if ($name) {
    $stmt = $conn->prepare("UPDATE departments SET name = ?, parent_id = ? WHERE id = ?");
    $stmt->execute([$name, $parent_id, $id]);
    header("Location: index.php");
    exit;
  }
}

// جلب بيانات الإدارة الحالية
$stmt = $conn->prepare("SELECT * FROM departments WHERE id = ?");
$stmt->execute([$id]);
$dept = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$dept) die("الإدارة غير موجودة");

// جلب الإدارات الرئيسية الأخرى (بدون نفس الإدارة)
$stmt2 = $conn->prepare("SELECT id, name FROM departments WHERE parent_id IS NULL AND id != ?");
$stmt2->execute([$id]);
$mainDepartments = $stmt2->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل إدارة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-xl mx-auto">
    <h1 class="text-xl font-bold mb-4">✏️ تعديل الإدارة</h1>
    <form method="POST" class="space-y-4 bg-white p-4 rounded shadow">
      <div>
        <label class="block mb-1 text-sm">اسم الإدارة</label>
        <input type="text" name="name" value="<?= htmlspecialchars($dept['name']) ?>" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block mb-1 text-sm">تابعة لـ</label>
        <select name="parent_id" class="w-full border rounded px-3 py-2">
          <option value="">إدارة رئيسية</option>
          <?php foreach ($mainDepartments as $main): ?>
            <option value="<?= $main['id'] ?>" <?= $dept['parent_id'] == $main['id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($main['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <button type="submit" class="  px-4 py-1 rounded hover:bg-green-700" style="background-color: #7be667;border-radius:15px !important; color:black;">تحديث</button>
    </form>
  </div>
</body>
</html>
