<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// التحقق من الجلسة
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['name']) || !isset($_SESSION['user']['email']) || !isset($_SESSION['user']['role']) || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];
$user_secret_level = $user['secret_level'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$currentUserColorId = $user['color_id'];

allow_roles(['admin']);

// جلب الإدارات الرئيسية فقط
$mainDepartments = $conn->query("SELECT * FROM departments WHERE parent_id IS NULL ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>الإدارات</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

    .text-button {
      color: #ffffff !important;
    }


    .edit-button:hover , .view-button:hover , .download-button:hover , .delete-button:hover {
      color: <?= isset($currentUserColorId) && $currentUserColorId == 3 ? '#FFFFFF' : '#000000'; ?> !important;
}

.edit-button {
      background-color: #8BFB75 !important;
      color : #0e162a !important;  
      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;
      line-height: 1.5;
    }

    .delete-button {
      background-color: #FD7474  !important;      
      color: #FFFFFF!important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;
      line-height: 1.5;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .move-button:hover,
    .view-tasks:hover {
      background-color: rgb(19, 11, 57) !important;
    }
  </style>
</head>

<body class=" text-right">

  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class=" p-10">

    <!-- ✅ محتوى الصفحة -->
    <div class="h-20"></div>
    <div class="max-w-3xl mx-auto">
<?php $helpHref = file_exists(__DIR__.'/help.php') ? 'help.php' : 'instructions.php'; ?>
<div class="flex justify-between items-center mb-6">
  <h1 class="text text-xl font-bold">📁 قائمة الإدارات</h1>

  <div class="flex items-center gap-2">
    <a href="add.php" class="move-button text-button px-4 py-2 rounded">➕ إضافة إدارة</a>

    <a href="<?= htmlspecialchars($helpHref) ?>" target="_blank" rel="noopener"
       class="move-button text-button px-4 py-2 rounded no-print inline-flex items-center gap-1"
       title="تعليمات الإدارات">❓ تعليمات</a>
  </div>
</div>

      <table class="card w-full text-sm border">
        <thead class="">
          <tr>
            <th class="p-2 border">#</th>
            <th class="p-2 border">اسم الإدارة</th>
            <th class="p-2 border">الإجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($mainDepartments as $main): ?>
            <tr class=" font-bold">
              <td class="p-2 border"><?= $main['id'] ?></td>
              <td class="p-2 border">📁 <?= htmlspecialchars($main['name']) ?></td>
              <td class="p-2 border">
  <a href="edit.php?id=<?= $main['id'] ?>" class="text-blue-600 edit-button">تعديل</a> |
  <a href="delete.php?id=<?= $main['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')" class="text-red-600 delete-button">حذف</a> |
  <button class="move-button text-button px-2 py-1 rounded" onclick="openWorkdaysModal(<?= $main['id'] ?>, '<?= htmlspecialchars($main['name']) ?>')">إدارة الدوام</button>
</td>


            </tr>
            <?php
            $subStmt = $conn->prepare("SELECT * FROM departments WHERE parent_id = ?");
            $subStmt->execute([$main['id']]);
            $subDepartments = $subStmt->fetchAll(PDO::FETCH_ASSOC);
            ?>
            <?php foreach ($subDepartments as $sub): ?>
              <tr class="">
                <td class="p-2 border"><?= $sub['id'] ?></td>
                <td class="p-2 border pl-6">↳ <?= htmlspecialchars($sub['name']) ?></td>
<td class="p-2 border">
  <a href="edit.php?id=<?= $sub['id'] ?>" class="text-blue-600 edit-button">تعديل</a> |
  <a href="delete.php?id=<?= $sub['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')" class="text-red-600 delete-button">حذف</a> |
  <button class="move-button text-button px-2 py-1 rounded" onclick="openWorkdaysModal(<?= $sub['id'] ?>, '<?= htmlspecialchars($sub['name']) ?>')">إدارة الدوام</button>
</td>

              </tr>
            <?php endforeach; ?>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
<!-- مودال إدارة الدوام -->
<div id="workdaysModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center">
  <div class="bg-white rounded-lg p-6 max-w-2xl w-full">
    <div class="flex justify-between items-center mb-4">
      <h2 class="text-xl font-bold" id="workdaysDeptName">إدارة الدوام</h2>
      <button onclick="closeWorkdaysModal()" class="text-xl">&times;</button>
    </div>
    <form id="workdaysForm">
      <input type="hidden" name="department_id" id="workdaysDeptId">
      <div id="workdaysTable"></div>
      <div class="mt-4 text-center">
        <button type="submit" class="bg-blue-600 text-white px-8 py-2 rounded-xl hover:bg-blue-800 transition">حفظ</button>
      </div>
    </form>
  </div>
</div>

<script>
function openWorkdaysModal(deptId, deptName) {
  document.getElementById('workdaysDeptId').value = deptId;
  document.getElementById('workdaysDeptName').textContent = 'إدارة الدوام - ' + deptName;
  // جلب بيانات الدوام بالأجاكس
  fetch('get_department_workdays.php?department_id=' + deptId)
    .then(res => res.json())
    .then(data => {
      document.getElementById('workdaysTable').innerHTML = renderWorkdaysTable(data);
      document.getElementById('workdaysModal').classList.remove('hidden');
    });
}

function closeWorkdaysModal() {
  document.getElementById('workdaysModal').classList.add('hidden');
}

function renderWorkdaysTable(data) {
  const days = ['الأحد','الاثنين','الثلاثاء','الأربعاء','الخميس','الجمعة','السبت'];
  let html = '<table class="w-full text-center border mb-3"><thead><tr><th>اليوم</th><th>يومي؟</th><th>نوع الشفت</th><th>من</th><th>إلى</th></tr></thead><tbody>';
  for(let i=0; i<7; i++) {
    const row = data.find(x=>parseInt(x.day_of_week)===i) || {};
    html += `<tr>
      <td>${days[i]}</td>
      <td><input type="checkbox" name="is_working[${i}]" ${row.is_working==1?'checked':''}></td>
      <td>
        <select name="shift_type[${i}]">
          <option value="morning" ${row.shift_type=='morning'?'selected':''}>صباحي</option>
          <option value="evening" ${row.shift_type=='evening'?'selected':''}>مسائي</option>
          <option value="full" ${row.shift_type=='full'?'selected':''}>كامل</option>
        </select>
      </td>
      <td><input type="time" name="start_time[${i}]" value="${row.start_time||''}"></td>
      <td><input type="time" name="end_time[${i}]" value="${row.end_time||''}"></td>
    </tr>`;
  }
  html += '</tbody></table>';
  return html;
}

document.addEventListener('DOMContentLoaded', function(){
  document.getElementById('workdaysForm').onsubmit = function(e){
    e.preventDefault();
    const formData = new FormData(this);
    fetch('save_department_workdays.php', {
      method: 'POST',
      body: formData
    }).then(res=>res.json()).then(data=>{
      if(data.success){
        alert('تم حفظ الدوام بنجاح');
        closeWorkdaysModal();
      }else{
        alert('فشل الحفظ');
      }
    });
  }
});
</script>


</body>

</html>