<?php
require_once '../config/db.php';
require_once '../auth.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  die("❌ رقم الحقل غير صالح");
}

$id = $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM custom_fields WHERE id = ?");
$stmt->execute([$id]);
$field = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$field) {
  die("❌ لم يتم العثور على الحقل");
}

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $label = $_POST['label'];
  $type = $_POST['type'];
  $new_department_id = $role === 'admin' ? ($_POST['department_id'] ?? $field['department_id']) : $department_id;

  $updateStmt = $conn->prepare("UPDATE custom_fields SET label = ?, type = ?, department_id = ? WHERE id = ?");
  $updateStmt->execute([$label, $type, $new_department_id, $id]);

  header("Location: index.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل الحقل</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <h1 class="text-xl font-bold mb-4">✏️ تعديل الحقل</h1>

  <form method="POST" class="space-y-4 max-w-md">
    <div>
      <label class="block mb-1">اسم الحقل</label>
      <input type="text" name="label" value="<?= htmlspecialchars($field['label']) ?>" required class="w-full border px-3 py-2 rounded">
    </div>

    <div>
      <label class="block mb-1">نوع الحقل</label>
      <select name="type" class="w-full border px-3 py-2 rounded">
        <option value="text" <?= $field['type'] === 'text' ? 'selected' : '' ?>>نص</option>
        <option value="number" <?= $field['type'] === 'number' ? 'selected' : '' ?>>رقم</option>
        <option value="date" <?= $field['type'] === 'date' ? 'selected' : '' ?>>تاريخ</option>
      </select>
    </div>

    <?php if ($role === 'admin'): ?>
    <div>
      <label class="block mb-1">الإدارة</label>
      <select name="department_id" class="w-full border px-3 py-2 rounded">
        <?php foreach ($departments as $dep): ?>
          <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $field['department_id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($dep['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <?php endif; ?>

    <button class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700" style="background-color: #7be667;">💾 حفظ التعديلات</button>
  </form>
</body>
</html>
