<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// أول شي نتأكد فيه جلسة تسجيل دخول

if (
  !isset($_SESSION['user']) ||
  !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])
) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}


$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];
if (!in_array($role, ['manager', 'admin'])) {
  echo "<h2 style='text-align:center; margin-top:50px;'>🚫 صلاحية غير كافية</h2>";
  exit;
}

// جلب الإدارات إذا كان المدير العام
if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
  // استخدام قيمة محددة فقط عند الإدخال لعرض الحقول
  $target_department_id = $_GET['department_id'] ?? null;

  if ($target_department_id) {
    $stmt = $conn->prepare("SELECT cf.*, d.name AS department_name
                        FROM custom_fields cf
                        LEFT JOIN departments d ON cf.department_id = d.id
                        WHERE cf.department_id = ?");

    $stmt = $conn->prepare("SELECT cf.*, d.name AS department_name
                        FROM custom_fields cf
                        LEFT JOIN departments d ON cf.department_id = d.id
                        WHERE cf.department_id = ?");


    $stmt->execute([$target_department_id]);
  } else {
    $stmt = $conn->query("SELECT cf.*, d.name AS department_name
                      FROM custom_fields cf
                      LEFT JOIN departments d ON cf.department_id = d.id");
  }
  $fields = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
  // للمدير العادي يعرض فقط حقول إدارته
  $stmt = $conn->prepare("SELECT * FROM custom_fields WHERE department_id = ?");
  $stmt->execute([$department_id]);
  $fields = $stmt->fetchAll(PDO::FETCH_ASSOC);
}


?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>حقول المهام المخصصة</title>
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Include Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

  <!-- Include jQuery (required by Select2) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Include Select2 JS -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

  <style>
    /* Custom styles to make the Select2 dropdown larger */
    .select2-container .select2-selection--single {
      height: 48px;
      /* Increase height of the select box */
      line-height: 48px;
      /* Align text vertically */
      font-size: 12px;
      /* Larger font size for selected item */
    }

    .select2-container--default .select2-selection--single {
      background-color: <?php echo $userThemeNavColor; ?> !important;
      border: none;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
      line-height: 48px;
      color: <?php echo $userThemeTextColor; ?> !important;
      /* Ensure text aligns with height */
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 48px;
      /* Adjust arrow height to match */
    }

    .select2-dropdown {
      font-size: 12px;
      /* Larger font size for dropdown options */
    }

    .select2-results__option {
      padding: 12px;
      /* More padding for larger options */
      line-height: 24px;
      /* Adjust line height for larger square and text */
    }

    /* Optional: Ensure the select takes full width or a specific width */
    .select2-container {
      width: 100% !important;
      /* Full width, or set a specific width like 300px */
    }

    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,
    h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .move-button:hover,
    .view-tasks:hover {
      background-color: rgb(19, 11, 57) !important;
    }




    .edit-button:hover,
    .view-button:hover,
    .download-button:hover,
    .delete-button:hover {
      color: <?= isset($currentUserColorId) && $currentUserColorId == 3 ? '#FFFFFF' : '#000000'; ?> !important;
    }

    .edit-button {
      background-color: #8BFB75 !important;
      color: #0e162a !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding-top: 5px;
      padding-bottom: 5px;
      text-decoration: none;
      box-sizing: border-box;

    }

    .delete-button {
      background-color: #FD7474 !important;
      color: #FFFFFF !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }
  </style>
</head>

<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>


<body class="bg-gray-100 text-right">

  <!-- تعويض ارتفاع الناف بار -->
  <div class="h-20"></div>
  <div class="max-w-5xl mx-auto p-4">
    <h1 class="text text-xl font-bold mb-4">🛠️ إدارة الحقول المخصصة للمهام</h1>

    <form action="store.php" method="POST" class="mb-6">
      <div class="grid grid-cols-2 gap-4">
        <input type="text" name="label" required placeholder="اسم الحقل" class="card border rounded px-3 py-2">
        <select name="type" class="card border rounded px-3 py-2">
          <option value="text">نص</option>
          <option value="number">رقم</option>
          <option value="date">تاريخ</option>
          <option value="dropdown">قائمة منسدلة</option>

        </select>
      </div>


      <div id="options_input" class="hidden">
        <label class="block text-sm mb-1 mt-2">القيم (افصل بينها بفاصلة)</label>
        <input type="text" name="options" class="border rounded px-3 py-2 w-full" placeholder="مثال: نعم,لا,ربما">
      </div>

      <?php if ($role === 'admin'): ?>
        <div class="mt-4">
          <label class="block text-sm mb-1">الإدارة</label>
          <select name="department_id" required class="card border rounded px-3 py-2 w-full">
            <?php foreach ($departments as $dep): ?>
              <option value="<?= $dep['id'] ?>" <?= isset($target_department_id) && $target_department_id == $dep['id'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($dep['name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
      <?php else: ?>
        <input type="hidden" name="department_id" value="<?= $department_id ?>">
      <?php endif; ?>

      <button class=" move-button text-button   mt-4 text-white px-4 py-2 rounded">➕ إضافة الحقل</button>
    </form>

    <table class="card min-w-full bg-white rounded shadow">
      <thead>
        <tr class="">
          <th class="text-right px-4 py-2">اسم الحقل</th>
          <th class="text-right px-4 py-2">النوع</th>
          <th class="text-right px-4 py-2">الإدارة</th> <!-- ✅ هذا هو المطلوب -->
          <th class="text-right px-4 py-2">الخيارات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($fields as $field): ?>
          <tr>
            <td class="px-4 py-2 border"><?= htmlspecialchars($field['label']) ?></td>
            <td class="px-4 py-2 border"><?= htmlspecialchars($field['type']) ?></td>
            <td class="px-4 py-2 border"><?= htmlspecialchars($field['department_name'] ?? '—') ?></td>

            <td class="px-4 py-2 border">
              <button onclick="openEditModal(
              <?= $field['id'] ?>,
              '<?= $field['label'] ?>',
              '<?= $field['type'] ?>',
              <?= $field['department_id'] ?>
            )" class="text-blue-600 edit-button">
                ✏️ تعديل
              </button>


              |
              <a href="delete.php?id=<?= $field['id'] ?>" class="text-red-600 delete-button" onclick="return confirm('هل أنت متأكد؟')">🗑 حذف</a>
            </td>

          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <!-- مودال التعديل -->
  <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white p-6 rounded shadow w-full max-w-md relative">
      <h2 class="text-lg font-bold mb-4">✏️ تعديل الحقل</h2>
      <form id="editFieldForm">

        <input type="hidden" name="edit_id" id="edit_id">

        <div class="mb-4">
          <label class="block mb-1">اسم الحقل</label>
          <input type="text" name="edit_label" id="edit_label" class="w-full border px-3 py-2 rounded" required>
        </div>

        <div class="mb-4">
          <label class="block mb-1">نوع الحقل</label>
          <select name="edit_type" id="edit_type" class="w-full border px-3 py-2 rounded">
            <option value="text">نص</option>
            <option value="number">رقم</option>
            <option value="date">تاريخ</option>
          </select>
        </div>

        <?php if ($role === 'admin'): ?>
          <div class="mb-4">
            <label class="block mb-1">الإدارة</label>
            <select name="edit_department_id" id="edit_department_id" class="w-full border px-3 py-2 rounded">
              <?php foreach ($departments as $dep): ?>
                <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
        <?php else: ?>
          <input type="hidden" name="edit_department_id" id="edit_department_id" value="<?= $department_id ?>">
        <?php endif; ?>

        <div class="flex justify-end gap-2">
          <button type="button" onclick="closeEditModal()" class="px-4 py-2 0 text-white rounded">❌ إغلاق</button>
          <button type="submit" class="px-4 py-2  text-white rounded" style="background-color: #7be667;">💾 حفظ التعديلات</button>
        </div>
      </form>
    </div>
  </div>
  <script>
    $(document).ready(function() {
      $('#theme_color_select').select2({
        templateResult: formatColorOption,
        templateSelection: formatColorOption
      });

      // Function to format the dropdown option and selected item
      function formatColorOption(option) {
        if (!option.id) {
          return option.text; // Placeholder or "No colors available"
        }
        // Get the hex code from the data-hex attribute
        var hexCode = $(option.element).data('hex');
        // Create a colored square and append the color name
        var $option = $(
          '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
        );
        return $option;
      }

      // Ensure form submission still works
      $('#theme_color_select').on('select2:select', function(e) {
        $(this).closest('form').submit();
      });
    });

    function openEditModal(id, label, type, department_id, options = '') {
      document.getElementById('edit_id').value = id;
      document.getElementById('edit_label').value = label;
      document.getElementById('edit_type').value = type;
      document.getElementById('edit_department_id').value = department_id;

      const optionsInputDiv = document.getElementById('edit_options_input');
      const optionsInput = document.getElementById('edit_options');
      if (type === 'dropdown') {
        optionsInputDiv.classList.remove('hidden');
        optionsInput.value = options;
      } else {
        optionsInputDiv.classList.add('hidden');
        optionsInput.value = '';
      }

      document.getElementById('editModal').classList.remove('hidden');
      document.getElementById('editModal').classList.add('flex');
    }

    function closeEditModal() {
      document.getElementById('editModal').classList.add('hidden');
      document.getElementById('editModal').classList.remove('flex');
    }

    // عرض حقل القيم تلقائي إذا اختير نوع dropdown عند الإضافة
    const typeSelect = document.getElementById('field_type');
    const optionsDiv = document.getElementById('options_input');
    if (typeSelect) {
      typeSelect.addEventListener('change', () => {
        optionsDiv.classList.toggle('hidden', typeSelect.value !== 'dropdown');
      });
    }

    document.getElementById('editFieldForm').addEventListener('submit', async function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      const response = await fetch('store.php', {
        method: 'POST',
        body: formData
      });
      const result = await response.text();
      if (response.ok && result.includes('success')) {
        alert('✅ تم تعديل الحقل بنجاح!');
        closeEditModal();
        location.reload();
      } else {
        alert('❌ حصل خطأ أثناء الحفظ!');
      }
    });
  </script>
</body>

</html>