<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/config/db.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/authorize.php';

$user = $_SESSION['user'] ?? [];
$role = $user['role'] ?? '';

$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];
?>

<!-- Include Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- Include jQuery (required by Select2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Include Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
  /* Custom styles to make the Select2 dropdown larger */
  .select2-container .select2-selection--single {
    height: 48px;
    /* Increase height of the select box */
    line-height: 48px;
    /* Align text vertically */
    font-size: 12px;
    /* Larger font size for selected item */
  }

  .select2-container--default .select2-selection--single {
    background-color: <?php echo $userThemeNavColor; ?> !important;
    border: none;
  }

  .select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 48px;
    color: <?php echo $userThemeTextColor; ?> !important;
    /* Ensure text aligns with height */
  }

  .select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 48px;
    /* Adjust arrow height to match */
  }

  .select2-dropdown {
    font-size: 12px;
    /* Larger font size for dropdown options */
  }

  .select2-results__option {
    padding: 12px;
    /* More padding for larger options */
    line-height: 24px;
    /* Adjust line height for larger square and text */
  }

  /* Optional: Ensure the select takes full width or a specific width */
  .select2-container {
    width: 100% !important;
    /* Full width, or set a specific width like 300px */
  }

  body,
  a:hover {
    background-color: <?php echo $userThemeColor; ?> !important;
  }

  nav,
  .card {
    background-color: <?php echo $userThemeNavColor; ?> !important;
  }

  .text,
  label,
  option,
  h2,
  select,
  a {
    color: <?php echo $userThemeTextColor; ?> !important;
  }

  option {
    text-align: center;
  }
</style>
<?php
$isSport = isset($user['color']['color_name']) && $user['color']['color_name'] === 'سبورت';
if ($isSport): ?>
<style>
  /* ===== Sport Theme Overrides (Glass + Gradient) ===== */
  body{
    color:#e9eefb !important;
    background:
      radial-gradient(1100px 520px at 80% -10%, #203070 0%, transparent 60%),
      radial-gradient(800px 500px at 0% 90%, #1a244d 0%, transparent 60%),
      linear-gradient(180deg,#0b1023,#121b35) !important;
  }

  /* Glass surfaces للناف والكروت والقوائم */
  nav, .card, .select2-dropdown, 
  .select2-container--default .select2-selection--single {
    background: rgba(255,255,255,.06) !important;
    border: 1px solid rgba(255,255,255,.12) !important;
    backdrop-filter: blur(14px) saturate(130%) !important;
    -webkit-backdrop-filter: blur(14px) saturate(130%) !important;
    box-shadow: 0 10px 30px rgba(0,0,0,.35) !important;
  }
  @supports not ((-webkit-backdrop-filter: blur(14px)) or (backdrop-filter: blur(14px))){
    nav, .card, .select2-dropdown, 
    .select2-container--default .select2-selection--single { background: rgba(10,14,28,.9) !important; }
  }

  /* نصوص */
  .text, label, h1, h2, h3, h4, h5, h6, th, td, a, option { color:#e9eefb !important; }
  /* نص ثانوي (تلميحات ومحاور الشارت) */
  :root{ --muted:#9aa3b2; }
  
  /* Select2 */
  .select2-container .select2-selection--single { height:48px; line-height:48px; font-size:12px; }
  .select2-container--default .select2-selection--single .select2-selection__rendered { color:#e9eefb !important; }
  .select2-results__option { color:#e9eefb; }
</style>
<?php endif; ?>

<!-- ناف بار احترافي -->
<nav class="bg-white shadow-md fixed w-full z-50">
  <div class="max-w-7xl mx-auto px-4">
    <div class="flex justify-between items-center h-18">
      <!--  create a dropdown to get the colors from colors table -->
      <form method="POST" action="../tasks/update_color.php" style=" width: 200px;display: flex;">
        <label class="text-lg font-bold py-2 ml-2">النمط:</label>
        <select name="theme_color_id" id="theme_color_select" class="card" onchange="this.form.submit()">
          <?php if (!empty($allColors)): ?>
            <?php foreach ($allColors as $color): ?>
              <option
                value="<?php echo htmlspecialchars($color['id']); ?>"
                data-hex="<?php echo htmlspecialchars($color['hex_code']); ?>"
                <?php echo ($color['id'] == $currentUserColorId) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($color['color_name']); ?>
              </option>
            <?php endforeach; ?>
          <?php else: ?>
            <option value="">No colors available</option>
          <?php endif; ?>
        </select>
      </form>


      <!-- القوائم الرئيسية -->
      <div class="hidden md:flex items-center space-x-6 rtl:space-x-reverse text-base font-medium">
 
        <!-- المهام -->
        <?php if (in_array($role, ['employee', 'manager', 'admin'])): ?>
          <div class="relative inline-block text-right">
            <button id="taskMenu" class="text text-lg hover:text-indigo-700">📋 المعاملات </button>
            <div id="taskDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/tasks/kanban_new.php" class="block px-4 py-2 hover:bg-gray-100">🔄 بالمراحل</a>
              <a href="/erp_task_system/tasks/list.php" class="block px-4 py-2 hover:bg-gray-100">📋 قائمة المعاملات</a>
              <?php if (in_array($role, ['manager', 'admin'])): ?>
                <a href="/erp_task_system/tasks/archive_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📦 الأرشيف</a>
              <?php endif; ?>
              <?php if (in_array($role, ['admin'])): ?>
                <a href="/erp_task_system/tasks/archived_tasks.php" class="block px-4 py-2 hover:bg-gray-100">🗑️ المعاملات المحذوفة</a>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>

        <!-- النماذج -->
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="formMenu" class="text text-lg hover:text-indigo-700">📄 النماذج </button>
            <div id="formDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/templates/index.php" class="block px-4 py-2 hover:bg-gray-100">📄 إدارة نماذج المراحل</a>
              <a href="/erp_task_system/custom_forms/manage_portal_forms.php" class="block px-4 py-2 hover:bg-gray-100">🧾 نماذج الإدارات</a>
              <a href="/erp_task_system/custom_forms/portal.php" class="block px-4 py-2 hover:bg-gray-100">📝 بوابة الطلبات</a>
            </div>
          </div>
        <?php endif; ?>

        <!-- الإدارات -->
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="adminMenu" class="text text-lg hover:text-indigo-700">🏢 الإدارات </button>
            <div id="adminDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/departments/index.php" class="block px-4 py-2 hover:bg-gray-100">📁 الإدارات</a>
      <a href="/erp_task_system/tasks/task_types.php" class="block px-4 py-2 hover:bg-gray-100">🏷️ إدارة التصنيفات</a>
      <a href="/erp_task_system/projects/projects.php" class="block px-4 py-2 hover:bg-gray-100">📁 إدارة المشاريع</a>
       
              <a href="/erp_task_system/users/index.php" class="block px-4 py-2 hover:bg-gray-100">👥 الموارد البشرية</a>
              <a href="/erp_task_system/fields/index.php" class="block px-4 py-2 hover:bg-gray-100">📑 حقول المعاملات</a>
              <a href="/erp_task_system/stages/index.php" class="block px-4 py-2 hover:bg-gray-100">📌 المراحل</a>
            </div>
          </div>
        <?php endif; ?>

        <!-- الربط الخارجي -->
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="integrationMenu" class="text text-lg hover:text-indigo-700">🔗 الربط </button>
            <div id="integrationDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/Integration/settings.php" class="block px-4 py-2 hover:bg-gray-100">⚙️ إعدادات الربط</a>
              <a href="/erp_task_system/Integration/index.php" class="block px-4 py-2 hover:bg-gray-100">🔗 إدارة الربط الخارجي</a>
              <a href="/erp_task_system/Integration/logs.php" class="block px-4 py-2 hover:bg-gray-100">📄 سجل الطلبات</a>
              <a href="/erp_task_system/Integration/webhook_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📥 معاملات Webhook</a>
            </div>
          </div>
        <?php endif; ?>

        <!-- لوحة التحكم -->
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/tasks/dashboard/index.php" class="text-lg hover:text-indigo-700">🏠 لوحة التحكم</a>
        <?php endif; ?>

        <!-- التقارير -->
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/reports/report_builder.php" class="text-lg hover:text-indigo-700">📈 التقارير</a>
        <?php endif; ?>
      </div>

      <!-- المستخدم -->
      <div class="relative inline-block text-left">
        <button id="userMenuButton" class="text text-lg flex items-center  text-gray-800 font-bold py-2 px-4 rounded">
          <?= htmlspecialchars($user['name'] ?? 'مستخدم') ?>
        </button>
        <div id="userDropdown" class="card origin-top-left absolute left-0 mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 hidden z-50 text-right px-2">
          <a href="/erp_task_system/users/profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">👤 الملف الشخصي</a>
          <a href="/erp_task_system/users/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">🚪 تسجيل خروج</a>
        </div>
      </div>
      <!-- شعار واسم المشروع -->
      <div class="flex items-center space-x-4 rtl:space-x-reverse">
        <a href="/erp_task_system/tasks/dashboard/index.php" class="flex items-center space-x-2 rtl:space-x-reverse">
          <img src="<?php if ($currentUserColorId != 3) echo '/erp_task_system/assets/logo.png';
                    else echo '/erp_task_system/assets/logo-dark.png'; ?> " alt="شعار أسرع" class="h-16 w-auto mt-2">
        </a>
      </div>


    </div>
  </div>
</nav>



<!-- تعويض ارتفاع الناف بار -->
<div class="h-20"></div>

<script>
  const menus = [{
      button: 'taskMenu',
      dropdown: 'taskDropdown'
    },
    {
      button: 'formMenu',
      dropdown: 'formDropdown'
    },
    {
      button: 'adminMenu',
      dropdown: 'adminDropdown'
    },
    {
      button: 'integrationMenu',
      dropdown: 'integrationDropdown'
    },
    {
      button: 'userMenuButton',
      dropdown: 'userDropdown'
    },
  ];

  menus.forEach(currentMenu => {
    const btn = document.getElementById(currentMenu.button);
    const dd = document.getElementById(currentMenu.dropdown);
    if (btn && dd) {
      btn.addEventListener('click', e => {
        e.stopPropagation();
        menus.forEach(menu => {
          const otherDd = document.getElementById(menu.dropdown);
          if (menu.dropdown !== currentMenu.dropdown && otherDd) {
            otherDd.classList.add('hidden');
          }
        });
        dd.classList.toggle('hidden');
      });
      window.addEventListener('click', e => {
        if (!dd.contains(e.target) && !btn.contains(e.target)) {
          dd.classList.add('hidden');
        }
      });
    }
  });

  $(document).ready(function() {
    $('#theme_color_select').select2({
      templateResult: formatColorOption,
      templateSelection: formatColorOption
    });

    // Function to format the dropdown option and selected item
    function formatColorOption(option) {
      if (!option.id) {
        return option.text; // Placeholder or "No colors available"
      }
      // Get the hex code from the data-hex attribute
      var hexCode = $(option.element).data('hex');
      // Create a colored square and append the color name
      var $option = $(
        '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
      );
      return $option;
    }

    // Ensure form submission still works
    $('#theme_color_select').on('select2:select', function(e) {
      $(this).closest('form').submit();
    });
  });
</script>