<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>بروشور نظام أسرع — عرض الخدمات والباقات</title>
<style>
  :root{
    --bg-start:#0b1023; /* سبورت */
    --bg-end:#121b35;
    --primary:#6f7dfb;
    --accent:#b36bff;
    --text:#e9eefb;
    --muted:#9aa3b2;
    --ink:#0e162a; /* نص غامق على الخلفية البيضاء */
    --ink-2:#334155; /* ثانوي */
    --ok:#16a34a; --warn:#f59e0b; --err:#ef4444;
    --card:#ffffff; --card-border:#e5e7eb; --badge-bg:#eef2ff; --badge-tx:#3730a3;
    --ring: #c7d2fe;
  }

  /* إعداد للطباعة A4 */
  @page { size: A4; margin: 8mm; }
  html, body{ margin:0; padding:0; background:#f4f6fb; font-family: system-ui, -apple-system, Segoe UI, Roboto, "Cairo", Tahoma, sans-serif; }
  .sheet{ width: 210mm; min-height: 297mm; margin: 0 auto; background: #fff; color: var(--ink); box-shadow: 0 18px 40px rgba(2,6,23,.08); border-radius: 12px; overflow: hidden; }

  /* زر الطباعة */
  .print-btn{
    position: fixed; inset-inline-end: 12px; inset-block-start: 12px; z-index: 1000;
    background: linear-gradient(135deg,var(--primary),var(--accent));
    color:#fff; border:none; border-radius: 999px; padding:10px 14px; font-weight:800; cursor:pointer;
    box-shadow: 0 10px 20px rgba(17,24,39,.18);
  }
  /* --- الشعار أكبر وعلى اليسار --- */
.hero .brand{
  display: flex;
  align-items: center;
  gap: 12px;
  flex-direction: row-reverse;   /* يخلي ترتيب العناصر من اليسار لليمين في RTL */
  margin-inline-start: auto;     /* يدز المجموعة كاملة لليسار */
}
.hero .brand img{
  height: 64px;                  /* كبرنا الشعار على الشاشة */
}

/* وقت الطباعة: نصغّر الشعار عشان تبقى صفحة وحدة */
@media print{
  .hero .brand img{
    height: 40px !important;
  }
}


  @media print{
    body{ background:#fff }
    .sheet{ box-shadow:none; border-radius:0 }
    .print-btn{ display:none !important; }

    /* ثبّت شبكة 12 عمود في الطباعة */
    .grid{ grid-template-columns: repeat(12, 1fr) !important; gap: 10px !important; }
    .col-12{ grid-column: 1 / -1 !important; }
    .col-7{ grid-column: span 7 !important; }
    .col-5{ grid-column: span 5 !important; }
    .col-6{ grid-column: span 6 !important; }
    .col-4{ grid-column: span 4 !important; }

    /* امنع تكسّر الكروت بين الصفحات */
    .hero, .card, .pricing, .footer{ break-inside: avoid; page-break-inside: avoid; }
    /* خلك محافظ على الألوان قدر الإمكان */
    .hero{ -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  }

  /* هيدر بخلفية سبورت */
  .hero{ background: linear-gradient(180deg, var(--bg-start), var(--bg-end)); color: var(--text); padding: 20mm 16mm 14mm; position: relative; }
  .hero .brand{ display:flex; align-items:center; gap:12px; }
  .brand img{ height: 38px; }
  .tag{ display:inline-flex; align-items:center; gap:8px; background: rgba(255,255,255,.12); border:1px solid rgba(255,255,255,.22); color:#fff; padding:6px 10px; border-radius: 999px; font-weight:700; font-size:12px; }
  .title{ margin:10px 0 6px; font-size: 30px; font-weight: 800; line-height: 1.15; 
    background:linear-gradient(135deg,#fff 0%, #cfd7ff 35%, #a8b3ff 70%, #e6d2ff 100%);
    -webkit-background-clip:text; background-clip:text; color:transparent;
    text-shadow:0 10px 30px rgba(0,0,0,.25);
  }
  .subtitle{ color:#e9eefb; opacity:.9; font-size:14px; max-width: 170mm; }

  /* أقسام داخلية */
  .content{ padding: 12mm 16mm 14mm; }
  .grid{ display:grid; grid-template-columns: repeat(12, 1fr); gap: 12px; }
  .col-4{ grid-column: span 4; }
  .col-6{ grid-column: span 6; }
  .col-7{ grid-column: span 7; }
  .col-5{ grid-column: span 5; }
  .col-12{ grid-column: 1 / -1; }

@media print{
  /* هيدر مضغوط */
  .hero{
    padding: 8mm 12mm 4mm !important;   /* كان ~20mm */
  }
  .hero .brand img{
    height: 70px !important;             /* كان 38px */
  }
  .hero .tag{
    display: none !important;            /* نخبي الشارة لتوفير مساحة */
  }
  .hero .title{
    font-size: 22px !important;          /* كان 30px */
    line-height: 1.2 !important;
    margin: 1mm 0 1mm !important;
  }
  .hero .subtitle{
    font-size: 11px !important;          /* كان 14px */
    max-width: none !important;
    margin: 0 !important;
  }

  /* مسافات أخف تحت الهيدر */
  .content{
    padding-top: 8mm !important;         /* كان 12mm */
  }

  /* اختياري: شدّة بسيطة على الكروت لتقليل التكسّر */
  .card, .pricing, .footer{
    break-inside: avoid;
    page-break-inside: avoid;
  }
}

  /* شاشة أصغر */
  @media (max-width: 900px){
    .sheet{ width:100%; min-height:auto; border-radius:0 }
    .grid{ grid-template-columns: repeat(6, 1fr);}
    .col-7{ grid-column: 1 / -1 }
    .col-5{ grid-column: 1 / -1 }
    .col-4{ grid-column: span 6 }
    .col-6{ grid-column: span 6 }
  }

  .card{ background: var(--card); border:1px solid var(--card-border); border-radius: 12px; padding: 14px; }
  .card h3{ margin:0 0 6px; font-size:16px; }
  .muted{ color: var(--ink-2); font-size: 13px; }

  .chips{ display:flex; flex-wrap:wrap; gap:8px; margin-top:8px }
  .chip{ background: var(--badge-bg); color: var(--badge-tx); border:1px solid var(--ring); padding:6px 10px; border-radius:999px; font-weight:700; font-size:12px }

  /* تسعير */
  .pricing{ background: #fff; border:2px solid #e5e7eb; border-radius: 14px; padding: 14px; }
  .price{ font-size: 34px; font-weight: 900; color: var(--ink); }
  .currency{ font-size: 14px; font-weight: 800; color: var(--ink-2) }
  .note{ font-size: 12px; color: var(--ink-2); }
  .ok{ color: var(--ok); font-weight:700 }
  .calc{ margin-top:10px; display:grid; grid-template-columns: 1fr 1fr; gap:10px; }
  .calc label{ font-size:12px; color: var(--ink-2); }
  .calc input{ border:1px solid #d1d5db; border-radius:10px; padding: 8px 10px; font-weight:700 }
  .calc .res{ background: #eef2ff; border:1px solid var(--ring); border-radius: 12px; padding:10px; font-weight:800; }

  .list{ margin: 6px 0 0 0; padding: 0 0 0 16px; }
  .list li{ margin: 6px 0; }

  /* فوتر */
  .footer{ display:flex; align-items:center; justify-content:space-between; gap:12px; padding: 10mm 16mm; background: #fbfbff; border-top:1px solid #eef2ff }
  .contact{ font-size: 13px; color: var(--ink-2) }
  .cta-online a{ display:inline-block; background: linear-gradient(135deg,var(--primary),var(--accent)); color:#fff; text-decoration:none; padding:10px 14px; border-radius: 999px; font-weight:800; }
  .qr{ text-align:center }
  .qr img{ width: 90px; height: 90px; border-radius: 8px; border:1px solid #e5e7eb }

  .kicker{ display:flex; align-items:center; gap:8px; font-weight:800; color:#111827; }
  .kicker b{ color:#1f2937 }
</style>
</head>
<body>

  <!-- زر الطباعة -->
  <button class="print-btn" onclick="window.print()" aria-label="طباعة">🖨️ طباعة</button>

  <div class="sheet">
    <!-- Hero / Header -->
    <section class="hero">
      <div class="brand">
        <!-- استبدل المسار حسب شعارك -->
        <img src="/erp_task_system/assets/logo-dark.png" alt="أسرع"/>
        <span class="tag">منصة ادارة الاعمال</span>
      </div>
      <h1 class="title">بروشور تعريفي — نظام «أسرع»</h1>
      <p class="subtitle">
        نظام سعودي موحّد لإدارة العملاء والمعاملات والمشاريع والمهام والموارد البشرية — بواجهة عربية سهلة وتقارير تفاعلية وربط خارجي ذكي.
      </p>
    </section>

    <section class="content">
      <div class="grid">
        <!-- عمود الميزات الأساسية -->
        <div class="col-7">
          <div class="card">
            <h3>المزايا والوظائف الأساسية</h3>
            <ul class="list">
              <li><b>المعاملات والمهام</b>: مراحل خاصة/مشتركة، سحب وإفلات، تعليقات ومرفقات، أرشفة تلقائية.</li>
              <li><b>المستخدمون والصلاحيات</b>: مدير عام، مدراء، موظفون، درجات سرية، نقل المعاملات والمهام بين الإدارات.</li>
              <li><b>الموارد البشرية</b>: ملفات الموظفين، الحضور والانصراف، الإجازات، المواقع المتعددة.</li>
              <li><b>الرواتب</b>: بنود رواتب مرنة، احتساب تأخيرات وغياب وأجر إضافي، تصدير مسير.</li>
              <li><b>النماذج والتواقيع</b>: توليد HTML/Word، توقيع وسحب، تحويل PDF وإرفاق تلقائي بالمهمة.</li>
              <li><b>العهدة والأصول</b>: طلبات، موافقات، تسليم واستلام، تتبّع السجلات.</li>
              <li><b>التقارير التفاعلية</b>: مُنشئ تقارير بفلترة متقدمة وإجماليات.</li>
              <li><b>الأمان</b>: صلاحيات دقيقة، سرية المستندات، سجلات عمليات.</li>
            </ul>
            <div class="chips">
              <span class="chip">واجهة عربية RTL</span>
              <span class="chip">ألوان وثيمات حسب المستخدم</span>
              <span class="chip">استيراد التأمينات</span>
              <span class="chip">لوحات مؤشرات</span>
            </div>
          </div>
        </div>

        <!-- عمود التسعير والحسبة -->
        <div class="col-5">
          <div class="pricing">
            <div class="kicker">💎 <b>الباقة الحصرية</b></div>
            <div style="margin:6px 0 2px">اشتراك سنوي يشمل حتى <b>30 موظف</b></div>
            <div class="price">5,000 <span class="currency">ريال/سنة</span></div>
            <div class="muted">للموظفين الإضافيين: <b>300 ريال/سنة</b> لكل موظف فوق 30.</div>
            <div class="note" style="margin-top:6px">* الأسعار لا تشمل ضريبة القيمة المضافة (إن وجدت).</div>

            <div class="calc">
              <div>
                <label for="emp">عدد الموظفين</label>
                <input type="number" id="emp" min="1" value="30"/>
              </div>
              <div class="res" id="total">الإجمالي: 5,000 ريال/سنة</div>
            </div>

            <div class="muted" style="margin-top:8px">
              مثال 45 موظف: 5000 + (15 × 300) = <b>9,500 ريال/سنة</b>.
            </div>

            <div class="card" style="margin-top:10px">
              <h3>يشمل الاشتراك</h3>
              <ul class="list">
                <li>تهيئة النظام وربط الهويّة البصرية.</li>
                <li>جلسة تدريب مسؤولي النظام + مواد مساعدة.</li>
                <li>تحديثات أمنية وتحسينات دورية.</li>
                <li>دعم فني عبر واتساب/تذاكر خلال أوقات العمل.</li>
              </ul>
            </div>
          </div>
        </div>

    </section>

    <!-- Footer / Contact -->
    <section class="footer">
      <div class="contact">
        <div><b>أسرع لتقنية المعلومات</b></div>
        <div>واتساب: <b>966535500241+</b></div>
        <div>البريد: info@98rl.org</div>
      </div>
      <div class="qr">
        <!-- ضع QR خاص بك إن أحببت -->
        <img src="https://www.98rl.link/assets/img/shareholders/qr.png" alt="QR"/>
        <div style="font-size:11px; color:var(--ink-2); margin-top:6px">موثق</div>
      </div>
    </section>
  </div>

<script>
  // حاسبة السعر
  const emp = document.getElementById('emp');
  const total = document.getElementById('total');
  const basePrice = 5000;
  const baseCap = 30;
  const extraRate = 300; // ريال لكل موظف فوق 30
  function fmt(n){ return n.toLocaleString('ar-SA'); }
  function calc(){
    const n = Math.max(1, parseInt(emp.value || '0', 10));
    let t = basePrice;
    if(n > baseCap){ t += (n - baseCap) * extraRate; }
    total.textContent = `الإجمالي: ${fmt(t)} ريال/سنة`;
  }
  emp.addEventListener('input', calc); calc();
</script>
</body>
</html>
