<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>عن نظام أسرع — بروفايل متناسق</title>
  <meta name="description" content="أسرع لتقنية المعلومات — منصة ERP/CRM سعودية موحّدة لإدارة المعاملات، الموارد البشرية، الرواتب، الحضور، القوالب الموقعة، والتكاملات الذكية."/>
  <meta name="theme-color" content="#0b1023"/>
  <!-- Tailwind CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    :root{
      --bg-start:#0b1023; --bg-end:#121b35;
      --primary:#6f7dfb;  --accent:#b36bff;
      --text:#e9eefb;     --muted:#9aa3b2;
      --ink:#0e162a;      --ink-2:#334155;
      --card:#ffffff;     --card-border:#e5e7eb;
      --ring:#c7d2fe;
    }
    html{scroll-behavior:smooth}
    body{
      background:
        radial-gradient(1000px 600px at 90% -10%, rgba(179,107,255,.16), transparent 60%),
        radial-gradient(800px 500px at 10% 100%, rgba(111,125,251,.12), transparent 60%),
        linear-gradient(135deg,var(--bg-start),var(--bg-end));
      color:var(--text);
    }
    .container{max-width:1200px}
    .glass{backdrop-filter: blur(10px); background:rgba(255,255,255,.06)}
    .card{background:var(--card); color:var(--ink); border:1px solid var(--card-border)}
    .shadow-soft{box-shadow:0 12px 30px rgba(0,0,0,.25)}
    .ring-brand{box-shadow:0 0 0 4px var(--ring)}
    .divider{height:1px; background:linear-gradient(90deg,transparent,rgba(255,255,255,.18),transparent)}
    [id]{scroll-margin-top:84px}

    /* طباعة */
    @media print{
      nav, .cta-bar, .sticky-cta{display:none!important}
      section{page-break-inside:avoid}
      .print-white{color:#000!important}
    }
  </style>
</head>
<body class="min-h-screen">

  <!-- Navbar -->
  <nav class="sticky top-0 z-50 glass border-b border-white/10">
    <div class="container mx-auto px-4 py-3 flex items-center gap-3">
      <!-- RTL: الشعار يسار والزر يمين -->
      <div class="ml-auto flex items-center gap-2">
        <img src="assets/img/logo.png" alt="أسرع" class="w-9 h-9 rounded-xl"/>
        <span class="font-bold tracking-wider">أسرع لتقنية المعلومات</span>
      </div>

      <button id="menuBtn" class="md:hidden border border-white/20 rounded-xl px-3 py-2">القائمة</button>

      <ul id="menu" class="hidden md:flex items-center gap-5 text-sm">
        <li><a href="#hero" class="hover:text-[var(--primary)]">الرئيسية</a></li>
        <li><a href="#highlights" class="hover:text-[var(--primary)]">لماذا أسرع</a></li>
        <li><a href="#features" class="hover:text-[var(--primary)]">المزايا</a></li>
        <li><a href="#modules" class="hover:text-[var(--primary)]">الوحدات</a></li>
        <li><a href="#gallery" class="hover:text-[var(--primary)]">صور النظام</a></li>
        <li><a href="#faq" class="hover:text-[var(--primary)]">الأسئلة</a></li>
        <li><a href="#contact" class="hover:text-[var(--primary)]">التواصل</a></li>
      </ul>

      <a href="#contact" class="mr-auto hidden md:inline-flex items-center gap-2 bg-[var(--primary)] text-[var(--ink)] font-semibold px-4 py-2 rounded-xl shadow-soft">جرّب النظام</a>
    </div>

    <!-- قائمة الجوال -->
    <div id="mobileMenu" class="md:hidden hidden border-t border-white/10 px-4 pb-4">
      <a class="block py-2" href="#hero">الرئيسية</a>
      <a class="block py-2" href="#highlights">لماذا أسرع</a>
      <a class="block py-2" href="#features">المزايا</a>
      <a class="block py-2" href="#modules">الوحدات</a>
      <a class="block py-2" href="#gallery">صور النظام</a>
      <a class="block py-2" href="#faq">الأسئلة</a>
      <a class="block py-2" href="#contact">التواصل</a>
      <a class="mt-3 inline-flex items-center gap-2 bg-[var(--primary)] text-[var(--ink)] font-semibold px-4 py-2 rounded-xl shadow-soft" href="#contact">جرّب النظام</a>
    </div>
  </nav>

  <!-- Hero -->
  <section id="hero" class="relative">
    <div class="container mx-auto px-4 py-16 md:py-24 grid md:grid-cols-2 gap-10 items-center">
      <div>
        <h1 class="text-3xl md:text-5xl font-extrabold leading-[1.15]">
          منصة <span class="text-[var(--primary)]">ERP/CRM</span> <span class="whitespace-nowrap">أسرع</span>
        </h1>
        <p class="mt-4 text-[var(--muted)] md:text-lg">
          كل عملياتك في لوحة واحدة — معاملات، موارد بشرية، رواتب، حضور، قوالب موقّعة، وتكاملات ذكية.
        </p>

        <!-- Badges سريعة بدل كروت -->
        <div class="mt-5 flex flex-wrap gap-2">
          <span class="glass border border-white/10 px-3 py-1 rounded-full text-sm">RTL عربي بالكامل</span>
          <span class="glass border border-white/10 px-3 py-1 rounded-full text-sm">صلاحيات متعددة</span>
          <span class="glass border border-white/10 px-3 py-1 rounded-full text-sm">قوالب وتوقيع</span>
          <span class="glass border border-white/10 px-3 py-1 rounded-full text-sm">تقارير تفاعلية</span>
        </div>

        <div class="mt-6 flex flex-wrap gap-3">
          <a href="#contact" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">احجز عرض مباشر</a>
          <a href="#highlights" class="border border-white/30 px-5 py-3 rounded-2xl">ليش أسرع؟</a>
        </div>
      </div>

      <div class="rounded-3xl overflow-hidden shadow-soft ring-1 ring-white/10">
        <img src="assets/img/hero-shot.png" alt="لقطة شاشة" class="w-full h-[320px] md:h-[420px] object-cover"/>
      </div>
    </div>
  </section>

  <div class="divider container mx-auto"></div>

  <!-- Highlights (قسم نصي + نقاط) -->
  <section id="highlights" class="py-12 md:py-16">
    <div class="container mx-auto px-4 grid lg:grid-cols-2 gap-10 items-start">
      <div>
        <h2 class="text-2xl md:text-3xl font-bold">ليش تختار <span class="text-[var(--primary)]">أسرع</span>؟</h2>
        <p class="mt-3 text-[var(--muted)]">
          صمّمنا النظام على تجربة استخدام سهلة وسريعة، مع تكاملات جاهزة، وإدارة صلاحيات دقيقة تناسب المنشآت السعودية.
        </p>
        <ul class="mt-4 space-y-3">
          <li class="flex items-start gap-3">
            <span class="mt-1 w-2 h-2 rounded-full bg-[var(--primary)]"></span>
            <div>تجربة عربية RTL متقنة وخطوط واضحة.</div>
          </li>
          <li class="flex items-start gap-3">
            <span class="mt-1 w-2 h-2 rounded-full bg-[var(--primary)]"></span>
            <div>تشغيل تلقائي للخطوات المتكررة وتنبيهات ذكية.</div>
          </li>
          <li class="flex items-start gap-3">
            <span class="mt-1 w-2 h-2 rounded-full bg-[var(--primary)]"></span>
            <div>مرونة ربط مع n8n وWhatsApp وملفات Excel.</div>
          </li>
        </ul>
      </div>
      <div class="glass rounded-2xl p-6 border border-white/10">
        <h3 class="text-xl font-bold">أرقام سريعة</h3>
        <div class="mt-4 grid grid-cols-2 sm:grid-cols-4 gap-4">
          <div class="text-center">
            <div class="text-3xl font-extrabold">+40%</div>
            <div class="text-sm text-[var(--muted)]">تسريع سير العمل</div>
          </div>
          <div class="text-center">
            <div class="text-3xl font-extrabold">90%</div>
            <div class="text-sm text-[var(--muted)]">رضا المستخدم</div>
          </div>
          <div class="text-center">
            <div class="text-3xl font-extrabold">24/7</div>
            <div class="text-sm text-[var(--muted)]">وصول للمنصة</div>
          </div>
          <div class="text-center">
            <div class="text-3xl font-extrabold">∞</div>
            <div class="text-sm text-[var(--muted)]">قابلية التوسّع</div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Features (أيقونات شبكية مو كروت) -->
  <section id="features" class="py-12 md:py-16">
    <div class="container mx-auto px-4">
      <h2 class="text-2xl md:text-3xl font-bold">أبرز <span class="text-[var(--primary)]">المزايا</span></h2>
      <div class="mt-6 grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- item -->
        <div class="flex items-start gap-4">
          <div class="glass border border-white/10 w-12 h-12 rounded-xl grid place-items-center">
            <img src="assets/img/icon/flow.svg" alt="" class="w-6 h-6">
          </div>
          <div>
            <h3 class="font-semibold">لوحة معاملات موحّدة</h3>
            <p class="text-[var(--muted)] mt-1">مراحل خاصة ومشتركة، صلاحيات دقيقة، وسجل كامل.</p>
          </div>
        </div>
        <!-- item -->
        <div class="flex items-start gap-4">
          <div class="glass border border-white/10 w-12 h-12 rounded-xl grid place-items-center">
            <img src="assets/img/icon/hr.svg" alt="" class="w-6 h-6">
          </div>
          <div>
            <h3 class="font-semibold">HR & Payroll</h3>
            <p class="text-[var(--muted)] mt-1">مكوّنات راتب مرنة، مسيرات، وامتثال محلي.</p>
          </div>
        </div>
        <!-- item -->
        <div class="flex items-start gap-4">
          <div class="glass border border-white/10 w-12 h-12 rounded-xl grid place-items-center">
            <img src="assets/img/icon/clock.svg" alt="" class="w-6 h-6">
          </div>
          <div>
            <h3 class="font-semibold">حضور ذكي</h3>
            <p class="text-[var(--muted)] mt-1">شِفتات ومواقع واحتساب تلقائي للتأخر والغياب.</p>
          </div>
        </div>
        <!-- item -->
        <div class="flex items-start gap-4">
          <div class="glass border border-white/10 w-12 h-12 rounded-xl grid place-items-center">
            <img src="assets/img/icon/sign.svg" alt="" class="w-6 h-6">
          </div>
          <div>
            <h3 class="font-semibold">قوالب وتوقيع</h3>
            <p class="text-[var(--muted)] mt-1">HTML/Word، توقيع داخل المتصفح وتحويل PDF.</p>
          </div>
        </div>
        <!-- item -->
        <div class="flex items-start gap-4">
          <div class="glass border border-white/10 w-12 h-12 rounded-xl grid place-items-center">
            <img src="assets/img/icon/report.svg" alt="" class="w-6 h-6">
          </div>
          <div>
            <h3 class="font-semibold">تقارير تفاعلية</h3>
            <p class="text-[var(--muted)] mt-1">فلترة ديناميكية وجمع إجماليات الحقول.</p>
          </div>
        </div>
        <!-- item -->
        <div class="flex items-start gap-4">
          <div class="glass border border-white/10 w-12 h-12 rounded-xl grid place-items-center">
            <img src="assets/img/icon/integrations.svg" alt="" class="w-6 h-6">
          </div>
          <div>
            <h3 class="font-semibold">تكاملات</h3>
            <p class="text-[var(--muted)] mt-1">n8n / Webhooks / WhatsApp / Excel Import-Export.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Modules (نص يمين + قائمة يسار) -->
  <section id="modules" class="py-12 md:py-16 glass border-t border-b border-white/10">
    <div class="container mx-auto px-4 grid lg:grid-cols-2 gap-10 items-center">
      <div>
        <h2 class="text-2xl md:text-3xl font-bold">الوحدات الرئيسية</h2>
        <p class="mt-3 text-[var(--muted)]">من صفحة واحدة تدير المنظومة كاملة بدون تعقيد.</p>
        <a href="#contact" class="inline-flex mt-5 bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">اطلب عرض توضيحي</a>
      </div>
      <ul class="grid sm:grid-cols-2 gap-4">
        <li class="glass border border-white/10 rounded-xl p-4">
          <h3 class="font-semibold">المعاملات</h3>
          <p class="text-sm text-[var(--muted)] mt-1">مراحل/تقليدي، تعليقات، مرفقات، أرشفة تلقائية.</p>
        </li>
        <li class="glass border border-white/10 rounded-xl p-4">
          <h3 class="font-semibold">الموارد البشرية</h3>
          <p class="text-sm text-[var(--muted)] mt-1">ملف موظف، صلاحيات، ملفات مرتبة لكل موظف.</p>
        </li>
        <li class="glass border border-white/10 rounded-xl p-4">
          <h3 class="font-semibold">الرواتب</h3>
          <p class="text-sm text-[var(--muted)] mt-1">مكوّنات راتب، مسيرات، خصومات وفق اللوائح.</p>
        </li>
        <li class="glass border border-white/10 rounded-xl p-4">
          <h3 class="font-semibold">الحضور</h3>
          <p class="text-sm text-[var(--muted)] mt-1">ربط مواقع وشِفتات واحتساب أوتوماتيكي.</p>
        </li>
        <li class="glass border border-white/10 rounded-xl p-4">
          <h3 class="font-semibold">القوالب والتوقيع</h3>
          <p class="text-sm text-[var(--muted)] mt-1">توليد/توقيع وتحويل PDF وإرفاق بالمهمة.</p>
        </li>
        <li class="glass border border-white/10 rounded-xl p-4">
          <h3 class="font-semibold">التقارير</h3>
          <p class="text-sm text-[var(--muted)] mt-1">منشئ تقارير تفاعلي وإجماليات.</p>
        </li>
      </ul>
    </div>
  </section>

  <!-- Timeline بسيط -->
  <section class="py-12 md:py-16">
    <div class="container mx-auto px-4">
      <h2 class="text-2xl md:text-3xl font-bold">رحلة التنفيذ</h2>
      <div class="mt-6 relative">
        <div class="absolute left-0 right-0 top-4 h-px bg-white/10"></div>
        <div class="grid sm:grid-cols-3 gap-6 relative">
          <div class="glass border border-white/10 rounded-xl p-4">
            <div class="text-sm text-[var(--muted)]">الخطوة 1</div>
            <div class="font-semibold">تحليل المتطلبات</div>
            <p class="text-sm text-[var(--muted)] mt-1">نموذج احتياجات + صلاحيات + مراحل.</p>
          </div>
          <div class="glass border border-white/10 rounded-xl p-4">
            <div class="text-sm text-[var(--muted)]">الخطوة 2</div>
            <div class="font-semibold">إعداد البيانات والربط</div>
            <p class="text-sm text-[var(--muted)] mt-1">استيراد Excel وتوصيل التكاملات.</p>
          </div>
          <div class="glass border border-white/10 rounded-xl p-4">
            <div class="text-sm text-[var(--muted)]">الخطوة 3</div>
            <div class="font-semibold">إطلاق وتدريب</div>
            <p class="text-sm text-[var(--muted)] mt-1">جلسة تدريب ومؤشرات أداء.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Gallery (مِيزونري بسيط) -->
  <section id="gallery" class="py-12 md:py-16">
    <div class="container mx-auto px-4">
      <h2 class="text-2xl md:text-3xl font-bold">صور من داخل النظام</h2>
      <div class="mt-6 columns-1 sm:columns-2 lg:columns-3 gap-4 [column-fill:_balance]">
        <img class="mb-4 rounded-xl border border-white/10 w-full" src="assets/img/s1.png" alt="">
        <img class="mb-4 rounded-xl border border-white/10 w-full" src="assets/img/s2.png" alt="">
        <img class="mb-4 rounded-xl border border-white/10 w-full" src="assets/img/s3.png" alt="">
        <img class="mb-4 rounded-xl border border-white/10 w-full" src="assets/img/s4.png" alt="">
        <img class="mb-4 rounded-xl border border-white/10 w-full" src="assets/img/s5.png" alt="">
        <img class="mb-4 rounded-xl border border-white/10 w-full" src="assets/img/s6.png" alt="">
      </div>
    </div>
  </section>

  <!-- شريط إحصائيات أفقي -->
  <section class="py-6 glass border-y border-white/10">
    <div class="container mx-auto px-4 grid grid-cols-2 sm:grid-cols-4 gap-6 text-center">
      <div><div class="text-2xl font-extrabold">+120</div><div class="text-sm text-[var(--muted)]">نموذج مخصّص</div></div>
      <div><div class="text-2xl font-extrabold">+50</div><div class="text-sm text-[var(--muted)]">تكامل جاهز</div></div>
      <div><div class="text-2xl font-extrabold">99.9%</div><div class="text-sm text-[var(--muted)]">التوفّر</div></div>
      <div><div class="text-2xl font-extrabold">SLA</div><div class="text-sm text-[var(--muted)]">استجابة دعم سريعة</div></div>
    </div>
  </section>

  <!-- Testimonial -->
  <section class="py-12 md:py-16">
    <div class="container mx-auto px-4">
      <div class="glass border border-white/10 rounded-2xl p-6 md:p-8">
        <p class="text-lg md:text-xl leading-8">
          “نظام أسرع ساعدنا نرتّب المعاملات ونسّرع الموافقات، وصار عندنا رؤية أوضح للحضور والرواتب.”
        </p>
        <div class="mt-4 text-sm text-[var(--muted)]">— مدير عمليات، عميل في القطاع الخدمي</div>
      </div>
    </div>
  </section>

  <!-- FAQ (Accordion) -->
<section id="faq" class="py-12 md:py-16">
  <div class="container mx-auto px-4">
    <h2 class="text-2xl md:text-3xl font-bold text-[var(--primary)]">الأسئلة الشائعة</h2>

    <div class="mt-6 divide-y divide-white/10 rounded-2xl overflow-hidden border border-white/10">

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">وش هو نظام أسرع بشكل مختصر؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
          أسرع هو نظام ERP سعودي متكامل يجمع المعاملات، الموارد البشرية، الأرشفة والتقارير في منصة واحدة سهلة.
        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">هل النظام مناسب للشركات الصغيرة والمتوسطة أو بس للكبار؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
          مرن؛ يبدأ مع 5 موظفين ويتوسع لآلاف الموظفين بدون مشاكل.
        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">وش أبرز المزايا اللي تميّزه؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
          عربي بالكامل، سهل، متوافق محليًا، شامل للوحدات ويدعم التخصيص.
        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">كيف يتعامل النظام مع الرواتب والخصومات؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
          ومتوافق مع نظام العمل السعودي ربط مباشر بالحضور والإجازات؛ يحسب الأساسي والبدلات والخصومات تلقائيًا.
        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">هل أقدر أربطه بالبصمة أو الجوال (GPS)؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
نعم النظام مبني على على التحضير من الموقع الجغرافي داخل نطاق الشركة         </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">هل فيه تكامل مع CRM وواتساب واستمارات الويب؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
          نعم، وحدة تكامل (Webhooks/n8n/WhatsApp) + استيراد/تصدير Excel/CSV.
        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">كيف تحمون البيانات والصلاحيات؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
          تشفير وتقسيم على مستويات وصول؛ كل مستخدم يشوف المصرّح له فقط.
        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">سحابي ولا تركيب داخلي؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
سحابي على سيرفرات سعودية موثوقة        </div>
      </div>

      <!-- item -->
      <div class="bg-white/5">
        <button class="w-full flex items-center justify-between gap-4 p-5 text-right faq-toggle">
          <span class="font-semibold">وش طريقة الاشتراك والتكلفة؟</span>
          <svg class="faq-icon w-5 h-5 shrink-0 transition" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
          </svg>
        </button>
        <div class="faq-panel hidden px-5 pb-5 text-[var(--muted)]">
اشتراك سنوي حسب حجم الشركة التكلفة للشركات الصغيرة والمتوسطة 5000ريال سنوياً        </div>
      </div>

    </div>
  </div>
</section>
  <!-- CTA ختامي -->
  <section class="py-12 md:py-16">
    <div class="container mx-auto px-4">
      <div class="glass border border-white/10 rounded-2xl p-6 md:p-8 flex flex-col md:flex-row items-center justify-between gap-4">
        <div>
          <h3 class="text-xl md:text-2xl font-bold">جاهز تسرّع شغلك؟</h3>
          <p class="text-[var(--muted)] mt-1">خلنا نجهز لك تجربة حيّة على بياناتك.</p>
        </div>
        <a href="#contact" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">تواصل معنا</a>
      </div>
    </div>
  </section>

  <!-- Contact -->
  <section id="contact" class="py-12 md:py-16">
    <div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
      <div class="card rounded-2xl p-6">
        <h2 class="text-xl md:text-2xl font-bold text-[var(--ink)]">خلّنا نتواصل</h2>
        <form id="contactForm" class="mt-4 grid gap-3">
          <input id="name"  class="border rounded-xl p-3" type="text"  placeholder="الاسم"/>
          <input id="email" class="border rounded-xl p-3" type="email" placeholder="البريد الإلكتروني"/>
          <input id="phone" class="border rounded-xl p-3" type="tel"   placeholder="رقم الجوال"/>
          <textarea id="msg" class="border rounded-xl p-3" rows="4" placeholder="وش تحتاج بالضبط؟"></textarea>
          <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">
            أرسل الطلب
          </button>
        </form>
      </div>
      <div>
        <h3 class="text-2xl font-bold">بيانات التواصل</h3>
        <ul class="mt-4 space-y-2 text-[var(--muted)]">
          <li>الموقع: 98RL.LINK</li>
          <li>البريد: 98rl@98rl.link</li>
          <li>واتساب: +966535500241</li>
        </ul>
        <a href="https://wa.me/966535500241" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">تواصل واتساب</a>
      </div>
    </div>
  </section>

  <!-- Footer -->
  <footer class="border-t border-white/10 py-6 text-center text-sm text-[var(--muted)]">
    © 2025 أسرع لتقنية المعلومات — كل الحقوق محفوظة
  </footer>

  <!-- Scripts -->
  <script>
    // قائمة الجوال
    const menuBtn = document.getElementById('menuBtn');
    const mobileMenu = document.getElementById('mobileMenu');
    if(menuBtn){ menuBtn.addEventListener('click',()=> mobileMenu.classList.toggle('hidden')); }

    // FAQ Accordion
    document.querySelectorAll('.faq-toggle').forEach(btn=>{
      btn.addEventListener('click', ()=>{
        const panel = btn.parentElement.querySelector('.faq-panel');
        // اغلق الباقي
        document.querySelectorAll('.faq-panel').forEach(p=>{ if(p!==panel) p.classList.add('hidden'); });
        panel.classList.toggle('hidden');
        const svg = btn.querySelector('.faq-icon');
        if(!panel.classList.contains('hidden')){
          svg.innerHTML = '<path d="M6 6l12 12M18 6l-12 12" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>';
        }else{
          svg.innerHTML = '<path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>';
        }
      });
    });

    // إرسال واتساب
    (function(){
      const f = document.getElementById('contactForm');
      if(!f) return;
      f.addEventListener('submit', function(e){
        e.preventDefault();
        const name  = document.getElementById('name').value.trim();
        const email = document.getElementById('email').value.trim();
        const phone = document.getElementById('phone').value.trim();
        const msg   = document.getElementById('msg').value.trim();
        const to = '966535500241';
        const text = `طلب تواصل جديد:\nالاسم: ${name}\nالبريد: ${email}\nالجوال: ${phone}\nالطلب:\n${msg}`;
        window.open('https://wa.me/'+to+'?text='+encodeURIComponent(text), '_blank');
      });
    })();
  </script>
</body>
</html>