<?php
require_once '../config/db.php';
require_once '../auth.php';

// جلب بيانات المشروع حسب الرقم
$id = $_GET['id'] ?? null;
if (!$id) { header("Location: projects.php"); exit; }

$stmt = $conn->prepare("SELECT * FROM projects WHERE id = ?");
$stmt->execute([$id]);
$proj = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$proj) { header("Location: projects.php"); exit; }

// جلب المستخدمين والإدارات
$users = $conn->query("SELECT id, name FROM users ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'];
  $description = $_POST['description'];
  $start_date = $_POST['start_date'] ?: null;
  $end_date = $_POST['end_date'] ?: null;
  $status = $_POST['status'];
  $budget = $_POST['budget'] ?: null;
  $owner_id = $_POST['owner_id'] ?: null;
  $department_id = $_POST['department_id'] ?: null;

  $stmt = $conn->prepare("UPDATE projects SET name=?, description=?, start_date=?, end_date=?, status=?, budget=?, owner_id=?, department_id=? WHERE id=?");
  $stmt->execute([$name, $description, $start_date, $end_date, $status, $budget, $owner_id, $department_id, $id]);
  header("Location: projects.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل مشروع</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-right">
  <div class="max-w-lg mx-auto mt-10 bg-white shadow rounded p-6">
    <h1 class="text-xl font-bold mb-4">تعديل مشروع</h1>
    <form method="POST">
      <div class="mb-3">
        <label>اسم المشروع</label>
        <input type="text" name="name" value="<?= htmlspecialchars($proj['name']) ?>" required class="w-full border rounded px-3 py-2">
      </div>
      <div class="mb-3">
        <label>الوصف</label>
        <textarea name="description" class="w-full border rounded px-3 py-2"><?= htmlspecialchars($proj['description']) ?></textarea>
      </div>
      <div class="grid grid-cols-2 gap-3">
        <div>
          <label>تاريخ البداية</label>
          <input type="date" name="start_date" value="<?= $proj['start_date'] ?>" class="w-full border rounded px-3 py-2">
        </div>
        <div>
          <label>تاريخ النهاية</label>
          <input type="date" name="end_date" value="<?= $proj['end_date'] ?>" class="w-full border rounded px-3 py-2">
        </div>
      </div>
      <div class="mb-3">
        <label>الحالة</label>
        <select name="status" class="w-full border rounded px-3 py-2">
          <option value="نشط" <?= $proj['status']=='نشط'?'selected':'' ?>>نشط</option>
          <option value="مكتمل" <?= $proj['status']=='مكتمل'?'selected':'' ?>>مكتمل</option>
          <option value="متوقف" <?= $proj['status']=='متوقف'?'selected':'' ?>>متوقف</option>
        </select>
      </div>
      <div class="mb-3">
        <label>الميزانية</label>
        <input type="number" name="budget" step="0.01" value="<?= $proj['budget'] ?>" class="w-full border rounded px-3 py-2">
      </div>
      <div class="mb-3">
        <label>المسؤول</label>
        <select name="owner_id" class="w-full border rounded px-3 py-2">
          <?php foreach($users as $user): ?>
            <option value="<?= $user['id'] ?>" <?= $proj['owner_id']==$user['id']?'selected':'' ?>><?= htmlspecialchars($user['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="mb-3">
        <label>الإدارة</label>
        <select name="department_id" class="w-full border rounded px-3 py-2">
          <?php foreach($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>" <?= $proj['department_id']==$dep['id']?'selected':'' ?>><?= htmlspecialchars($dep['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="text-center">
        <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded hover:bg-green-700">حفظ التعديلات</button>
      </div>
    </form>
  </div>
</body>
</html>
