<?php
require_once '../config/db.php';
require_once '../auth.php';

$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'];

// جلب المشاريع مع ربط اسم المستخدم المسؤول واسم الإدارة
$sql = "SELECT p.*, u.name AS owner_name, d.name AS department_name
        FROM projects p
        LEFT JOIN users u ON p.owner_id = u.id
        LEFT JOIN departments d ON p.department_id = d.id
        ORDER BY p.created_at DESC";
$projects = $conn->query($sql)->fetchAll(PDO::FETCH_ASSOC);

// جلب عدد المهام لكل مشروع
$tasks_per_project = $conn->query("
    SELECT 
        p.id, 
        p.name, 
        COUNT(t.id) AS tasks_count
    FROM projects p
    LEFT JOIN tasks t ON t.project_id = p.id AND t.is_deleted = 0
    GROUP BY p.id, p.name
    ORDER BY p.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

// تجهيز البيانات للـ Chart.js
$project_names = [];
$tasks_counts = [];
foreach ($tasks_per_project as $row) {
    $project_names[] = $row['name'];
    $tasks_counts[] = (int)$row['tasks_count'];
}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة المشاريع</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      background: <?= $userThemeColor ?> !important;
      color: <?= $userThemeTextColor ?> !important;
    }
    .main-card {
      background: #fff;
      border-radius: 1.25rem;
      box-shadow: 0 1px 8px 0 #0002;
      margin-top: 40px;
    }
    th, .thead-custom {
      background: <?= $userThemeNavColor ?> !important;
      color: <?= $userThemeTextColor ?> !important;
    }
    tr:hover {
      background: #e6fce6 !important;
      transition: 0.1s;
    }
    .btn-main {
      background: #34d399;
      color: #fff;
      border-radius: 12px;
      font-weight: bold;
      padding: 10px 24px;
      font-size: 16px;
      transition: 0.1s;
    }
    .btn-main:hover {
      background: #059669;
    }
    .btn-edit {
      background: #facc15;
      color: #444;
      border-radius: 8px;
      font-weight: bold;
      padding: 4px 16px;
      margin: 0 2px;
    }
    .btn-edit:hover {
      background: #f59e42;
      color: #fff;
    }
    .btn-del {
      background: #ef4444;
      color: #fff;
      border-radius: 8px;
      font-weight: bold;
      padding: 4px 16px;
      margin: 0 2px;
    }
    .btn-del:hover {
      background: #991b1b;
      color: #fff;
    }
    .modal-shadow {
      background: rgba(0,0,0,0.20);
      backdrop-filter: blur(2px);
    }
    input, select, textarea {
      background: #f9fafb !important;
      color: #333 !important;
      border-radius: 9px !important;
    }
  </style>
  <style>
  /* يخلي محتوى المودال يتمرّر إذا صار طويل */
  .modal-panel{ max-height:85vh; overflow-y:auto; }
  @media (max-width:768px){
    .modal-panel{ max-height:90vh; }
  }
</style>

</head>
<body class="text-right">

  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-4xl mx-auto main-card p-6">
    <div class="flex justify-between items-center mb-8">
      <h1 class="text-2xl font-bold">🗂️ إدارة المشاريع</h1>
<button onclick="openModal('addModal')" class="btn-main shadow">➕ إضافة مشروع</button>
    </div>
    <div class="overflow-x-auto">
      <table class="w-full border rounded text-center">
        <thead>
          <tr>
            <th class="thead-custom p-2">رقم المشروع</th>
            <th class="thead-custom p-2">اسم المشروع</th>
            <th class="thead-custom p-2">الوصف</th>
            <th class="thead-custom p-2">تاريخ البداية</th>
            <th class="thead-custom p-2">تاريخ النهاية</th>
            <th class="thead-custom p-2">الحالة</th>
            <th class="thead-custom p-2">الميزانية</th>
            <th class="thead-custom p-2">المسؤول</th>
            <th class="thead-custom p-2">الإدارة</th>
            <th class="thead-custom p-2">إجراءات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($projects as $proj): ?>
          <tr>
            <td class="p-2"><?= $proj['id'] ?></td>
            <td class="p-2"><?= htmlspecialchars($proj['name']) ?></td>
            <td class="p-2"><?= htmlspecialchars($proj['description']) ?></td>
            <td class="p-2"><?= $proj['start_date'] ?></td>
            <td class="p-2"><?= $proj['end_date'] ?></td>
            <td class="p-2"><?= $proj['status'] ?></td>
            <td class="p-2"><?= number_format($proj['budget']) ?></td>
            <td class="p-2"><?= $proj['owner_name'] ?></td>
            <td class="p-2"><?= $proj['department_name'] ?></td>
            <td class="p-2">
              <a href="edit_project.php?id=<?= $proj['id'] ?>" class="btn-edit">تعديل</a>
              <a href="delete_project.php?id=<?= $proj['id'] ?>" class="btn-del" onclick="return confirm('متأكد تبي تحذف المشروع؟')">حذف</a>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
  
<div class="max-w-4xl mx-auto main-card p-6 mt-10">
  <h2 class="text-lg font-bold mb-4">📊 عدد المهام في كل مشروع</h2>
  <div class="overflow-x-auto">
    <canvas id="tasksPerProjectChart" height="340" style="width:100%"></canvas>
  </div>
</div>


<!-- مودال إضافة مشروع -->
<div id="addModal" class="fixed inset-0 modal-shadow hidden z-50 overflow-y-auto">
  <div class="min-h-full flex items-start md:items-center justify-center p-4 md:p-8">
    <div class="bg-white rounded-xl shadow-xl w-full max-w-2xl relative modal-panel">
      <button onclick="closeModal('addModal')" class="absolute left-4 top-4 text-2xl text-gray-400">×</button>

      <form method="POST" action="add_project.php" class="p-6 md:p-8">
        <h2 class="text-xl font-bold mb-4">إضافة مشروع جديد</h2>

        <div class="mb-4">
          <label>اسم المشروع</label>
          <input type="text" name="name" required class="w-full border px-3 py-2 mt-1">
        </div>

        <div class="mb-4">
          <label>الوصف</label>
          <textarea name="description" class="w-full border px-3 py-2 mt-1"></textarea>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
          <div>
            <label>تاريخ البداية</label>
            <input type="date" name="start_date" class="w-full border px-3 py-2 mt-1">
          </div>
          <div>
            <label>تاريخ النهاية</label>
            <input type="date" name="end_date" class="w-full border px-3 py-2 mt-1">
          </div>
        </div>

        <div class="mb-4">
          <label>الحالة</label>
          <select name="status" class="w-full border px-3 py-2 mt-1">
            <option value="نشط">نشط</option>
            <option value="مكتمل">مكتمل</option>
            <option value="متوقف">متوقف</option>
          </select>
        </div>

        <div class="mb-4">
          <label>الميزانية</label>
          <input type="number" name="budget" step="0.01" class="w-full border px-3 py-2 mt-1">
        </div>

        <div class="mb-4">
          <label>المسؤول</label>
          <select name="owner_id" class="w-full border px-3 py-2 mt-1">
            <?php
              $users = $conn->query("SELECT id, name FROM users ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
              foreach($users as $user){
                echo "<option value='{$user['id']}'>" . htmlspecialchars($user['name']) . "</option>";
              }
            ?>
          </select>
        </div>

        <div class="mb-4">
          <label>الإدارة</label>
          <select name="department_id" class="w-full border px-3 py-2 mt-1">
            <?php
              $deps = $conn->query("SELECT id, name FROM departments ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
              foreach($deps as $dep){
                echo "<option value='{$dep['id']}'>" . htmlspecialchars($dep['name']) . "</option>";
              }
            ?>
          </select>
        </div>

        <!-- زر ثابت بأسفل المودال عشان يظل ظاهر -->
        <div class="sticky bottom-0 bg-white pt-4">
          <button type="submit" class="btn-main w-full">حفظ المشروع</button>
        </div>
      </form>
    </div>
  </div>
</div>
   
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const projectNames = <?= json_encode($project_names) ?>;
const tasksCounts = <?= json_encode($tasks_counts) ?>;

const ctx = document.getElementById('tasksPerProjectChart').getContext('2d');
new Chart(ctx, {
    type: 'bar',
    data: {
        labels: projectNames,
        datasets: [{
            label: 'عدد المهام',
            data: tasksCounts,
            backgroundColor: '#4F46E5',
            borderRadius: 20,
            barPercentage: 0.5,       // حجم العمود (أعرض شوي)
            categoryPercentage: 0.7    // تباعد بين الأعمدة
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false },
            tooltip: { enabled: true }
        },
        layout: { padding: { top: 30, bottom: 20 } },
        scales: {
            y: {
                beginAtZero: true,
                title: {
                    display: true,
                    text: 'عدد المهام',
                    color: '#333',
                    font: { size: 16, weight: 'bold' }
                },
                ticks: { font: { size: 16 }, color: '#222' }
            },
            x: {
                title: {
                    display: true,
                    text: 'المشروع',
                    color: '#333',
                    font: { size: 16, weight: 'bold' }
                },
                ticks: {
                    font: { size: 15 },
                    color: '#222',
                    maxRotation: 0,
                    minRotation: 0,
                    autoSkip: false // عشان تظهر كل الأسماء لو كثيرة
                },
                grid: { display: false }
            }
        }
    }
});
</script>

<script>
  function openModal(id){
    document.getElementById(id).classList.remove('hidden');
    document.body.classList.add('overflow-hidden'); // يمنع تمرير الخلفية
  }
  function closeModal(id){
    document.getElementById(id).classList.add('hidden');
    document.body.classList.remove('overflow-hidden');
  }
</script>

  
</body>
</html>
