
function exportToPDF() {
    if (!latestReportTable) return;
    let headers = [];
    latestReportTable.querySelectorAll('thead th').forEach(th => {
        headers.push({ text: th.innerText, style: 'tableHeader', alignment: 'center' });
    });
    let body = [];
    latestReportTable.querySelectorAll('tbody tr').forEach(tr => {
        let row = [];
        tr.querySelectorAll('td').forEach(td => {
            row.push({ text: td.innerText, alignment: 'center' });
        });
        body.push(row);
    });
    const docDefinition = {
        content: [
            { text: '📋 تقرير المهام', style: 'header', alignment: 'center', margin: [0, 0, 0, 20] },
            {
                table: {
                    headerRows: 1,
                    widths: Array(headers.length).fill('*'),
                    body: [headers, ...body]
                },
                layout: {
                    fillColor: function (rowIndex) {
                        return (rowIndex === 0) ? '#eeeeee' : null;
                    }
                }
            }
        ],
        defaultStyle: {
            font: 'ArabicFont',
            fontSize: 12,
            alignment: 'center'
        },
        styles: {
            header: {
                fontSize: 18,
                bold: true
            },
            tableHeader: {
                bold: true,
                fillColor: '#eeeeee'
            }
        },
        pageOrientation: 'landscape',
        pageSize: 'A4',
        pageMargins: [20, 20, 20, 20]
    };
    pdfMake.createPdf(docDefinition).download('تقرير.pdf');
}
