<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

$from_date = $_POST['from_date'] ?? null;
$to_date = $_POST['to_date'] ?? null;
$stage_ids = $_POST['stage_ids'] ?? [];
$department_id = $_POST['department_id'] ?? null;
$chart_group_by = $_POST['chart_group_by'] ?? 'assigned_to';

$labels = [];
$counts = [];

if (!$department_id) {
    echo json_encode(['error' => true, 'labels' => [], 'counts' => []]);
    exit;
}

$conditions = [];
$params = [$department_id];

if ($from_date) {
    $conditions[] = "tasks.created_at >= ?";
    $params[] = $from_date;
}

if ($to_date) {
    $conditions[] = "tasks.created_at <= ?";
    $params[] = $to_date;
}

if (!empty($stage_ids)) {
    $in = implode(',', array_fill(0, count($stage_ids), '?'));
    $conditions[] = "stage_id IN ($in)";
    foreach ($stage_ids as $sid) {
        $params[] = $sid;
    }
}

$whereSQL = '';
if (!empty($conditions)) {
    $whereSQL = ' AND ' . implode(' AND ', $conditions);
}

// البرمجة حسب الـ group by
if ($chart_group_by === 'project_id') {
    $sql = "SELECT 
              COALESCE(projects.name, 'بدون مشروع') AS group_name, 
              COUNT(tasks.id) AS task_count
            FROM tasks
            LEFT JOIN projects ON tasks.project_id = projects.id
            WHERE tasks.department_id = ? AND tasks.is_deleted = 0 $whereSQL
            GROUP BY tasks.project_id
            ORDER BY task_count DESC";
} elseif ($chart_group_by === 'task_type_id') {
    $sql = "SELECT 
              COALESCE(task_types.name, 'غير مصنف') AS group_name, 
              COUNT(tasks.id) AS task_count
            FROM tasks
            LEFT JOIN task_types ON tasks.task_type_id = task_types.id
            WHERE tasks.department_id = ? AND tasks.is_deleted = 0 $whereSQL
            GROUP BY tasks.task_type_id
            ORDER BY task_count DESC";
} else { // assigned_to
    $sql = "SELECT 
              COALESCE(users.name, 'غير محدد') AS group_name, 
              COUNT(tasks.id) AS task_count
            FROM tasks
            LEFT JOIN users ON tasks.assigned_to = users.id
            WHERE tasks.department_id = ? AND tasks.is_deleted = 0 $whereSQL
            GROUP BY tasks.assigned_to
            ORDER BY task_count DESC";
}

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);
 
foreach ($results as $row) {
    $labels[] = $row['group_name'];
    $counts[] = (int)$row['task_count'];
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode([
    'error' => false,
    'labels' => $labels,
    'counts' => $counts
], JSON_UNESCAPED_UNICODE);