<?php
require_once '../config/db.php';

$department_id = $_POST['department_id'] ?? null;
$fields = $_POST['fields'] ?? [];
$from_date = $_POST['from_date'] ?? null;
$to_date = $_POST['to_date'] ?? null;
$stage_ids = $_POST['stage_ids'] ?? [];
$project_id = $_POST['project_id'] ?? null;
$department_type = $_POST['department_type'] ?? 'all';
$show_totals = isset($_POST['show_totals']) && $_POST['show_totals'] === 'true';

if (!$department_id || empty($fields)) {
    echo "<p class='text-red-600'>🚫 يجب اختيار الإدارة وبعض الأعمدة لعرض التقرير.</p>";
    exit;
}

$default_fields = ['title', 'description', 'created_at', 'due_date', 'assigned_to', 'stage_id', 'project_id', 'task_type_id'];

$selected_default_fields = [];
$selected_custom_fields = [];

foreach ($fields as $field) {
    if (in_array($field, $default_fields)) {
        $selected_default_fields[] = $field;
    } elseif (strpos($field, 'custom_') === 0) {
        $selected_custom_fields[] = str_replace('custom_', '', $field);
    }
}

// جلب الإدارات المرتبطة: الرئيسية + الفرعية
if ($department_type === 'main') {
    $all_dept_ids = [$department_id];
} elseif ($department_type === 'sub') {
    $stmt = $conn->prepare("SELECT id FROM departments WHERE parent_id = ?");
    $stmt->execute([$department_id]);
    $all_dept_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
} else {
    $stmt = $conn->prepare("SELECT id FROM departments WHERE id = ? OR parent_id = ?");
    $stmt->execute([$department_id, $department_id]);
    $all_dept_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
}

$placeholders = implode(',', array_fill(0, count($all_dept_ids), '?'));
$sql = "SELECT tasks.*, departments.name AS department_name, projects.name AS project_name, task_types.name AS type_name
        FROM tasks 
        JOIN departments ON tasks.department_id = departments.id 
        LEFT JOIN projects ON tasks.project_id = projects.id
        LEFT JOIN task_types ON tasks.task_type_id = task_types.id
        WHERE tasks.department_id IN ($placeholders) 
        AND tasks.is_deleted = 0";

$params = $all_dept_ids;

if ($from_date) {
    $sql .= " AND created_at >= ?";
    $params[] = $from_date;
}
if ($to_date) {
    $sql .= " AND created_at <= ?";
    $params[] = $to_date;
}
if (!empty($stage_ids)) {
    $stage_placeholders = implode(',', array_fill(0, count($stage_ids), '?'));
    $sql .= " AND stage_id IN ($stage_placeholders)";
    $params = array_merge($params, $stage_ids);
}
if ($project_id) {
    $sql .= " AND tasks.project_id = ?";
    $params[] = $project_id;
}
$task_type_id = $_POST['task_type_id'] ?? null;
if ($task_type_id) {
    $sql .= " AND tasks.task_type_id = ?";
    $params[] = $task_type_id;
}

// -- تنفيذ الاستعلام هنا --
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (count($tasks) === 0) {
    echo "<p class='text-gray-500'>لا توجد نتائج مطابقة للفلترة المختارة.</p>";
    exit;
}

// جلب الحقول الإضافية لو فيه
$custom_values = [];
$custom_labels = [];
if (!empty($selected_custom_fields)) {
    $task_ids = array_column($tasks, 'id');
    if (!empty($task_ids)) {
        $in_tasks = implode(',', array_fill(0, count($task_ids), '?'));
        $in_fields = implode(',', array_fill(0, count($selected_custom_fields), '?'));

        $stmt_custom = $conn->prepare("SELECT * FROM task_custom_values WHERE task_id IN ($in_tasks) AND field_id IN ($in_fields)");
        $stmt_custom->execute(array_merge($task_ids, $selected_custom_fields));
        $custom_rows = $stmt_custom->fetchAll();

        foreach ($custom_rows as $row) {
            $custom_values[$row['task_id']][$row['field_id']] = $row['value'];
        }

        $stmt_labels = $conn->prepare("SELECT id, label, type, options FROM custom_fields WHERE id IN ($in_fields)");
        $stmt_labels->execute($selected_custom_fields);
        foreach ($stmt_labels->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $custom_labels[$row['id']] = $row['label'];
            if ($row['type'] === 'dropdown') {
                $opts = explode(',', $row['options']);
                $map = [];
                foreach ($opts as $opt) {
                    $opt = trim($opt);
                    $map[$opt] = $opt;
                }
                $custom_labels['_dropdown_map_' . $row['id']] = $map;
            }
        }
    }
}

// جلب أسماء المستخدمين للمسؤول
$user_ids = array_column($tasks, 'assigned_to');
$userMap = [];
if (!empty($user_ids)) {
    $placeholders = implode(',', array_fill(0, count($user_ids), '?'));
    $stmt_users = $conn->prepare("SELECT id, name FROM users WHERE id IN ($placeholders)");
    $stmt_users->execute($user_ids);
    foreach ($stmt_users->fetchAll(PDO::FETCH_ASSOC) as $u) {
        $userMap[$u['id']] = $u['name'];
    }
}

// تعريف عناوين الأعمدة
$field_labels = [
    'title' => 'عنوان المهمة',
    'description' => 'وصف المهمة',
    'created_at' => 'تاريخ الإنشاء',
    'due_date' => 'تاريخ الاستحقاق',
    'assigned_to' => 'المسؤول',
    'stage_id' => 'المرحلة',
    'project_id' => 'المشروع',
    'task_type_id' => 'التصنيف'
];

// -- طباعة الجدول --
echo "<div class='overflow-x-auto'>";
echo "<table class='min-w-full text-sm text-right border-collapse border mt-6'>";
echo "<thead><tr class='bg-gray-200'>";
echo "<th class='px-4 py-2 border font-bold bg-gray-100'>الإدارة</th>";

foreach ($fields as $field) {
    if (strpos($field, 'custom_') === 0) {
        $field_id = str_replace('custom_', '', $field);
        echo "<th class='px-4 py-2 border font-bold bg-gray-100'>" . htmlspecialchars($custom_labels[$field_id] ?? 'حقل إضافي') . "</th>";
    } else {
        echo "<th class='px-4 py-2 border font-bold bg-gray-100'>" . htmlspecialchars($field_labels[$field] ?? $field) . "</th>";
    }
}
echo "</tr></thead><tbody>";

$row_index = 0;
foreach ($tasks as $task) {
    $row_class = $row_index++ % 2 == 0 ? 'bg-white' : 'bg-gray-50';
    echo "<tr class='$row_class'>";
    echo "<td class='px-4 py-2 border'>" . htmlspecialchars($task['department_name']) . "</td>";
    foreach ($fields as $field) {
        if ($field === 'task_type_id') {
            $value = $task['type_name'] ?? '—';
            echo "<td class='px-4 py-2 border'>" . htmlspecialchars($value) . "</td>";
        }
        elseif (in_array($field, $default_fields)) {
            if ($field === 'assigned_to') {
                $value = $userMap[$task[$field]] ?? '—';
            } elseif ($field === 'project_id') {
                $value = $task['project_name'] ?? '—';
            } else {
                $value = $task[$field] ?? '—';
            }
            echo "<td class='px-4 py-2 border'>" . htmlspecialchars($value) . "</td>";
        } elseif (strpos($field, 'custom_') === 0) {
            $field_id = str_replace('custom_', '', $field);
            $value = $custom_values[$task['id']][$field_id] ?? '—';
            $dropdown_map = $custom_labels['_dropdown_map_' . $field_id] ?? null;
            if ($dropdown_map && isset($dropdown_map[$value])) {
                $value = $dropdown_map[$value];
            }
            echo "<td class='px-4 py-2 border'>" . htmlspecialchars($value) . "</td>";
        }
    }
    echo "</tr>";
}

// إجمالي الأعمدة الرقمية
if ($show_totals) {
    echo "<tr class='bg-yellow-100 font-bold'>";
    echo "<td class='px-4 py-2 border'>الإجمالي</td>";

    foreach ($fields as $field) {
        $sum = 0;
        $is_numeric = true;

        foreach ($tasks as $task) {
            if (in_array($field, $default_fields)) {
                if ($field === 'project_id' || $field === 'task_type_id') {
                    $value = 0; // لا تجمع المشاريع أو التصنيف
                    $is_numeric = false;
                } else {
                    $value = $task[$field] ?? 0;
                }
            } elseif (strpos($field, 'custom_') === 0) {
                $field_id = str_replace('custom_', '', $field);
                $value = $custom_values[$task['id']][$field_id] ?? 0;
            } else {
                $value = 0;
            }

            if (is_numeric($value)) {
                $sum += $value;
            } else {
                $is_numeric = false;
                break;
            }
        }

        if ($is_numeric) {
            echo "<td class='px-4 py-2 border'>" . number_format($sum) . "</td>";
        } else {
            echo "<td class='px-4 py-2 border'>—</td>";
        }
    }

    echo "</tr>";
}
 
echo "</tbody></table>";
echo "</div>";
?>
