<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>اختبار تحريك التوقيع</title>
  <style>
    #container {
      position: relative;
      width: 600px;
      height: 400px;
      border: 2px dashed #ccc;
      margin: 50px auto;
      background: #f9f9f9;
    }

    #userSignature {
      position: absolute;
      top: 50px;
      left: 50px;
      width: 120px;
      cursor: move;
      z-index: 9999;
      border: 1px dashed gray;
      background-color: #fff;
      user-select: none;
      -webkit-user-drag: none;
    }
  </style>
</head>
<body>

<div id="container">
  <img id="userSignature" src="uploads/signatures/68288bf88ce59_87878787.png" alt="توقيع">
</div>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const sig = document.getElementById("userSignature");
  const container = document.getElementById("container");

  let isDragging = false, offsetX = 0, offsetY = 0;

  sig.addEventListener("mousedown", (e) => {
    isDragging = true;
    offsetX = e.offsetX;
    offsetY = e.offsetY;
  });

  document.addEventListener("mousemove", (e) => {
    if (isDragging) {
      const rect = container.getBoundingClientRect();
      sig.style.left = (e.pageX - rect.left - offsetX) + "px";
      sig.style.top = (e.pageY - rect.top - offsetY) + "px";
    }
  });

  document.addEventListener("mouseup", () => {
    isDragging = false;
  });
});
</script>

</body>
</html>
