<?php
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// إعدادات المرحلة الخاصة
$target_department_id = 3; // رقم الإدارة المطلوبة
$target_stage_id = 5; // رقم المرحلة اللي نبي ننقل لها
$days_before_due = 30; // عدد الأيام قبل تاريخ الانتهاء

$today = date('Y-m-d');
$limit_date = date('Y-m-d', strtotime("+$days_before_due days"));

// نجيب المهام اللي باقي عليها أقل من شهر وتابعة للإدارة المحددة
$stmt = $conn->prepare("
  SELECT id FROM tasks
  WHERE department_id = ? AND due_date <= ? AND stage_id != ?
");
$stmt->execute([$target_department_id, $limit_date, $target_stage_id]);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($tasks as $task) {
    $task_id = $task['id'];

    // ننقل المهمة للمرحلة المطلوبة
    $update = $conn->prepare("UPDATE tasks SET stage_id = ? WHERE id = ?");
    $update->execute([$target_stage_id, $task_id]);

    // ممكن نضيف تسجيل في السجل
    $conn->prepare("INSERT INTO task_logs (task_id, user_id, action_type, action_details)
                    VALUES (?, NULL, 'auto_move', 'نُقلت تلقائيًا قبل تاريخ الانتهاء')")
         ->execute([$task_id]);
}

echo "تم نقل المهام المطلوبة.";
