<?php
require_once '../config/db.php';
require_once '../auth.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  die("❌ رقم المرحلة غير صالح.");
}

$stage_id = $_GET['id'];

// التحقق إذا فيه مهام مرتبطة بهذي المرحلة
$checkTasks = $conn->prepare("SELECT COUNT(*) FROM tasks WHERE stage_id = ?");
$checkTasks->execute([$stage_id]);
$taskCount = $checkTasks->fetchColumn();

if ($taskCount > 0) {
  $_SESSION['error'] = "❌ لا يمكن حذف المرحلة لوجود $taskCount مهمة مرتبطة بها.";
  header("Location: index.php");
  exit;
}

// حذف المستخدمين المرتبطين بهذه المرحلة
$conn->prepare("DELETE FROM stage_visible_users WHERE stage_id = ?")->execute([$stage_id]);

// حذف المرحلة نفسها
$deleted = $conn->prepare("DELETE FROM stages WHERE id = ?")->execute([$stage_id]);

if ($deleted) {
  $_SESSION['success'] = "✅ تم حذف المرحلة بنجاح.";
} else {
  $_SESSION['error'] = "❌ حدث خطأ أثناء حذف المرحلة.";
}

header("Location: index.php");
exit;
