<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $_GET['department_id'] ?? $user['department_id'];
$success_message = $_SESSION['success'] ?? null;
$error_message = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);

if ($role === 'admin') {
  $userStmt = $conn->query("SELECT id, name, department_id FROM users");
  $users = $userStmt->fetchAll(PDO::FETCH_ASSOC);
} else {
  $userStmt = $conn->prepare("SELECT id, name, department_id FROM users WHERE department_id = ?");
  $userStmt->execute([$department_id]);
  $users = $userStmt->fetchAll(PDO::FETCH_ASSOC);
}

$stages = [];
$stageStmt = $conn->prepare("SELECT s.*, GROUP_CONCAT(u.name SEPARATOR ', ') as visible_users_names
                              FROM stages s
                              LEFT JOIN stage_visible_users sv ON s.id = sv.stage_id
                              LEFT JOIN users u ON sv.user_id = u.id
                              WHERE s.department_id = ?
                              GROUP BY s.id
                              ORDER BY s.order_number ASC");
$stageStmt->execute([$department_id]);
$stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);

$taskStages = [];
if ($role === 'admin') {
  $taskStages = $conn->query("SELECT DISTINCT stage_id FROM tasks WHERE stage_id IS NOT NULL")->fetchAll(PDO::FETCH_ASSOC);
}

$availableStages = $conn->prepare("SELECT id, name FROM stages WHERE department_id = ?");
$availableStages->execute([$department_id]);
$stageOptions = $availableStages->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة المراحل</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
</head>
<body class="bg-gray-100 text-right">
  <div class="max-w-3xl mx-auto mt-10 bg-white shadow rounded p-6">
    <h1 class="text-2xl font-bold mb-6">⚙️ إدارة مراحل المهام</h1>

    <?php if ($success_message): ?>
      <div class="mb-4 p-3 text-green-800 rounded shadow" style="background-color: #7be667;">
        <?= $success_message ?>
      </div>
    <?php endif; ?>

    <?php if ($error_message): ?>
      <div class="mb-4 p-3 bg-red-100 text-red-800 rounded shadow">
        <?= $error_message ?>
      </div>
    <?php endif; ?>

    <?php if ($role === 'admin'): ?>
    <form method="GET" class="mb-6">
      <label class="block mb-1 text-sm">عرض مراحل إدارة معينة:</label>
      <select name="department_id" onchange="this.form.submit()" class="border rounded px-3 py-2">
        <option value="">-- اختر الإدارة --</option>
        <?php foreach ($departments as $dep): ?>
          <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $department_id ? 'selected' : '' ?>><?= htmlspecialchars($dep['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </form>
    <?php endif; ?>

    <form method="POST" action="store_stage.php" class="space-y-4">
      <div>
        <label class="block text-sm font-medium mb-1">اسم المرحلة</label>
        <input type="text" name="name" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block text-sm font-medium mb-1">درجة السرية</label>
        <select name="secret_level" class="w-full border rounded px-3 py-2">
          <option value="normal">عادية</option>
          <option value="secret">سرية</option>
          <option value="top_secret">سرية جداً</option>
        </select>
      </div>

      <div>
        <label class="block text-sm font-medium mb-1">لون المرحلة</label>
        <select name="color" class="w-full border rounded px-3 py-2">
          <option value="#6B7280">رمادي - جديد</option>
          <option value="#3B82F6">أزرق - تحت التنفيذ</option>
          <option value="#10B981">أخضر - مكتملة</option>
        </select>
      </div>

      <div>
        <label class="block text-sm font-medium mb-1">الإدارة</label>
        <select name="department_id" required class="w-full border rounded px-3 py-2">
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $department_id ? 'selected' : '' ?>><?= htmlspecialchars($dep['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block text-sm font-medium mb-1">المستخدمين الذين يمكنهم مشاهدة المرحلة</label>
        <select name="visible_users[]" multiple class="w-full border rounded px-3 py-2 h-40">
          <?php foreach ($users as $user): ?>
            <?php if ($role === 'admin' && $user['department_id'] != $department_id) continue; ?>
            <option value="<?= $user['id'] ?>"><?= $user['name'] ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="text-center pt-4">
        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">➕ حفظ المرحلة</button>
      </div>
    </form>

    <?php if (!empty($stages)): ?>
    <div class="mt-10">
      <h2 class="text-lg font-bold mb-4">📋 المراحل المضافة</h2>
      <table class="min-w-full bg-white border rounded" id="sortableStages">
        <thead class="bg-gray-100">
          <tr>
            <th class="border px-4 py-2">الترتيب</th>
            <th class="border px-4 py-2">اسم المرحلة</th>
            <th class="border px-4 py-2">السرية</th>
            <th class="border px-4 py-2">الإدارة</th>
            <th class="border px-4 py-2">المستخدمين المسموح لهم</th>
            <th class="border px-4 py-2">خيارات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($stages as $index => $stage): ?>
            <tr class="sortable-row" data-id="<?= $stage['id'] ?>">
              <td class="border px-4 py-2">#<?= $index + 1 ?></td>
              <td class="border px-4 py-2 font-semibold" style="color: <?= htmlspecialchars($stage['color'] ?? '#6B7280') ?>">
                <?= htmlspecialchars($stage['name']) ?>
              </td>
              <td class="border px-4 py-2"><?= htmlspecialchars($stage['secret_level']) ?></td>
              <td class="border px-4 py-2">
                <?php
                $depName = array_filter($departments, fn($d) => $d['id'] == $stage['department_id']);
                echo htmlspecialchars(array_values($depName)[0]['name'] ?? '');
                ?>
              </td>
              <td class="border px-4 py-2 text-sm text-gray-700"><?= htmlspecialchars($stage['visible_users_names'] ?? '') ?></td>
              <td class="border px-4 py-2 text-center space-x-2 rtl:space-x-reverse">
                <a href="edit_stage.php?id=<?= $stage['id'] ?>" class="text-blue-600 hover:underline">✏️ تعديل</a>
                <a href="delete_stage.php?id=<?= $stage['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')" class="text-red-600 hover:underline">🗑 حذف</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
    <?php endif; ?>

    <?php if ($role === 'admin' && !empty($taskStages)): ?>
    <div class="mt-10">
      <h2 class="text-lg font-bold mb-4">📌 مراحل مرتبطة بالمهام (stage_id من جدول المهام)</h2>
      <ul class="list-disc px-6 text-gray-700">
        <?php foreach ($taskStages as $s): ?>
          <li>Stage ID: <?= htmlspecialchars($s['stage_id']) ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
    <?php endif; ?>

  </div>

  <script>
    new Sortable(document.getElementById('sortableStages').getElementsByTagName('tbody')[0], {
      animation: 200,
      onEnd: function () {
        const newOrder = [];
        document.querySelectorAll('.sortable-row').forEach((el, i) => {
          newOrder.push({ id: el.dataset.id, order: i });
        });

        fetch('update_stage_order.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(newOrder)
        });
      }
    });
  </script>

</body>
</html>
