<?php
require_once '../config/db.php';
require_once '../auth.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  echo "<p class='text-red-600'>❌ رقم المرحلة غير صالح.</p>";
  exit;
}

$stage_id = $_GET['id'];

$stmt = $conn->prepare("SELECT * FROM stages WHERE id = ?");
$stmt->execute([$stage_id]);
$stage = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$stage) {
  echo "<p class='text-red-600'>❌ لم يتم العثور على المرحلة.</p>";
  exit;
}

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
$users = $conn->query("SELECT id, name, department_id FROM users")->fetchAll(PDO::FETCH_ASSOC);

$visibleUsersStmt = $conn->prepare("SELECT user_id FROM stage_visible_users WHERE stage_id = ?");
$visibleUsersStmt->execute([$stage_id]);
$visible_user_ids = array_column($visibleUsersStmt->fetchAll(PDO::FETCH_ASSOC), 'user_id');
?>

<form method="POST" action="save_stage_edit.php" class="space-y-4" id="stageEditForm">
  <input type="hidden" name="id" value="<?= $stage['id'] ?>">

  <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
      <label class="block text-sm font-medium mb-1">اسم المرحلة</label>
      <input type="text" name="name" value="<?= htmlspecialchars($stage['name']) ?>" required class="w-full border rounded px-3 py-2">
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">درجة السرية</label>
      <select name="secret_level" class="w-full border rounded px-3 py-2">
        <option value="normal" <?= $stage['secret_level'] === 'normal' ? 'selected' : '' ?>>عادية</option>
        <option value="secret" <?= $stage['secret_level'] === 'secret' ? 'selected' : '' ?>>سرية</option>
        <option value="top_secret" <?= $stage['secret_level'] === 'top_secret' ? 'selected' : '' ?>>سرية جداً</option>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">لون المرحلة</label>
      <select name="color" class="w-full border rounded px-3 py-2">
        <option value="#6B7280" <?= $stage['color'] === '#6B7280' ? 'selected' : '' ?>>رمادي - جديد</option>
        <option value="#3B82F6" <?= $stage['color'] === '#3B82F6' ? 'selected' : '' ?>>أزرق - تحت التنفيذ</option>
        <option value="#10B981" <?= $stage['color'] === '#10B981' ? 'selected' : '' ?>>أخضر - مكتملة</option>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">الإدارة</label>
      <select name="department_id" class="w-full border rounded px-3 py-2">
        <?php foreach ($departments as $dep): ?>
          <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $stage['department_id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($dep['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">مرحلة مشتركة؟</label>
      <select name="is_shared" id="is_shared" class="w-full border rounded px-3 py-2">
        <option value="0" <?= $stage['is_shared'] == 0 ? 'selected' : '' ?>>لا</option>
        <option value="1" <?= $stage['is_shared'] == 1 ? 'selected' : '' ?>>نعم</option>
      </select>
    </div>

    <div id="share_with_all_wrapper">
      <label class="block text-sm font-medium mb-1">مشاركة مع جميع الإدارات؟</label>
      <input type="checkbox" id="share_with_all" name="share_with_all" value="1" <?= $stage['share_with_all'] ? 'checked' : '' ?>>
    </div>

    <div id="shared_dep_wrapper">
      <label class="block text-sm font-medium mb-1">الإدارة المشاركة (إن وجدت)</label>
      <select name="shared_department_id" class="w-full border rounded px-3 py-2">
        <option value="">-- اختر الإدارة --</option>
        <?php foreach ($departments as $dep): ?>
          <option value="<?= $dep['id'] ?>" <?= $stage['shared_department_id'] == $dep['id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($dep['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">مرحلة محسوبة في التقارير؟</label>
      <input type="checkbox" name="is_counted" value="1" <?= $stage['is_counted'] ? 'checked' : '' ?>>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">تفعيل النقل التلقائي؟</label>
      <input type="checkbox" name="is_auto" value="1" <?= $stage['is_auto'] ? 'checked' : '' ?>>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">عدد الأيام قبل الاستحقاق للنقل</label>
      <input type="number" name="auto_days" class="w-full border rounded px-3 py-2" value="<?= $stage['auto_days'] ?>">
    </div>

    <div class="md:col-span-2">
      <label class="block text-sm font-medium mb-1">المستخدمين المسموح لهم</label>
      <select name="visible_users[]" multiple class="w-full border rounded px-3 py-2 h-32">
        <?php foreach ($users as $user): ?>
          <option value="<?= $user['id'] ?>" <?= in_array($user['id'], $visible_user_ids) ? 'selected' : '' ?>>
            <?= htmlspecialchars($user['name']) ?> (<?= $user['department_id'] ?>)
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>

  <div class="text-left">
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">💾 حفظ التعديلات</button>
  </div>
</form>

<!-- ✅ سكربت بعد تحميل المودال -->
<script>
function initStageFormEvents() {
  const isShared = document.getElementById("is_shared");
  const shareWithAll = document.getElementById("share_with_all");
  const sharedDepWrapper = document.getElementById("shared_dep_wrapper");
  const shareWithAllWrapper = document.getElementById("share_with_all_wrapper");

  if (!isShared || !shareWithAll || !sharedDepWrapper) return;

  function toggle() {
    if (isShared.value === "1") {
      shareWithAllWrapper.style.display = "block";
      sharedDepWrapper.style.display = shareWithAll.checked ? "none" : "block";
    } else {
      shareWithAllWrapper.style.display = "none";
      sharedDepWrapper.style.display = "none";
    }
  }

  isShared.addEventListener("change", toggle);
  shareWithAll.addEventListener("change", toggle);
  toggle();
}

// ✅ شغل التهيئة فورًا بعد تحميل المودال
initStageFormEvents();
</script>
