<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// أول شي نتأكد فيه جلسة تسجيل دخول

if (!isset($_SESSION['user']) || !isset($_SESSION['user']['name']) || !isset($_SESSION['user']['email']) || !isset($_SESSION['user']['role']) || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}


$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $_GET['department_id'] ?? $user['department_id'];
$success_message = $_SESSION['success'] ?? null;
$error_message = $_SESSION['error'] ?? null;

$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$currentUserColorId = $user['color_id'];
unset($_SESSION['success'], $_SESSION['error']);

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);

if ($role === 'admin') {
  $userStmt = $conn->query("SELECT id, name, department_id FROM users");
  $users = $userStmt->fetchAll(PDO::FETCH_ASSOC);
} else {
  $userStmt = $conn->prepare("SELECT id, name, department_id FROM users WHERE department_id = ?");
  $userStmt->execute([$department_id]);
  $users = $userStmt->fetchAll(PDO::FETCH_ASSOC);
}

$stages = [];
$stageStmt = $conn->prepare("SELECT s.*, GROUP_CONCAT(u.name SEPARATOR ', ') as visible_users_names
                              FROM stages s
                              LEFT JOIN stage_visible_users sv ON s.id = sv.stage_id
                              LEFT JOIN users u ON sv.user_id = u.id
                              WHERE s.department_id = ?
                              GROUP BY s.id
                              ORDER BY s.order_number ASC");
$stageStmt->execute([$department_id]);
$stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);

$taskStages = [];
if ($role === 'admin') {
  $taskStages = $conn->query("SELECT DISTINCT stage_id FROM tasks WHERE stage_id IS NOT NULL")->fetchAll(PDO::FETCH_ASSOC);
}

$availableStages = $conn->prepare("SELECT id, name FROM stages WHERE department_id = ?");
$availableStages->execute([$department_id]);
$stageOptions = $availableStages->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>إدارة المراحل</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
  <style>
    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

     .text-button {
      color: #ffffff !important;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .move-button:hover , .view-tasks:hover  {
      background-color: rgb(19, 11, 57) !important;
    }

      .edit-button:hover , .view-button:hover , .download-button:hover , .delete-button:hover {
      color: <?= isset($currentUserColorId) && $currentUserColorId == 3 ? '#FFFFFF' : '#000000'; ?> !important;
}

.edit-button {
      background-color: #8BFB75 !important;
      color : #0e162a !important;  

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding-top: 5px;
      padding-bottom: 5px;
      margin-bottom: 5px;
      margin-right: 5px;
      text-decoration: none;
      box-sizing: border-box;

    }

    .delete-button {
      background-color: #FD7474  !important;      color: #FFFFFF!important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }
  </style>
</head>

<body class=" text-right">

  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class=" p-10">


    <div class="card max-w-3xl mx-auto mt-10 bg-white shadow rounded p-6">
      <h1 class="text text-2xl font-bold mb-6">⚙️ إدارة مراحل المهام</h1>

      <?php if ($success_message): ?>
        <div class="mb-4 p-3 text-green-800 rounded shadow" style="background-color: #7be667;">
          <?= $success_message ?>
        </div>
      <?php endif; ?>

      <?php if ($error_message): ?>
        <div class="mb-4 p-3 bg-red-100 text-red-800 rounded shadow">
          <?= $error_message ?>
        </div>
      <?php endif; ?>

      <?php if ($role === 'admin'): ?>
        <form method="GET" class="mb-6">
          <label class="block mb-1 text-sm">عرض مراحل إدارة معينة:</label>
          <select name="department_id" onchange="this.form.submit()" class="card border rounded px-3 py-2">
            <option value="">-- اختر الإدارة --</option>
            <?php foreach ($departments as $dep): ?>
              <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $department_id ? 'selected' : '' ?>><?= htmlspecialchars($dep['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </form>
      <?php endif; ?>

      <form method="POST" action="store_stage.php" class="space-y-4" id="stageAddForm">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm font-medium mb-1">اسم المرحلة</label>
            <input type="text" name="name" required class="card w-full border rounded px-3 py-2">
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">درجة السرية</label>
            <select name="secret_level" class="card w-full border rounded px-3 py-2">
              <option value="normal">عادية</option>
              <option value="secret">سرية</option>
              <option value="top_secret">سرية جداً</option>
            </select>
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">لون المرحلة</label>
            <select name="color" class="card w-full border rounded px-3 py-2">
              <option value="#6B7280">رمادي - جديد</option>
              <option value="#3B82F6">أزرق - تحت التنفيذ</option>
              <option value="#10B981">أخضر - مكتملة</option>
            </select>
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">الإدارة</label>
            <select name="department_id" class="card w-full border rounded px-3 py-2">
              <?php foreach ($departments as $dep): ?>
                <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">مرحلة مشتركة؟</label>
            <select name="is_shared" class="card w-full border rounded px-3 py-2">
              <option value="0">لا</option>
              <option value="1">نعم</option>
            </select>
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">مشاركة مع جميع الإدارات؟</label>
            <input type="checkbox" name="share_with_all" value="1">
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">الإدارة المشاركة (إن وجدت)</label>
            <select name="shared_department_id" class="card w-full border rounded px-3 py-2">
              <option value="">-- اختر الإدارة --</option>
              <?php foreach ($departments as $dep): ?>
                <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">مرحلة محسوبة في التقارير؟</label>
            <input type="checkbox" name="is_counted" value="1" class="card">
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">تفعيل النقل التلقائي؟</label>
            <input type="checkbox" name="is_auto" value="1" class="card">
          </div>

          <div>
            <label class="block text-sm font-medium mb-1">عدد الأيام قبل الاستحقاق للنقل</label>
            <input type="number" name="auto_days" class="card w-full border rounded px-3 py-2">
          </div>

          <div class="md:col-span-2">
            <label class="block text-sm font-medium mb-1">المستخدمين المسموح لهم</label>
            <select name="visible_users[]" multiple class="card w-full border rounded px-3 py-2 h-32">
              <?php foreach ($users as $user): ?>
                <option value="<?= $user['id'] ?>"><?= htmlspecialchars($user['name']) ?> (<?= $user['department_id'] ?>)</option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>

        <div class="text-left">
          <button type="submit" class=" move-button text-button   text-white px-4 py-2 rounded">➕ إضافة المرحلة</button>
        </div>
      </form>

      <?php if (!empty($stages)): ?>
        <div class="mt-10">
          <h2 class="text-lg font-bold mb-4">📋 المراحل المضافة</h2>
          <table class="min-w-full card border rounded" id="sortableStages">
            <thead class="">
              <tr>
                <th class="border px-4 py-2">الترتيب</th>
                <th class="border px-4 py-2">اسم المرحلة</th>
                <th class="border px-4 py-2">السرية</th>
                <th class="border px-4 py-2">الإدارة</th>
                <th class="border px-4 py-2">المستخدمين المسموح لهم</th>
                <th class="border px-4 py-2">خيارات</th>
                <th class="border px-4 py-2">📊 محتسبة؟</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($stages as $index => $stage): ?>
                <tr class="sortable-row" data-id="<?= $stage['id'] ?>">
                  <td class="border px-4 py-2">#<?= $index + 1 ?></td> <!-- الترتيب -->
                  <td class="border px-4 py-2 font-semibold" style="color: <?= htmlspecialchars($stage['color'] ?? '#6B7280') ?>">
                    <?= htmlspecialchars($stage['name']) ?>
                  </td> <!-- اسم المرحلة -->
                  <td class="border px-4 py-2"><?= htmlspecialchars($stage['secret_level']) ?></td> <!-- السرية -->
                  <td class="border px-4 py-2">
                    <?php
                    $depName = array_filter($departments, fn($d) => $d['id'] == $stage['department_id']);
                    echo htmlspecialchars(array_values($depName)[0]['name'] ?? '');
                    ?>
                  </td> <!-- الإدارة -->
                  <td class="border px-4 py-2 text-sm text-gray-700"><?= htmlspecialchars($stage['visible_users_names'] ?? '') ?></td> <!-- المستخدمين -->
                  <td class="border px-4 py-2 text-center space-x-2 rtl:space-x-reverse">
                    <button onclick="openStageModal(<?= $stage['id'] ?>)" class="text-blue-600 edit-button">✏️ تعديل</button>
                    <a href="delete_stage.php?id=<?= $stage['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')" class="text-red-600 delete-button">🗑 حذف</a>
                  </td> <!-- الخيارات -->
                  <td class="border px-4 py-2"><?= $stage['is_counted'] ? '✅' : '❌' ?></td> <!-- محتسبة؟ -->

                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>






      <!-- مودال تعديل المرحلة -->
      <div id="stageModal" class="fixed inset-0 bg-black bg-opacity-40 hidden z-50 flex items-center justify-center">
        <div class="bg-white max-w-2xl w-full rounded shadow-lg">
          <div class="flex justify-between items-center p-4 border-b">
            <h3 class="font-bold">✏️ تعديل المرحلة</h3>
            <button onclick="closeStageModal()" class="text-red-600 text-2xl">&times;</button>
          </div>
          <div id="stageModalContent" class="p-4">جاري التحميل...</div>
        </div>
      </div>

      <script>
        function openStageModal(id) {
          document.getElementById('stageModal').classList.remove('hidden');
          fetch('edit_stage_modal.php?id=' + id)
            .then(res => res.text())
            .then(html => {
              document.getElementById('stageModalContent').innerHTML = html;
            });
        }

        function closeStageModal() {
          document.getElementById('stageModal').classList.add('hidden');
        }

        new Sortable(document.getElementById('sortableStages').getElementsByTagName('tbody')[0], {
          animation: 200,
          onEnd: function() {
            const newOrder = [];
            document.querySelectorAll('.sortable-row').forEach((el, i) => {
              newOrder.push({
                id: el.dataset.id,
                order: i
              });
            });

            fetch('update_stage_order.php', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json'
              },
              body: JSON.stringify(newOrder)
            });
          }
        });
      </script>

      <script>
        document.addEventListener("DOMContentLoaded", function() {
          const isShared = document.getElementById("is_shared");
          const shareWithAllWrapper = document.getElementById("share_with_all_wrapper");
          const sharedDepWrapper = document.getElementById("shared_department_wrapper");
          const shareWithAll = document.getElementById("share_with_all");

          function toggleSharedOptions() {
            if (isShared.checked) {
              shareWithAllWrapper.style.display = "block";
              if (shareWithAll?.value == "0") {
                sharedDepWrapper.style.display = "block";
              } else {
                sharedDepWrapper.style.display = "none";
              }
            } else {
              shareWithAllWrapper.style.display = "none";
              sharedDepWrapper.style.display = "none";
            }
          }

          isShared.addEventListener("change", toggleSharedOptions);
          shareWithAll?.addEventListener("change", toggleSharedOptions);

          toggleSharedOptions();
        });
      </script>



</body>

</html>