<?php
require_once '../config/db.php';
require_once '../auth.php';

// خله يسجل الأخطاء باللوق ولا يطبعها للمتصفح (عشان ما يكسر header)
ini_set('display_errors', '0');
ini_set('log_errors', '1');
error_reporting(E_ALL);

// إذا، ولا غالبًا auth.php يبدأ الجلسة.. هذا الشرط يحميك لو تغيّر مستقبلاً
if (function_exists('session_status') && session_status() === PHP_SESSION_NONE) {
    session_start();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // تاريخ اليوم (بداية اليوم)
    $today = new DateTimeImmutable('today');

    $user_id = $_SESSION['user']['id'] ?? 0;
    $moved_count = 0;

    // مراحل التحريك التلقائي
    $stages = $conn->query("
        SELECT id, department_id, auto_days, color
        FROM stages
        WHERE is_auto = 1 AND auto_days IS NOT NULL
    ")->fetchAll(PDO::FETCH_ASSOC);

    foreach ($stages as $stage) {
        $stage_id       = (int)$stage['id'];
        $department_id  = (int)$stage['department_id'];
        $auto_days      = max(0, (int)$stage['auto_days']);
        $color          = strtoupper(trim($stage['color']));

        // تخطّي مراحل مكتملة (أخضر)
        if ($color === '#10B981') {
            continue;
        }

        // المهام المرشّحة داخل نفس الإدارة
        $stmt = $conn->prepare("
            SELECT id, due_date
            FROM tasks
            WHERE department_id = ?
              AND due_date IS NOT NULL
              AND stage_id <> ?
              AND is_deleted = 0
        ");
        $stmt->execute([$department_id, $stage_id]);
        $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($tasks as $task) {
            $task_id  = (int)$task['id'];
            $due_date = new DateTimeImmutable($task['due_date']);

            // الفرق بالأيام (مطلق) + نتحقق أن الاستحقاق بالمستقبل/اليوم
            $is_future = ($due_date >= $today);
            $diff_days = $today->diff($due_date)->days; // مطلق

            // انقل إذا باقي <= auto_days
            if ($is_future && $diff_days <= $auto_days) {
                $update = $conn->prepare("UPDATE tasks SET stage_id = ? WHERE id = ?");
                $update->execute([$stage_id, $task_id]);

                $log = $conn->prepare("
                    INSERT INTO task_logs (task_id, user_id, action_type, action_details)
                    VALUES (?, ?, 'auto_move', 'انتقلت تلقائيًا بسبب قرب تاريخ الاستحقاق')
                ");
                $log->execute([$task_id, $user_id]);

                $moved_count++;
            }
        }
    }

    // استخدم الهيدر بعد ما تأكدنا ما فيه أي مخرجات
    if (!headers_sent()) {
        $_SESSION['success'] = "✅ تم نقل {$moved_count} مهمة تلقائيًا.";
        header("Location: ../tasks/dashboard/index.php");
        exit;
    } else {
        // احتياط لو انرسل هيدر لأي سبب
        echo '<meta http-equiv="refresh" content="0;url=../tasks/dashboard/index.php">';
        exit;
    }
}
