<?php
require_once '../config/db.php';
require_once '../auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $name = $_POST['name'];
    $secret_level = $_POST['secret_level'];
    $color = $_POST['color'];
    $department_id = $_POST['department_id'];
    $visible_users = $_POST['visible_users'] ?? [];

    $is_shared = isset($_POST['is_shared']) ? intval($_POST['is_shared']) : 0;
    $share_with_all = isset($_POST['share_with_all']) ? intval($_POST['share_with_all']) : 0;
    $shared_department_id = (!$share_with_all && !empty($_POST['shared_department_id'])) ? intval($_POST['shared_department_id']) : null;

    $is_counted = isset($_POST['is_counted']) ? 1 : 0;

    // ✅ المضافة:
    $is_auto = isset($_POST['is_auto']) ? 1 : 0;
    $auto_days = !empty($_POST['auto_days']) ? intval($_POST['auto_days']) : null;

    $stmt = $conn->prepare("
      UPDATE stages 
      SET name = ?, secret_level = ?, color = ?, department_id = ?, 
          is_shared = ?, share_with_all = ?, shared_department_id = ?, is_counted = ?, 
          is_auto = ?, auto_days = ?
      WHERE id = ?
    ");
    $stmt->execute([
        $name,
        $secret_level,
        $color,
        $department_id,
        $is_shared,
        $share_with_all,
        $shared_department_id,
        $is_counted,
        $is_auto,
        $auto_days,
        $id
    ]);

    $deleteStmt = $conn->prepare("DELETE FROM stage_visible_users WHERE stage_id = ?");
    $deleteStmt->execute([$id]);

    $insertStmt = $conn->prepare("INSERT INTO stage_visible_users (stage_id, user_id) VALUES (?, ?)");
    foreach ($visible_users as $user_id) {
        $insertStmt->execute([$id, $user_id]);
    }

    header("Location: index.php?success=1");
    exit;
}
