<?php
require_once '../config/db.php';
require_once '../auth.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo "🚫 طلب غير صالح.";
    exit;
}

// مدخلات آمنة
$name          = trim($_POST['name'] ?? '');
$secret_level  = $_POST['secret_level'] ?? 'normal';
$color         = $_POST['color'] ?? '#3B82F6';

// department_id: رقم أو NULL
$department_id = (isset($_POST['department_id']) && $_POST['department_id'] !== '')
    ? (int) $_POST['department_id']
    : null;

// visible_users: مصفوفة أرقام
$visible_users = array_filter(
    (array)($_POST['visible_users'] ?? []),
    fn($v) => ctype_digit((string)$v)
);
$visible_users = array_map('intval', $visible_users);

// أعلام من النموذج
$is_shared      = isset($_POST['is_shared']) ? 1 : 0;
$share_with_all = isset($_POST['share_with_all']) ? 1 : 0;
$is_counted     = isset($_POST['is_counted']) ? 1 : 0;
$is_auto        = isset($_POST['is_auto']) ? 1 : 0;

// shared_department_id: إذا share_with_all أو is_shared=0 => NULL
if ($share_with_all || !$is_shared) {
    $shared_department_id = null;
} else {
    $shared_department_id = (isset($_POST['shared_department_id']) && $_POST['shared_department_id'] !== '')
        ? (int) $_POST['shared_department_id']
        : null;
}

// auto_days: رقم صحيح أو NULL (و NULL إذا is_auto غير مفعّل)
$auto_days = null;
if ($is_auto) {
    $auto_days = (isset($_POST['auto_days']) && $_POST['auto_days'] !== '')
        ? (int) $_POST['auto_days']
        : null;
}

// تحقق الحقول الأساسية
if ($name === '' || $department_id === null) {
    $_SESSION['error'] = "❌ جميع الحقول مطلوبة";
    header("Location: index.php");
    exit;
}

try {
    // ترتيب المرحلة التالي داخل نفس الإدارة
    $stmt = $conn->prepare("SELECT COALESCE(MAX(order_number), 0) + 1 AS next_order FROM stages WHERE department_id = ?");
    $stmt->execute([$department_id]);
    $order_number = (int) $stmt->fetchColumn();

    // إدخال المرحلة
    $stmt = $conn->prepare("
        INSERT INTO stages 
            (name, secret_level, color, department_id, is_auto, auto_days, order_number, is_shared, shared_department_id, is_counted, share_with_all) 
        VALUES 
            (:name, :secret_level, :color, :department_id, :is_auto, :auto_days, :order_number, :is_shared, :shared_department_id, :is_counted, :share_with_all)
    ");

    $stmt->bindValue(':name', $name, PDO::PARAM_STR);
    $stmt->bindValue(':secret_level', $secret_level, PDO::PARAM_STR);
    $stmt->bindValue(':color', $color, PDO::PARAM_STR);

    // INTs / NULLs
    $stmt->bindValue(':department_id', $department_id, PDO::PARAM_INT);
    $stmt->bindValue(':is_auto', $is_auto, PDO::PARAM_INT);
    $stmt->bindValue(':order_number', $order_number, PDO::PARAM_INT);
    $stmt->bindValue(':is_shared', $is_shared, PDO::PARAM_INT);
    $stmt->bindValue(':is_counted', $is_counted, PDO::PARAM_INT);
    $stmt->bindValue(':share_with_all', $share_with_all, PDO::PARAM_INT);

    // NULL-safe binds
    if ($auto_days === null) {
        $stmt->bindValue(':auto_days', null, PDO::PARAM_NULL);
    } else {
        $stmt->bindValue(':auto_days', $auto_days, PDO::PARAM_INT);
    }

    if ($shared_department_id === null) {
        $stmt->bindValue(':shared_department_id', null, PDO::PARAM_NULL);
    } else {
        $stmt->bindValue(':shared_department_id', $shared_department_id, PDO::PARAM_INT);
    }

    $stmt->execute();
    $stage_id = (int) $conn->lastInsertId();

    // المستخدمين اللي يشوفون المرحلة
    if (!empty($visible_users)) {
        $stmtVU = $conn->prepare("INSERT INTO stage_visible_users (stage_id, user_id) VALUES (?, ?)");
        foreach ($visible_users as $uid) {
            $stmtVU->execute([$stage_id, $uid]);
        }
    }

    $_SESSION['success'] = "✅ تم حفظ المرحلة بنجاح";
    header("Location: index.php?department_id={$department_id}");
    exit;

} catch (PDOException $e) {
    // سجل الخطأ للمطور، وأعرض رسالة ودية
    error_log("store_stage.php error: " . $e->getMessage());
    $_SESSION['error'] = "❌ حدث خطأ أثناء الحفظ. تأكد من القيم وأعد المحاولة.";
    header("Location: index.php?department_id={$department_id}");
    exit;
}
