<?php
require_once '../config/db.php';
require_once '../auth.php';

header('Content-Type: application/json');

// السماح فقط للمدير العام
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
  http_response_code(403);
  echo json_encode(['error' => 'غير مصرح']);
  exit;
}

// قراءة البيانات
$data = json_decode(file_get_contents("php://input"), true);

if (!is_array($data)) {
  http_response_code(400);
  echo json_encode(['error' => 'بيانات غير صالحة']);
  exit;
}

// تحديث ترتيب كل مرحلة
foreach ($data as $item) {
  if (!isset($item['id'], $item['order'])) continue;

  $stmt = $conn->prepare("UPDATE stages SET order_number = ? WHERE id = ?");
  $stmt->execute([$item['order'], $item['id']]);
}

echo json_encode(['status' => 'success']);
