<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $_GET['department_id'] ?? ($role === 'admin' ? null : $user['department_id']);
$success_message = $_SESSION['success'] ?? null;
unset($_SESSION['success']);

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
if ($role === 'admin') {
  // المدير العام يشوف كل المستخدمين
  $users = $conn->query("SELECT id, name, department_id, role FROM users")->fetchAll(PDO::FETCH_ASSOC);

} elseif ($role === 'manager') {
  // المدير يشوف المدير العام + المدراء + موظفي إدارته
  $stmt = $conn->prepare("
    SELECT id, name, department_id, role FROM users
    WHERE role IN ('admin', 'manager') OR (role = 'employee' AND department_id = ?)
  ");
  $stmt->execute([$department_id]);
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

} elseif ($role === 'employee') {
  // الموظف يشوف المدير حقة وزملائه
  $stmt = $conn->prepare("
    SELECT id, name, department_id, role FROM users
    WHERE department_id = ? AND role IN ('manager', 'employee')
  ");
  $stmt->execute([$department_id]);
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// إضافة اسم المستخدم الحالي إذا ما كان ضمن القائمة
$exists = array_filter($users, fn($u) => $u['id'] == $user['id']);
if (!$exists) {
  $users[] = [
    'id' => $user['id'],
    'name' => $user['name'],
    'department_id' => $user['department_id'],
    'role' => $user['role']
  ];
}

// جلب المشاريع كلها (أو حسب الإدارة إذا تبي)
$projects = $conn->query("SELECT id, name FROM projects ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

// جلب التصنيفات من الجدول الجديد
$types = $conn->query("SELECT id, name FROM task_types ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

function getCustomFields($conn, $department_id) {
  $stmt = $conn->prepare("SELECT * FROM custom_fields WHERE department_id = ?");
  $stmt->execute([$department_id]);
  return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$customFields = $department_id ? getCustomFields($conn, $department_id) : [];

$stageStmt = $conn->prepare("SELECT id, name FROM stages WHERE department_id = ?");
$stageStmt->execute([$department_id]);
$stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إضافة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-right">
  <div class="max-w-2xl mx-auto mt-10 bg-white shadow rounded p-6">
    <h1 class="text-xl font-bold mb-4">➕ إضافة جديدة</h1>

    <?php if ($success_message): ?>
      <div class="mb-4 p-3 bg-green-100 text-green-800 rounded shadow">
        <?= $success_message ?>
      </div>
    <?php endif; ?>

    <?php if ($role === 'admin' && !$department_id): ?>
      <form method="GET">
        <label class="block text-sm font-medium mb-1">اختر الإدارة أولا:</label>
        <select name="department_id" onchange="this.form.submit()" class="w-full border rounded px-3 py-2">
          <option value="">-- اختر الإدارة --</option>
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>"><?= $dep['name'] ?></option>
          <?php endforeach; ?>
        </select>
      </form>
    <?php elseif ($department_id): ?>

    <form method="POST" action="store.php" class="space-y-4" id="task-form" enctype="multipart/form-data">
      <input type="hidden" name="department_id" value="<?= $department_id ?>">

      <div>
        <label class="block text-sm font-medium mb-1">العنوان</label>
        <input type="text" name="title" required class="w-full border rounded px-3 py-2">
      </div>

      <div>
        <label class="block text-sm font-medium mb-1">الوصف</label>
        <textarea name="description" rows="3" required class="w-full border rounded px-3 py-2"></textarea>
      </div>
<div>
  <label for="task_type_id" class="block text-sm font-medium mb-1">التصنيف</label>
  <select name="task_type_id" id="task_type_id" class="w-full border rounded px-3 py-2" required>
    <option value="">اختر التصنيف</option>
    <?php foreach ($types as $type): ?>
      <option value="<?= $type['id'] ?>"><?= htmlspecialchars($type['name']) ?></option>
    <?php endforeach; ?>
  </select>
</div>


<div>
  <label class="block text-sm font-medium mb-1">المشروع المرتبط (اختياري):</label>
  <select name="project_id" class="w-full border rounded px-3 py-2">
    <option value="">بدون مشروع</option>
    <?php foreach ($projects as $proj): ?>
      <option value="<?= $proj['id'] ?>"><?= htmlspecialchars($proj['name']) ?></option>
    <?php endforeach; ?>
  </select>
</div>

      <div class="grid grid-cols-2 gap-4">
        <div>
          <label class="block text-sm font-medium mb-1">المرحلة</label>
          <select name="stage_id" class="w-full border rounded px-3 py-2">
            <?php foreach ($stages as $stage): ?>
              <option value="<?= $stage['id'] ?>"><?= htmlspecialchars($stage['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium mb-1">الأولوية</label>
          <select name="priority" class="w-full border rounded px-3 py-2">
            <option value="low">منخفضة</option>
            <option value="medium">متوسطة</option>
            <option value="high">عالية</option>
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium mb-1">السرية</label>
          <select name="secret_level" class="w-full border rounded px-3 py-2">
            <option value="normal">عادية</option>
            <option value="secret">سرية</option>
            <option value="top_secret">سرية جداً</option>
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium mb-1">تاريخ الاستحقاق*</label>
<input type="date" name="due_date" required class="w-full border rounded px-3 py-2">
        </div>

        <div>
          <label class="block text-sm font-medium mb-1">تعيين إلى</label>
          <select name="assigned_to" class="w-full border rounded px-3 py-2">
            <?php foreach ($users as $u): ?>
              <option value="<?= $u['id'] ?>"><?= $u['name'] ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium mb-1">📎 المرفقات</label>
          <input type="file" name="attachments[]" multiple class="w-full border rounded px-3 py-2">
        </div>
      </div>

      <?php foreach ($customFields as $field): ?>
  <div>
    <label class="block text-sm font-medium mb-1"><?= htmlspecialchars($field['label']) ?></label>
    <?php if ($field['type'] === 'text'): ?>
      <input type="text" name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
    <?php elseif ($field['type'] === 'number'): ?>
      <input type="number" name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
    <?php elseif ($field['type'] === 'date'): ?>
      <input type="date" name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
    <?php elseif ($field['type'] === 'dropdown'): ?>
      <select name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
        <?php
          $options = explode(',', $field['options']);
          foreach ($options as $opt):
        ?>
          <option value="<?= trim($opt) ?>"><?= htmlspecialchars(trim($opt)) ?></option>
        <?php endforeach; ?>
      </select>
    <?php endif; ?>
  </div>
<?php endforeach; ?>
 

      <div class="text-center pt-4">
        <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded hover:bg-green-700">📀 حفظ</button>
      </div>
    </form>
    <?php endif; ?>
  </div>
</body>
</html>