<?php
session_start();
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

/* منع الكاش عشان تظهر الأرشفة الجديدة فورًا */
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'], ['admin', 'manager'])) {
    session_unset();
    session_destroy();
    header('Location: ../unauthorized.php');
    exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$type = $_GET['type'] ?? 'archived';          // archived | deleted
$department_id = $_GET['department_id'] ?? ''; // فلتر الإدارة (اختياري)

/* جلب الإدارات للقائمة */
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// جلب كل المراحل مع الإدارة تبعها
$stages = $conn->query("
  SELECT id, name, department_id 
  FROM stages 
  ORDER BY department_id, id
")->fetchAll(PDO::FETCH_ASSOC);

$stagesByDept = [];
foreach ($stages as $s) {
  $depId = (int)$s['department_id'];
  if (!isset($stagesByDept[$depId])) $stagesByDept[$depId] = [];
  $stagesByDept[$depId][] = ['id' => (int)$s['id'], 'name' => $s['name']];
}

/* بناء الاستعلام */
$params = [];
$where = [];
$joins = "
  FROM tasks t
  LEFT JOIN users u ON t.assigned_to = u.id
  LEFT JOIN departments d ON t.department_id = d.id
";

if ($type === 'archived') {
  // المؤرشف: إمّا عنده archived_at أو موسوم archived – نستبعد المحذوف
  $where[] = "t.is_deleted = 0";
  $where[] = "(t.archived_at IS NOT NULL OR t.archive_type = 'archived')";
} elseif ($type === 'deleted') {
  $where[] = "t.is_deleted = 1";
} else {
  $where[] = "1=0";
}

// فلتر الإدارة من القائمة (اختياري)
if ($department_id !== '') {
  $where[] = "t.department_id = ?";
  $params[] = (int)$department_id;
}

// المانجر يشوف إدارته فقط إذا ما اختار إدارة
if ($role !== 'admin' && $department_id === '') {
  $where[] = "t.department_id = ?";
  $params[] = (int)$user['department_id'];
}

$whereSql = $where ? ("WHERE " . implode(" AND ", $where)) : "";

$orderSql = ($type === 'archived')
  ? " ORDER BY t.archived_at DESC, t.id DESC"
  : " ORDER BY t.deleted_at DESC, t.id DESC";

$query = "
  SELECT t.*, u.name AS assigned_name, d.name AS department_name
  $joins
  $whereSql
  $orderSql
";
$stmt = $conn->prepare($query);
$stmt->execute($params);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
$type = $_GET['type'] ?? 'archived';
if (!in_array($type, ['archived','deleted'], true)) { $type = 'archived'; }

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <title><?= $type === 'archived' ? '🗃️ المهام المؤرشفة' : '🗑️ المهام المحذوفة' ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>

</head>
<body class="bg-gray-100">
<?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>

<div class="max-w-7xl mx-auto mt-6 bg-white p-6 rounded shadow">
  <div class="flex justify-between items-center mb-4">
    <h1 class="text-2xl font-bold">
      <?= $type === 'archived' ? '🗃️ المهام المؤرشفة' : '🗑️ المهام المحذوفة' ?>
    </h1>

    <form method="GET" class="flex items-center gap-4">
      <select name="type" onchange="this.form.submit()" class="border px-3 py-1 rounded">
        <option value="archived" <?= $type === 'archived' ? 'selected' : '' ?>>المهام المؤرشفة</option>
        <option value="deleted"  <?= $type === 'deleted'  ? 'selected' : '' ?>>المهام المحذوفة</option>
      </select>

      <select name="department_id" onchange="this.form.submit()" class="border px-3 py-1 rounded">
        <option value="">كل الإدارات</option>
        <?php foreach ($departments as $dep): ?>
          <option value="<?= $dep['id'] ?>" <?= ($department_id !== '' && (int)$department_id === (int)$dep['id']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($dep['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
      <!-- داخل الـ form حق الفلاتر -->
<a href="help_archive.php" target="_blank" rel="noopener"
   class="move-button text-button text-white px-4 py-2 rounded no-print inline-flex items-center gap-1"
   title="تعليمات الأرشيف">❓ تعليمات</a>

    </form>
  </div>

  <table class="min-w-full border text-sm">
    <thead class="bg-gray-100">
      <tr>
        <th class="border px-3 py-2">العنوان</th>
        <th class="border px-3 py-2">الوصف</th>
        <th class="border px-3 py-2">الإدارة</th>
        <th class="border px-3 py-2">المسؤول</th>
        <th class="border px-3 py-2"><?= $type === 'archived' ? 'تاريخ الأرشفة' : 'تاريخ الحذف' ?></th>
        <th class="border px-3 py-2">خيارات</th>
      </tr>
    </thead>
    <tbody>
      <?php if (!$tasks): ?>
        <tr>
          <td colspan="6" class="border px-3 py-4 text-center text-gray-500">
            ما فيه سجلات مطابقة حالياً.
          </td>
        </tr>
      <?php else: foreach ($tasks as $task): ?>
        <tr class="hover:bg-gray-50">
          <td class="border px-3 py-2"><?= htmlspecialchars($task['title'] ?? '') ?></td>
          <td class="border px-3 py-2"><?= htmlspecialchars($task['description'] ?? '') ?></td>
          <td class="border px-3 py-2"><?= htmlspecialchars($task['department_name'] ?? '') ?></td>
          <td class="border px-3 py-2"><?= htmlspecialchars($task['assigned_name'] ?? '') ?></td>
          <td class="border px-3 py-2">
            <?= htmlspecialchars($type === 'archived' ? ($task['archived_at'] ?? '') : ($task['deleted_at'] ?? '')) ?>
          </td>
          <td class="border px-3 py-2 text-center">
            <?php if ($type === 'archived'): ?>
<form action="restore_task.php" method="POST" onsubmit="return confirm('تأكيد استعادة المهمة؟');" class="inline-flex gap-2 items-center">
  <input type="hidden" name="task_id" value="<?= (int)$task['id'] ?>">

  <!-- اختيار الإدارة -->
  <select name="new_department_id" required class="border px-2 py-1 rounded text-sm" onchange="fillStages(this)">
    <option value="">اختر الإدارة</option>
    <?php foreach ($departments as $dep): ?>
      <option value="<?= (int)$dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
    <?php endforeach; ?>
  </select>

  <!-- اختيار المرحلة (تتعّبى حسب الإدارة) -->
  <select name="new_stage_id" required class="border px-2 py-1 rounded text-sm">
    <option value="">اختر المرحلة</option>
  </select>

  <!-- خيار: فتح المودال بعد الاستعادة -->
  <label class="text-xs flex items-center gap-1">
    <input type="checkbox" name="open_after" value="1">
    فتح التعديل بعد الاستعادة
  </label>

  <button type="submit" class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700">استعادة</button>

  <!-- زر تعديل متقدم (يفتح الكانبان ويفتح المودال تلقائيًا) -->
  <a target="_blank" href="../kanban.php?open_task_id=<?= (int)$task['id'] ?>"
     class="border px-3 py-1 rounded text-sm hover:bg-gray-50">تعديل متقدم</a>
</form>
            <?php else: ?>
              <!-- خيارات إضافية للمحذوف (إن وجدت) -->
              <span class="text-gray-400">—</span>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; endif; ?>
    </tbody>
  </table>
</div>
<script>
  window.STAGES_BY_DEPT = <?= json_encode($stagesByDept, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) ?>;
  function fillStages(depSelect){
    const form = depSelect.closest('form');
    const stageSelect = form.querySelector('select[name="new_stage_id"]');
    const depId = parseInt(depSelect.value || 0, 10);
    stageSelect.innerHTML = '<option value="">اختر المرحلة</option>';
    if (window.STAGES_BY_DEPT && window.STAGES_BY_DEPT[depId]) {
      window.STAGES_BY_DEPT[depId].forEach(s=>{
        const opt = document.createElement('option');
        opt.value = s.id;
        opt.textContent = s.name;
        stageSelect.appendChild(opt);
      });
    }
  }
</script>

</body>
</html>