<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// أول شي نتأكد فيه جلسة تسجيل دخول

if (
  !isset($_SESSION['user'])
  || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])
) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}


// بعدين نقرأ الجلسة بأمان
$user = $_SESSION['user'];
$role = $user['role'];
$type = $_GET['type'] ?? 'archived'; // archived أو deleted
$department_id = $_GET['department_id'] ?? null;
$user_secret_level = $user['secret_level'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];

// جلب الإدارات
$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);


// إعداد الاستعلام
$params = [$type];

if ($role === 'admin') {
  // الإدمن يشوف كل شيء
  $query = "
        SELECT a.*, u.name AS assigned_name, d.name AS department_name
        FROM archived_tasks a
        LEFT JOIN users u ON a.assigned_to = u.id
        LEFT JOIN departments d ON a.department_id = d.id
        WHERE a.archive_type = ?
    ";
  if (!empty($department_id)) {
    $query .= " AND a.department_id = ?";
    $params[] = $department_id;
  }
} else {
  // المدير أو المستخدم يشوفون بس إدارتهم
  $query = "
        SELECT a.*, u.name AS assigned_name, d.name AS department_name
        FROM archived_tasks a
        LEFT JOIN users u ON a.assigned_to = u.id
        LEFT JOIN departments d ON a.department_id = d.id
        WHERE a.archive_type = ? AND a.department_id = ?
    ";
  $params[] = $user['department_id'];
}

// تنفيذ الاستعلام
$stmt = $conn->prepare($query);
$stmt->execute($params);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title><?= $type === 'archived' ? '🗃️ المهام المؤرشفة' : '🗑️ المهام المحذوفة' ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Include Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

  <!-- Include jQuery (required by Select2) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Include Select2 JS -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

  <style>
    /* Custom styles to make the Select2 dropdown larger */
    .select2-container .select2-selection--single {
      height: 48px;
      /* Increase height of the select box */
      line-height: 48px;
      /* Align text vertically */
      font-size: 12px;
      /* Larger font size for selected item */
    }

    .select2-container--default .select2-selection--single {
      background-color: <?php echo $userThemeNavColor; ?> !important;
      border: none;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
      line-height: 48px;
      color: <?php echo $userThemeTextColor; ?> !important;
      /* Ensure text aligns with height */
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 48px;
      /* Adjust arrow height to match */
    }

    .select2-dropdown {
      font-size: 12px;
      /* Larger font size for dropdown options */
    }

    .select2-results__option {
      padding: 12px;
      /* More padding for larger options */
      line-height: 24px;
      /* Adjust line height for larger square and text */
    }

    /* Optional: Ensure the select takes full width or a specific width */
    .select2-container {
      width: 100% !important;
      /* Full width, or set a specific width like 300px */
    }

    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,
    h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }
  </style>
</head>

<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<script>
  const userMenuButton = document.getElementById('userMenuButton');
  const userDropdown = document.getElementById('userDropdown');

  userMenuButton.addEventListener('click', function(event) {
    event.stopPropagation();
    userDropdown.classList.toggle('hidden');
  });

  window.addEventListener('click', function(e) {
    if (!userDropdown.contains(e.target) && !userMenuButton.contains(e.target)) {
      userDropdown.classList.add('hidden');
    }


    $(document).ready(function() {
      $('#theme_color_select').select2({
        templateResult: formatColorOption,
        templateSelection: formatColorOption
      });

      // Function to format the dropdown option and selected item
      function formatColorOption(option) {
        if (!option.id) {
          return option.text; // Placeholder or "No colors available"
        }
        // Get the hex code from the data-hex attribute
        var hexCode = $(option.element).data('hex');
        // Create a colored square and append the color name
        var $option = $(
          '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
        );
        return $option;
      }

      // Ensure form submission still works
      $('#theme_color_select').on('select2:select', function(e) {
        $(this).closest('form').submit();
      });
    });
  });
</script>

<div class=" max-w-7xl mx-auto mt-6 bg-white p-6 rounded shadow">

  <div class="flex justify-between items-center mb-4">
    <h1 class="text-2xl font-bold">
      <?= $type === 'archived' ? '🗃️ المهام المؤرشفة' : '🗑️ المهام المحذوفة' ?>
    </h1>
    <form method="GET" class="flex items-center gap-4">
      <select name="type" onchange="this.form.submit()" class="card border px-3 py-1 rounded">
        <option value="archived" <?= $type === 'archived' ? 'selected' : '' ?>>المهام المؤرشفة</option>
        <option value="deleted" <?= $type === 'deleted' ? 'selected' : '' ?>>المهام المحذوفة</option>
      </select>

      <?php if ($role === 'admin'): ?>
        <select name="department_id" onchange="this.form.submit()" class="card border px-3 py-1 rounded">
          <option value="">كل الإدارات</option>
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $department_id ? 'selected' : '' ?>>
              <?= htmlspecialchars($dep['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      <?php endif; ?>
    </form>
  </div>
  <table class="card min-w-full text-sm border border-gray-300">
    <thead class="">
      <tr>
        <th class="px-4 py-2 border">العنوان</th>
        <th class="px-4 py-2 border">الوصف</th>
        <th class="px-4 py-2 border">المسؤول</th>
        <th class="px-4 py-2 border">الإدارة</th>
        <th class="px-4 py-2 border">تاريخ الأرشفة</th>
        <th class="px-4 py-2 border">الإجراءات</th>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($tasks)): ?>
        <tr>
          <td colspan="6" class="border px-3 py-4 text-center text-gray-500">
            لا توجد مهام حالياً.
          </td>
        </tr>
      <?php else: ?>
        <?php foreach ($tasks as $task): ?>
          <tr class="hover:bg-gray-50">
            <td class="border px-3 py-2"><?= htmlspecialchars($task['title']) ?></td>
            <td class="border px-3 py-2"><?= htmlspecialchars($task['description']) ?></td>
            <td class="border px-3 py-2"><?= htmlspecialchars($task['department_name']) ?></td>
            <td class="border px-3 py-2"><?= htmlspecialchars($task['assigned_name']) ?></td>
            <td class="border px-3 py-2"><?= htmlspecialchars($task['archived_at']) ?></td>
            <td class="border px-3 py-2 text-center">
              <form action="restore_task.php" method="POST" onsubmit="return confirm('هل أنت متأكد من استعادة المهمة؟');">
                <input type="hidden" name="task_id" value="<?= $task['original_task_id'] ?>">
                <select name="new_department_id" required class="card border px-2 py-1 rounded text-sm">
                  <?php foreach ($departments as $dep): ?>
                    <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
                  <?php endforeach; ?>
                </select>
                <button type="submit" class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700">
                  استعادة
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
    </tbody>
  </table>
</div>
</body>

</html>