<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config/db.php';

$today = date('Y-m-d H:i:s');

// جلب مراحل اللون الأخضر
$stageStmt = $conn->prepare("SELECT id FROM stages WHERE LOWER(color) = LOWER('#10b981')");
$stageStmt->execute();
$completedStageIds = $stageStmt->fetchAll(PDO::FETCH_COLUMN);

if (empty($completedStageIds)) {
    echo "❌ لا توجد مراحل مكتملة باللون الأخضر.";
    exit;
}

// جلب المهام القابلة للأرشفة
$placeholders = str_repeat('?,', count($completedStageIds) - 1) . '?';
$sql = "SELECT * 
        FROM tasks
        WHERE stage_id IN ($placeholders)
          AND completed_at IS NOT NULL
AND completed_at <= DATE_SUB(NOW(), INTERVAL 7 DAY)
          AND archived_at IS NULL 
          AND is_deleted = 0";

$stmt = $conn->prepare($sql);
$stmt->execute($completedStageIds);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h3>المهام القابلة للأرشفة:</h3><pre>";
print_r($tasks);
echo "</pre>";

$count = 0;
foreach ($tasks as $task) {
    $task_id = $task['id'];
    $archived_at = date('Y-m-d H:i:s');

    // معالجة due_date
    $due_date = $task['due_date'];
    if ($due_date == '0000-00-00' || empty($due_date)) {
        $due_date = date('Y-m-d'); // نضع تاريخ اليوم
    }

    // إدخال نسخة من المهمة إلى جدول archived_tasks بدون status
    $insert = $conn->prepare("
        INSERT INTO archived_tasks (
            original_task_id, title, description, priority, secret_level,
            department_id, assigned_to, created_at, due_date, archived_at, archive_type
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $ok_insert = $insert->execute([
        $task_id,
        $task['title'],
        $task['description'],
        $task['priority'],
        $task['secret_level'],
        $task['department_id'],
        $task['assigned_to'],
        $task['created_at'],
        $due_date,
        $archived_at,
        'archived'
    ]);

    if (!$ok_insert) {
        echo "❌ فشل الإدخال للمهمة {$task_id}: ";
        print_r($insert->errorInfo());
        continue;
    }

    // تحديث المهمة لجعلها مؤرشفة وتحديد نوع الأرشفة
    $update = $conn->prepare("UPDATE tasks SET archived_at = ?, archive_type = ? WHERE id = ?");
    $ok_update = $update->execute([$archived_at, 'archived', $task_id]);
    if (!$ok_update) {
        echo "❌ فشل أرشفة المهمة {$task_id}: ";
        print_r($update->errorInfo());
        continue;
    }

$system_user_id = 1; // غير الرقم 1 لأي رقم مستخدم خاص بالسيستم عندك
$conn->prepare(
    "INSERT INTO task_logs (task_id, user_id, action_type, action_details)
     VALUES (?, ?, 'auto_archive', 'تمت أرشفة المهمة تلقائيًا بعد 7 أيام من الإكمال')"
)->execute([$task_id, $system_user_id]);

    $count++;
}

echo "<h3>✅ تم أرشفة {$count} مهمة من المراحل المكتملة إلى جدول archived_tasks.</h3>";
?>
