<?php
session_start();
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['task_id'])) {
    header('Location: list.php');
    exit;
}

$task_id = (int)$_POST['task_id'];

try {
    $conn->beginTransaction();

    // جلب بيانات المهمة
    $stmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
    $stmt->execute([$task_id]);
    $task = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$task) {
        throw new Exception('المهمة غير موجودة');
    }

    // تحديد تاريخ الأرشفة
    $archived_at = date('Y-m-d H:i:s');

    // إدخال نسخة إلى جدول archived_tasks
    $insert = $conn->prepare("
      INSERT INTO archived_tasks (
        original_task_id, title, description, status, priority, secret_level,
        department_id, assigned_to, created_at, due_date, archived_at, archive_type
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $insert->execute([
        $task_id,
        $task['title'],
        $task['description'],
        $task['status'],
        $task['priority'],
        $task['secret_level'],
        $task['department_id'],
        $task['assigned_to'],
        $task['created_at'],
        $task['due_date'],
        $archived_at,
        'deleted'
    ]);

    // تحديث المهمة الأصلية عشان نخفيها من القوائم والكانبان
    $update = $conn->prepare("
      UPDATE tasks SET archived_at = ? WHERE id = ?
    ");
    $update->execute([$archived_at, $task_id]);

    // إضافة سجل إلى task_logs إذا تبغى
    $conn->prepare(
      "INSERT INTO task_logs (task_id, user_id, action_type, action_details)
       VALUES (?, ?, 'archive', 'تمت أرشفة المهمة بدلاً من الحذف')"
    )->execute([$task_id, $_SESSION['user']['id']]);

    $conn->commit();

    header('Location: list.php?archived=1');
    exit;
} catch (Exception $e) {
    $conn->rollBack();
    error_log('Error archiving task: '.$e->getMessage());
    header('Location: list.php?error=1');
    exit;
}
