<?php // components/edit_task_button.php ?>

<!-- زر فتح مودال التعديل -->
<a href="#" onclick="openEditTaskModal(<?= $task['id'] ?>)" class="text-blue-600 hover:underline">✏️ تعديل</a>

<!-- مودال تعديل المهمة -->
<div id="editTaskModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
  <div class="bg-white w-full max-w-3xl h-[80vh] rounded-lg overflow-hidden shadow-lg relative">
    <button onclick="closeEditTaskModal()" class="absolute top-2 left-2 bg-red-500 text-white px-3 py-1 rounded text-sm hover:bg-red-600 z-10">إغلاق ✖</button>
    <iframe id="editTaskIframe" src="" class="w-full h-full border-none"></iframe>
  </div>
</div>

<script>
function openEditTaskModal(taskId) {
  document.getElementById("editTaskIframe").src = "tasks/modal_edit.php?task_id=" + taskId;
  document.getElementById("editTaskModal").classList.remove("hidden");
}

function closeEditTaskModal() {
  document.getElementById("editTaskIframe").src = "";
  document.getElementById("editTaskModal").classList.add("hidden");
}
</script>
