<?php
/* /erp_task_system/transactions/instructions.php */
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';

/* نحاول نوحّد ملف التفويض سواء authorize.php أو auth.php */
$auth1 = __DIR__ . '/../authorize.php';
$auth2 = __DIR__ . '/../auth.php';
if (file_exists($auth1)) require_once $auth1;
elseif (file_exists($auth2)) require_once $auth2;

/* ✅ تحقق الجلسة والصلاحيات الأساسية */
if (
  !isset($_SESSION['user']) ||
  !isset($_SESSION['user']['name']) ||
  !isset($_SESSION['user']['email']) ||
  !isset($_SESSION['user']['role']) ||
  !in_array($_SESSION['user']['role'], ['admin','manager','user'])
){
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php'); exit;
}

$user  = $_SESSION['user'];
$role  = $user['role'];
$department_id = $user['department_id'] ?? null;

/* ✅ ثيم المستخدم */
$color = $user['color'] ?? [
  'hex_code'          => '#0b1023',
  'second_text_color' => '#e9eefb',
  'text_color'        => '#e9eefb',
  'nav_color'         => '#121b35',
  'chart_color'       => 'rgba(111,125,251,.8)',
];
$userThemeColor           = $color['hex_code'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeTextColor       = $color['text_color'];
$userThemeNavColor        = $color['nav_color'];
$chartColor               = $color['chart_color'];
$currentUserColorId       = $user['color_id'] ?? null;

/* ✅ اسم الإدارة */
$deptNameStmt = $conn->prepare("SELECT name FROM departments WHERE id = ?");
$deptNameStmt->execute([$department_id]);
$myDeptName = $deptNameStmt->fetchColumn() ?: ($user['department_name'] ?? '');

/* ✅ صلاحيات هذه الصفحة: للأدمن + أي مدير */
$isAdmin   = ($role === 'admin');
$isManager = ($role === 'manager');
if (!($isAdmin || $isManager)) {
  $_SESSION['error'] = 'غير مصرح بالدخول لهذه الصفحة. هذه التعليمات مخصصة للأدمن والمديرين.';
  header('Location: ../unauthorized.php'); exit;
}

/* معلومات مفيدة للشرح */
$canTransfer = (int)($user['can_transfer_tasks'] ?? 0);
$levelsMap   = ['normal'=>1,'secret'=>2,'top_secret'=>3];

/* نحاول نكتشف رابط الكانبان الحقيقي (kanban.php أو kanban_new.php أو index.php) */
$base = __DIR__;
$candidates = ['kanban.php','kanban_new.php','index.php'];
$kanbanHref = 'kanban.php';
foreach ($candidates as $f) {
  if (file_exists($base . '/' . $f)) { $kanbanHref = $f; break; }
}

/* رابط إضافة مهمة */
$addHref = file_exists($base . '/add.php') ? 'add.php' : $kanbanHref;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>📘 تعليمات معاملات الكانبان</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
:root{
  --bg: <?= $userThemeColor ?>;
  --panel: <?= $userThemeNavColor ?>;
  --ink: <?= $userThemeTextColor ?>;
  --ink-2: <?= $userThemeSecondTextColor ?>;
  --ring:#c7d2fe; --ok:#16a34a; --warn:#f59e0b; --err:#ef4444;
  /* لقسم التواصل */
  --primary:#6f7dfb; 
  --muted:#9aa3b2;
}
body{ background:var(--bg); color:var(--ink); }
.card{ background:var(--panel); border:1px solid rgba(255,255,255,.07); border-radius:1rem; }
.section{ padding:1rem; }
.h1{ font-size:1.5rem; font-weight:800; }
.h2{ font-size:1.125rem; font-weight:800; }
.lead{ color:var(--ink-2); opacity:.95 }
.toc a{ display:block; padding:.5rem .75rem; border-radius:.6rem; background:rgba(255,255,255,.05); }
.toc a:hover{ background:rgba(255,255,255,.1); }
.callout{ border-radius:.75rem; padding:.75rem .9rem; background:rgba(255,255,255,.06); border:1px dashed rgba(255,255,255,.2); }
.callout.ok{ border-color:rgba(22,163,74,.45) }
.callout.warn{ border-color:rgba(245,158,11,.45) }
.callout.err{ border-color:rgba(239,68,68,.45) }
.badge{ display:inline-flex; align-items:center; gap:.35rem; font-size:.8rem; padding:.25rem .55rem; border-radius:999px; background:rgba(255,255,255,.09) }
.kbd{ font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; background:rgba(255,255,255,.08); padding:.1rem .45rem; border-radius:.4rem; font-size:.85em; }
.anchor{ scroll-margin-top:7rem }
.link{ color:#93c5fd; }

/* ========= طباعة محسّنة A4 ========= */
@page { size: A4 portrait; margin: 10mm 10mm 14mm 10mm; }
.print-only{ display:none; }

@media print{
  :root{ --panel:#fff; --ink:#111827; --ink-2:#374151; }
  html, body{ background:#fff !important; color:#111827 !important;
    -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  body{ font-size:11pt; line-height:1.55; counter-reset: page; }

  /* إخفاءات */
  .no-print, nav, .navbar, .btn, [onclick], a[href^="javascript:"]{ display:none !important; }
  #charts, #links{ display:none !important; }
  body{ font-size:10pt; line-height:1.45; }

  /* نخفي قسم التواصل عند الطباعة */
  #contact{ display:none !important; }

  /* رجّع الفهرس للطباعة */
  nav.toc{ display:block !important; }

  /* شِل مسافة الهيدر الخاصة بالويب */
  .h-20{ display:none !important; }

  /* ترويسة/تذييل ثابتين */
  .print-header, .print-footer{
    display:block !important; position:fixed; left:0; right:0; background:#fff; color:#6b7280;
  }
  .print-header{ top:0; padding:6px 10mm; border-bottom:1px solid #e5e7eb; }
  .print-footer{ bottom:0; padding:6px 10mm; border-top:1px solid #e5e7eb; }
  .print-footer .page:after{ content: counter(page); }
  .print-footer .pages:after{ content: counter(pages); }

  /* نرفع المحتوى */
  .container-print{ margin-top:22mm !important; margin-bottom:18mm !important; }

  .max-w-5xl{ max-width:100% !important; }
  .card{ background:#fff !important; border:1px solid #e5e7eb !important; box-shadow:none !important; }
  .section{ padding:.6rem .8rem !important; }
  header.card.section{ padding:.8rem 1rem !important; }
  .h1{ font-size:16pt !important; margin:0 0 .25rem !important; }
  .h2{ font-size:13pt !important; margin:0 0 .2rem !important; }
  .lead{ font-size:11pt !important; color:#374151 !important; }
  .badge{ background:transparent !important; padding:0 !important; }

  .toc{ columns:3; column-gap:8mm; }
  .toc a{ background:transparent !important; padding:.15rem 0 !important; break-inside:avoid; }

  .callout, .card, .anchor{ break-inside:avoid; page-break-inside:avoid; }
  .page-break{ break-before:page; page-break-before:always; }
}
  </style>
</head>
<body>
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class="h-20"></div>

<div class="max-w-5xl mx-auto px-4 space-y-6 container-print">

  <!-- ترويسة للطباعة فقط -->
  <div class="print-only print-header">
    <div style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;align-items:center;gap:10px;">
        <img src="/erp_task_system/assets/img/fav.png" alt="ASRA" style="height:24px;width:auto;">
        <strong>تعليمات معاملات الكانبان</strong>
      </div>
      <div style="font-size:10pt"><?= date('Y-m-d H:i') ?></div>
    </div>
  </div>

  <!-- تذييل للطباعة فقط -->
  <div class="print-only print-footer">
    <div style="display:flex;align-items:center;justify-content:space-between;">
      <span>أسرع لتقنية المعلومات — 98RL</span>
      <span>صفحة <span class="page"></span> / <span class="pages"></span></span>
    </div>
  </div>

  <!-- رأس الصفحة -->
  <header class="card section">
    <div class="flex items-start justify-between gap-3">
      <div>
        <h1 class="h1">📘 تعليمات استخدام <span class="whitespace-nowrap">معاملات الكانبان</span></h1>
        <p class="lead mt-1">
          الصفحة هذي لإدارة معاملات الإدارات على شكل مراحل (أعمدة). تسمح لك تضيف/تعدّل/تنقل المعاملات،
          وتتعامل مع المراحل المشتركة والإدارات التابعة، مع مراعاة <strong>درجة السرّية</strong> والأرشفة التلقائية.
        </p>
      </div>
      <div class="no-print flex items-center gap-2">
        <a href="<?= htmlspecialchars($kanbanHref) ?>" class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700">⬅️ رجوع للكانبان</a>
        <button onclick="window.print()" class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700">🖨️ طباعة</button>
      </div>
    </div>
  </header>

  <!-- فهرس -->
  <nav class="card section toc grid sm:grid-cols-2 lg:grid-cols-3 gap-2">
    <a href="#what">ماهي الصفحة؟</a>
    <a href="#stages">الأعمدة والمراحل</a>
    <a href="#shared">المراحل المشتركة</a>
    <a href="#subs">الإدارات التابعة</a>
    <a href="#secrecy">درجات السرّية</a>
    <a href="#drag">السحب والإفلات</a>
    <a href="#search">البحث والتصفية</a>
    <a href="#modals">المودال والتعليقات/المرفقات</a>
    <a href="#archive">الأرشفة التلقائية</a>
    <a href="#faq">مشاكل شائعة</a>
    <a href="#links">روابط سريعة</a>
  </nav>

  <!-- ماهي الصفحة -->
  <section id="what" class="card section anchor">
    <h2 class="h2 mb-2">ماهي الصفحة؟</h2>
    <p>
      تعرض معاملات إدارتك موزّعة على مراحل ملوّنة اللون الرمادي = جديد ، الأزرق = قيد التنفيذ ، الأخضر = منتهي. كل بطاقة = معاملة فيها رقم وعنوان ووصف وصاحب إنشاء وتاريخ.
      المدير العام يقدر يبدّل بين الإدارات من القائمة العلوية، ومدير الإدارة يشوف إدارته فقط ، والموظف يشوف المعاملة الخاصة فيه فقط.
    </p>
    <div class="callout ok mt-3">
      تلميح: الضغط على البطاقة يفتح <strong>مودال التفاصيل</strong> وفيه تعديل وحفظ فوري ونقل للمرحلة.
    </div>
  </section>

  <!-- الأعمدة والمراحل -->
  <section id="stages" class="card section anchor">
    <h2 class="h2 mb-2">الأعمدة والمراحل</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>المراحل: محطات سير العمل داخل كل إدارة، تبيّن للمدير وين واقف الشغل، مين ماسكه، وهل المعاملة مخلّصة ولا باقي عليها إجراء. وبكذا يقدر المدير يعرف مكان التعطّل بسرعة ويقيس التقدّم. </li>
    </ul>
  </section>

  <!-- المراحل المشتركة -->
  <section id="shared" class="card section anchor">
    <h2 class="h2 mb-2">المراحل المشتركة</h2>
    <p>
      لو عندك صلاحية <strong>نقل المهام خارج الإدارة</strong> ،
      بتظهر لك أعمدة <strong>مراحل مشتركة</strong> (من نفس الإدارة أو إدارات ثانية) :
    </p>
    <div class="callout warn mt-3">
      من إدارات ثانية: العمود يبان لكن المهام ما تنعرض عندك (سياسة خصوصية)، ومع ذلك تقدر <strong>تسحب</strong> بطاقتك للعمود المشترك إذا سمحت الصلاحيات.
    </div>
  </section>

  <!-- الإدارات التابعة -->
  <section id="subs" class="card section anchor">
    <h2 class="h2 mb-2">الإدارات التابعة</h2>
    <p>
      تُعرض الإدارات التابعة تحت قسم مستقل. لكل إدارة مراحلها وبطاقاتها (مفلترة فقط بدرجة السرّية).
    </p>
  </section>

  <!-- درجات السرّية -->
  <section id="secrecy" class="card section anchor">
    <h2 class="h2 mb-2">درجات السرّية</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>المستويات: <span class="badge">normal=1</span> <span class="badge">secret=2</span> <span class="badge">top_secret=3</span>.</li>
      <li>نجيب مهام ≤ مستوى سرّيتك: إذا مستواك <span class="kbd">secret</span> تشوف 1 و2 فقط… وهكذا.</li>
    </ul>
  </section>

  <!-- السحب والإفلات -->
  <section id="drag" class="card section anchor">
    <h2 class="h2 mb-2">السحب والإفلات</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>يتم نقل المعاملة من خلال السحب والإفلات للمرحلة المطلوبة </li>
    </ul>
  </section>

  <!-- البحث -->
  <section id="search" class="card section anchor">
    <h2 class="h2 mb-2">البحث والتصفية</h2>
    <p>حقل البحث يفلتر حسب <strong>عنوان</strong> المهمة ووصفها لحظيًا بدون إعادة تحميل.</p>
    <?php if ($isAdmin): ?>
      <div class="callout ok mt-3">الأدمن يقدر يبدّل الإدارة من القائمة العلوية، .</div>
    <?php endif; ?>
  </section>

  <!-- المودالات -->
  <section id="modals" class="card section anchor">
    <h2 class="h2 mb-2">المودال والتعليقات/المرفقات</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>بعد الضغط على المعاملة تظهر التفاصيل ويمكن اضافة التعليقات على المعاملة واضافة المرفقات </li>
    </ul>
  </section>

  <!-- الأرشفة -->
  <section id="archive" class="card section anchor">
    <h2 class="h2 mb-2">الأرشفة التلقائية</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>أي مهمة مكتملة <strong>لهــا 7 أيام</strong> تتأرشف تلقائيًا .</li>
      <li>لو اختفت مهمة فجأة: غالبًا تأرشفِت تلقائيًا — راجع شاشة <em>الأرشيف</em> أو التقارير.</li>
    </ul>
  </section>

  <!-- مشاكل شائعة -->
  <section id="faq" class="card section anchor">
    <h2 class="h2 mb-2">مشاكل شائعة</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>ما أقدر أنقل لعمود مشترك؟ → تأكد من الصلاحية في حسابك.</li>
      <li>ما تظهر مهام المرحلة المشتركة لإدارة ثانية؟ → هذا متعمّد للخصوصية؛ العمود يبان لكن المهام مخفية.</li>
      <li>الألوان/التباين ضعيف؟ → عدّل ثيم المستخدم  من إعدادات النمط.</li>
    </ul>
  </section>

  <!-- تواصل مع الدعم الفني -->
  <section id="contact" class="py-12 md:py-16" data-reveal>
    <div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
      <div class="card rounded-2xl p-6">
        <h2 class="text-xl md:text-2xl font-bold text-[var(--ink)]">خلّنا نتواصل</h2>
        <form id="contactForm" class="mt-4 grid gap-3">
          <input id="c_name"  class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
          <input id="c_email" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
          <input id="c_phone" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
          <textarea id="c_msg" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
          <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
          <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
        </form>
      </div>
      <div>
        <h3 class="text-2xl font-bold">بيانات التواصل</h3>
        <ul class="mt-4 space-y-2 text-[var(--muted)]">
          <li>الموقع: 98RL.LINK</li>
          <li>البريد: 98rl@98rl.link</li>
          <li>واتساب: +966535500241</li>
        </ul>
        <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">تواصل واتساب مباشر</a>
      </div>
    </div>
  </section>

  <!-- روابط سريعة -->
  <section id="links" class="card section anchor">
    <h2 class="h2 mb-2">روابط سريعة</h2>
    <div class="flex flex-wrap gap-2">
      <a class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700" href="<?= htmlspecialchars($kanbanHref) ?>">📌 المعاملات بالمراحل</a>
      <a class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700" href="<?= htmlspecialchars($addHref) ?>">➕ إضافة معاملة</a>
      <a class="px-3 py-2 rounded-lg bg-sky-600 hover:bg-sky-700" href="../report_builder.php">📊 التقارير</a>
      <a class="px-3 py-2 rounded-lg bg-amber-600 hover:bg-amber-700" href="../templates/index.php">📝 القوالب</a>
      <a class="px-3 py-2 rounded-lg bg-pink-600 hover:bg-pink-700" href="../archive.php">🗄️ الأرشيف</a>
    </div>
  </section>

</div><!-- /container-print -->

<script>
/* إرسال النموذج للواتساب مباشرة (بدون API) */
(function(){
  const form = document.getElementById('contactForm');
  const res  = document.getElementById('contactResult');
  const WA_NUMBER = '966535500241'; // عدّل الرقم لو تغيّر
  if(!form) return;
  form.addEventListener('submit', function(e){
    e.preventDefault();
    const name  = document.getElementById('c_name').value.trim();
    const email = document.getElementById('c_email').value.trim();
    const phone = document.getElementById('c_phone').value.trim();
    const msg   = document.getElementById('c_msg').value.trim();
    if(!name || !msg){ res.textContent = 'الاسم والطلب مطلوبين'; return; }
    const page = location.pathname;
    const text = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email || '-'}
الجوال: ${phone || '-'}
الصفحة: ${page}
————————
الطلب:
${msg}`;
    const url = `https://wa.me/${WA_NUMBER}?text=${encodeURIComponent(text)}`;
    window.open(url, '_blank');
    res.textContent = 'بيفتح لك واتساب برسالة جاهزة.. بس أرسلها ونخدمك 👍';
  });
})();
</script>

</body>
</html>
