<?php
/* /erp_task_system/transactions/help_archive.php */
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';

/* نحاول نوحّد ملف التفويض سواء authorize.php أو auth.php */
$auth1 = __DIR__ . '/../authorize.php';
$auth2 = __DIR__ . '/../auth.php';
if (file_exists($auth1)) require_once $auth1;
elseif (file_exists($auth2)) require_once $auth2;

/* ✅ السماح للأدمن والمدير فقط */
if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'] ?? 'user', ['admin','manager'])) {
  session_unset(); session_destroy();
  header('Location: ../unauthorized.php'); exit;
}

$user  = $_SESSION['user'];
$role  = $user['role'] ?? 'user';

/* ✅ ثيم المستخدم */
$color = $user['color'] ?? [
  'hex_code'          => '#0b1023',
  'second_text_color' => '#e9eefb',
  'text_color'        => '#e9eefb',
  'nav_color'         => '#121b35',
  'chart_color'       => 'rgba(111,125,251,.8)',
];
$userThemeColor           = $color['hex_code'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeTextColor       = $color['text_color'];
$userThemeNavColor        = $color['nav_color'];

/* ✅ روابط سريعة */
$base = __DIR__;
$archiveHref = file_exists($base.'/archive.php') ? 'archive.php'
             : (file_exists($base.'/index.php') ? 'index.php' : 'archive.php');
$listHref    = file_exists($base.'/list.php')    ? 'list.php'    : $archiveHref;
$kanbanHref  = file_exists($base.'/kanban.php')  ? 'kanban.php'
             : (file_exists($base.'/kanban_new.php') ? 'kanban_new.php' : 'kanban.php');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>📘 تعليمات الأرشيف</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
:root{
  --bg: <?= $userThemeColor ?>;
  --panel: <?= $userThemeNavColor ?>;
  --ink: <?= $userThemeTextColor ?>;
  --ink-2: <?= $userThemeSecondTextColor ?>;
  --ring:#c7d2fe; --ok:#16a34a; --warn:#f59e0b; --err:#ef4444;
  --primary:#6f7dfb; --muted:#9aa3b2;
}
body{ background:var(--bg); color:var(--ink); }
.card{ background:var(--panel); border:1px solid rgba(255,255,255,.07); border-radius:1rem; }
.section{ padding:1rem; }
.h1{ font-size:1.5rem; font-weight:800; }
.h2{ font-size:1.125rem; font-weight:800; }
.lead{ color:var(--ink-2); opacity:.95 }
.toc a{ display:block; padding:.5rem .75rem; border-radius:.6rem; background:rgba(255,255,255,.05); }
.toc a:hover{ background:rgba(255,255,255,.1); }
.callout{ border-radius:.75rem; padding:.75rem .9rem; background:rgba(255,255,255,.06); border:1px dashed rgba(255,255,255,.2); }
.callout.ok{ border-color:rgba(22,163,74,.45) }
.callout.warn{ border-color:rgba(245,158,11,.45) }
.callout.err{ border-color:rgba(239,68,68,.45) }
.badge{ display:inline-flex; align-items:center; gap:.35rem; font-size:.8rem; padding:.25rem .55rem; border-radius:999px; background:rgba(255,255,255,.09) }
.kbd{ font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; background:rgba(255,255,255,.08); padding:.1rem .45rem; border-radius:.4rem; font-size:.85em; }
.anchor{ scroll-margin-top:7rem }
.link{ color:#93c5fd; }

/* ========= طباعة محسّنة A4 ========= */
@page { size: A4 portrait; margin: 10mm 10mm 14mm 10mm; }
.print-only{ display:none; }

@media print{
  :root{ --panel:#fff; --ink:#111827; --ink-2:#374151; }
  html, body{ background:#fff !important; color:#111827 !important;
    -webkit-print-color-adjust: exact; print-color-adjust: exact; }
  body{ font-size:11pt; line-height:1.55; counter-reset: page; }

  /* إخفاءات */
  .no-print, nav, .navbar, .btn, [onclick], a[href^="javascript:"]{ display:none !important; }
  #contact{ display:none !important; }

  .print-header, .print-footer{
    display:block !important; position:fixed; left:0; right:0; background:#fff; color:#6b7280;
  }
  .print-header{ top:0; padding:6px 10mm; border-bottom:1px solid #e5e7eb; }
  .print-footer{ bottom:0; padding:6px 10mm; border-top:1px solid #e5e7eb; }
  .print-footer .page:after{ content: counter(page); }
  .print-footer .pages:after{ content: counter(pages); }

  .container-print{ margin-top:22mm !important; margin-bottom:18mm !important; }
  .max-w-5xl{ max-width:100% !important; }
  .card{ background:#fff !important; border:1px solid #e5e7eb !important; box-shadow:none !important; }
  .section{ padding:.6rem .8rem !important; }
  header.card.section{ padding:.8rem 1rem !important; }
  .h1{ font-size:16pt !important; margin:0 0 .25rem !important; }
  .h2{ font-size:13pt !important; margin:0 0 .2rem !important; }
  .lead{ font-size:11pt !important; color:#374151 !important; }
  .badge{ background:transparent !important; padding:0 !important; }

  /* فهرس أعمدة */
  nav.toc{ display:block !important; columns:3; column-gap:8mm; }
  .toc a{ background:transparent !important; padding:.15rem 0 !important; break-inside:avoid; }

  .callout, .card, .anchor{ break-inside:avoid; page-break-inside:avoid; }
  .page-break{ break-before:page; page-break-before:always; }
}
  </style>
</head>
<body>
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class="h-20"></div>

<div class="max-w-5xl mx-auto px-4 space-y-6 container-print">

  <!-- ترويسة للطباعة فقط -->
  <div class="print-only print-header">
    <div style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;align-items:center;gap:10px;">
        <img src="/erp_task_system/assets/img/fav.png" alt="ASRA" style="height:24px;width:auto;">
        <strong>تعليمات الأرشيف</strong>
      </div>
      <div style="font-size:10pt"><?= date('Y-m-d H:i') ?></div>
    </div>
  </div>

  <!-- تذييل للطباعة فقط -->
  <div class="print-only print-footer">
    <div style="display:flex;align-items:center;justify-content:space-between;">
      <span>أسرع لتقنية المعلومات — 98RL</span>
      <span>صفحة <span class="page"></span> / <span class="pages"></span></span>
    </div>
  </div>

  <!-- رأس الصفحة -->
  <header class="card section">
    <div class="flex items-start justify-between gap-3">
      <div>
        <h1 class="h1">📘 تعليمات استخدام الأرشيف</h1>
        <p class="lead mt-1">
          هالصفحة توضّح آلية عرض <strong>المعاملات المؤرشفة</strong> و<strong>المعاملات المحذوفة</strong>، وكيف تستعيد معاملة وتودّيها لإدارة/مرحلة معيّنة، مع ملاحظات الأرشفة التلقائية بعد 7 أيام.
        </p>
      </div>
      <div class="no-print flex items-center gap-2">
        <a href="<?= htmlspecialchars($archiveHref) ?>" class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700">⬅️ رجوع للأرشيف</a>
        <button onclick="window.print()" class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700">🖨️ طباعة</button>
      </div>
    </div>
  </header>

  <!-- فهرس -->
  <nav class="card section toc grid sm:grid-cols-2 lg:grid-cols-3 gap-2">
    <a href="#types">أنواع السجلات</a>
    <a href="#filters">الفلاتر</a>
    <a href="#table">أعمدة الجدول</a>
    <a href="#restore">الاستعادة (استرجاع معاملة)</a>
    <a href="#advanced">تعديل متقدّم</a>
    <a href="#auto">الأرشفة التلقائية 7 أيام</a>
    <a href="#cache">الكاش وتحديث الصفحة</a>
    <a href="#roles">صلاحيات العرض</a>
    <a href="#faq">مشاكل شائعة</a>
    <a href="#links">روابط سريعة</a>
  </nav>

  <!-- الأنواع -->
  <section id="types" class="card section anchor">
    <h2 class="h2 mb-2">أنواع السجلات</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>المعاملات المؤرشفة</strong>: أي معاملة مر عليها ، مدة 7 أيام منتهية .</li>
      <li><strong>المعاملات المحذوفة</strong>: أي معاملة تم حذفها.</li>
    </ul>
  </section>

  <!-- الفلاتر -->
  <section id="filters" class="card section anchor">
    <h2 class="h2 mb-2">الفلاتر</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>فلتر <strong>النوع</strong>: تختار <strong>مؤرشفة</strong> أو <strong>محذوفة</strong> من القائمة.</li>
      <li>فلتر <strong>الإدارة</strong>: تقدر تقيّد النتائج على إدارة معيّنة.</li>
      <li><strong>مدير الإدارة</strong>: يعرض أرشيف إدارتك تلقائيًا.</li>
      <li><strong>المدير العام</strong>: يشوف كل الإدارات.</li>
    </ul>
  </section>

  <!-- الجدول -->
  <section id="table" class="card section anchor">
    <h2 class="h2 mb-2">أعمدة الجدول</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>العنوان/الوصف</strong>، <strong>الإدارة</strong>، <strong>المسؤول</strong>.</li>
      <li>تاريخ العملية: <strong>تاريخ الأرشفة</strong> أو <strong>تاريخ الحذف</strong> حسب النوع المختار.</li>
      <li>عمود <strong>خيارات</strong> يحتوي زر <strong>إستعادة</strong> للنوع المؤرشف.</li>
    </ul>
  </section>

  <!-- الاستعادة -->
  <section id="restore" class="card section anchor">
    <h2 class="h2 mb-2">الاستعادة (استرجاع معاملة)</h2>
    <p class="mb-2">عند اختيار استعادة، بتشوف نموذج مصغّر يطلب:</p>
    <ol class="list-decimal pr-6 space-y-1">
      <li><strong>الإدارة الجديدة</strong>.</li>
      <li><strong>المرحلة الجديدة</strong>.</li>
      <li>(اختياري) <strong>فتح التعديل بعد الاستعادة</strong> علشان يفتح لك المودال مباشرة.</li>
    </ol>
  </section>


  <!-- الأرشفة التلقائية -->
  <section id="auto" class="card section anchor">
    <h2 class="h2 mb-2">الأرشفة التلقائية (7 أيام)</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>أي معاملة مكتملة ومضى عليها <strong>7 أيام</strong> تتأرشف تلقائيًا.</li>
    </ul>
    <div class="callout warn mt-2">
      إذا اختفت معاملة من الكانبان فجأة، غالبًا دخلت الأرشيف تلقائي — شيّك هالصفحة.
    </div>
  </section>

  <!-- الكاش -->
  <section id="cache" class="card section anchor">
    <h2 class="h2 mb-2">الكاش وتحديث الصفحة</h2>
    <p>صفحة الأرشيف مضافة لها هيدرز منع كاش (no-store/no-cache) عشان تشوف أحدث حالة مباشرة بعد الأرشفة أو الاستعادة.</p>
  </section>

  <!-- الصلاحيات -->
  <section id="roles" class="card section anchor">
    <h2 class="h2 mb-2">صلاحيات العرض</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>المدير العام</strong>: يشوف كل شيء ويصفّي بأي إدارة.</li>
      <li><strong>مدير الإدارة</strong>:  يعرض أرشيف إدارته.</li>
    </ul>
  </section>


  <!-- تواصل -->
  <section id="contact" class="py-12 md:py-16" data-reveal>
    <div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
      <div class="card rounded-2xl p-6">
        <h2 class="text-xl md:text-2xl font-bold text-[var(--ink)]">خلّنا نتواصل</h2>
        <form id="contactForm" class="mt-4 grid gap-3">
          <input id="c_name"  class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
          <input id="c_email" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
          <input id="c_phone" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
          <textarea id="c_msg" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
          <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
          <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
        </form>
      </div>
      <div>
        <h3 class="text-2xl font-bold">بيانات التواصل</h3>
        <ul class="mt-4 space-y-2 text-[var(--muted)]">
          <li>الموقع: 98RL.LINK</li>
          <li>البريد: 98rl@98rl.link</li>
          <li>واتساب: +966535500241</li>
        </ul>
        <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-[var(--ink)] font-semibold px-5 py-3 rounded-2xl shadow-soft">تواصل واتساب مباشر</a>
      </div>
    </div>
  </section>

  <!-- روابط سريعة -->
  <section id="links" class="card section anchor">
    <h2 class="h2 mb-2">روابط سريعة</h2>
    <div class="flex flex-wrap gap-2">
      <a class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700" href="<?= htmlspecialchars($archiveHref) ?>">🗃️ الأرشيف</a>
      <a class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700" href="<?= htmlspecialchars($listHref) ?>">📋 قائمة المعاملات</a>
      <a class="px-3 py-2 rounded-lg bg-sky-600 hover:bg-sky-700" href="<?= htmlspecialchars($kanbanHref) ?>">📌 الكانبان</a>
      <a class="px-3 py-2 rounded-lg bg-amber-600 hover:bg-amber-700" href="../report_builder.php">📊 التقارير</a>
    </div>
  </section>

</div><!-- /container-print -->

<script>
/* إرسال النموذج للواتساب مباشرة (بدون API) */
(function(){
  const form = document.getElementById('contactForm');
  const res  = document.getElementById('contactResult');
  const WA_NUMBER = '966535500241'; // عدّل الرقم لو تغيّر
  if(!form) return;
  form.addEventListener('submit', function(e){
    e.preventDefault();
    const name  = document.getElementById('c_name').value.trim();
    const email = document.getElementById('c_email').value.trim();
    const phone = document.getElementById('c_phone').value.trim();
    const msg   = document.getElementById('c_msg').value.trim();
    if(!name || !msg){ res.textContent = 'الاسم والطلب مطلوبين'; return; }
    const page = location.pathname;
    const text = `طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email || '-'}
الجوال: ${phone || '-'}
الصفحة: ${page}
————————
الطلب:
${msg}`;
    const url = `https://wa.me/${WA_NUMBER}?text=${encodeURIComponent(text)}`;
    window.open(url, '_blank');
    res.textContent = 'بيفتح لك واتساب برسالة جاهزة.. بس أرسلها ونخدمك 👍';
  });
})();
</script>

</body>
</html>