<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php';


$user = $_SESSION['user'];
$role = $user['role'];
$user_id = $user['id'];
$user_secret_level = $user['secret_level'];
$can_transfer = $user['can_transfer_tasks'] ?? 0;

$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$currentUserColorId = $user['color_id'];
$helpHref = file_exists(__DIR__.'/help.php') ? 'help.php' : 'instructions.php';

$levels = ['normal' => 1, 'secret' => 2, 'top_secret' => 3];
$max_level = $levels[$user_secret_level];

if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
  $selected_department_id = $_GET['department_id'] ?? $departments[0]['id'] ?? null;
} else {
  $selected_department_id = $user['department_id'];
}
$fixManualArchive = $conn->prepare("
    UPDATE tasks
    SET archived_at = COALESCE(completed_at, NOW())   -- استخدم completed_at إن وجد، وإلا التاريخ الحالي
    WHERE archived_at IS NULL AND archive_type = 'archived'
");
$fixManualArchive->execute();

// ✅ 2) ثانياً: أرشفة المهام المكتملة التي مضى عليها 7 أيام ولم تُؤرشف بعد
$autoArchiveStmt = $conn->prepare("
    UPDATE tasks
    SET archived_at = NOW(), archive_type = 'archived'
    WHERE archived_at IS NULL
      AND archive_type IS NULL
      AND completed_at IS NOT NULL
      AND TIMESTAMPDIFF(DAY, completed_at, NOW()) >= 7
");
$autoArchiveStmt->execute();


$stmt = $conn->prepare("SELECT id, name, color FROM stages WHERE department_id = ? AND is_shared = 0");
$stmt->execute([$selected_department_id]);
$stages = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (in_array($role, ['employee', 'user'])) {
  $tasks_stmt = $conn->prepare("SELECT tasks.*, users.name AS creator_name FROM tasks 
LEFT JOIN users ON tasks.created_by = users.id 
WHERE tasks.department_id = ? AND tasks.assigned_to = ? AND tasks.is_deleted = 0 AND archived_at IS NULL
AND 
(CASE tasks.secret_level 
      WHEN 'normal' THEN 1 
      WHEN 'secret' THEN 2 
      WHEN 'top_secret' THEN 3 
    END) <= ?");
  $tasks_stmt->execute([$selected_department_id, $user_id, $max_level]);
} else {
  $tasks_stmt = $conn->prepare("SELECT tasks.*, users.name AS creator_name FROM tasks 
LEFT JOIN users ON tasks.created_by = users.id 
WHERE tasks.department_id = ? AND tasks.is_deleted = 0 AND tasks.archived_at IS NULL
 AND 
(CASE tasks.secret_level 
      WHEN 'normal' THEN 1 
      WHEN 'secret' THEN 2 
      WHEN 'top_secret' THEN 3 
    END) <= ?");
  $tasks_stmt->execute([$selected_department_id, $max_level]);
}
$tasks = $tasks_stmt->fetchAll(PDO::FETCH_ASSOC);

$tasks_by_stage = [];
foreach ($stages as $stage) {
  $tasks_by_stage[$stage['id']] = array_filter($tasks, fn($task) => $task['stage_id'] == $stage['id']);
}
$shared_stages = [];


if ($can_transfer) {
  // جلب المراحل المشتركة التي يسمح للمستخدم بمشاهدتها
  $stmt = $conn->prepare("
  SELECT * FROM stages 
  WHERE is_shared = 1 AND (
    share_with_all = 1 
    OR shared_department_id = ?
  )
");
  $stmt->execute([$selected_department_id]);
  $shared_stages = $stmt->fetchAll(PDO::FETCH_ASSOC);


  // الإدارات التابعة لإدارتي
  $sub_departments_stmt = $conn->prepare("SELECT id, name FROM departments WHERE parent_id = ?");
  $sub_departments_stmt->execute([$selected_department_id]);
  $sub_departments = $sub_departments_stmt->fetchAll(PDO::FETCH_ASSOC);

  $sub_department_stages = [];
  $sub_department_tasks_by_stage = [];

  foreach ($sub_departments as $sub_dep) {
    // مراحل الإدارة الفرعية
    $sub_stage_stmt = $conn->prepare("SELECT * FROM stages WHERE department_id = ?");
    $sub_stage_stmt->execute([$sub_dep['id']]);
    $stages_sub = $sub_stage_stmt->fetchAll(PDO::FETCH_ASSOC);
    $sub_department_stages[$sub_dep['id']] = $stages_sub;

    // مهامهم بناءً على مستوى السرية فقط (ما نفلترهم زيادة)
    if (!empty($stages_sub)) {
      $stage_ids = array_column($stages_sub, 'id');
      $placeholders = implode(',', array_fill(0, count($stage_ids), '?'));
      $params = [...$stage_ids, $max_level];

      $task_stmt = $conn->prepare("
  SELECT tasks.*, users.name AS creator_name FROM tasks 
  LEFT JOIN users ON tasks.created_by = users.id 
 WHERE tasks.stage_id IN ($placeholders)
AND tasks.is_deleted = 0 
AND tasks.archived_at IS NULL
AND (CASE tasks.secret_level 


        WHEN 'normal' THEN 1 
        WHEN 'secret' THEN 2 
        WHEN 'top_secret' THEN 3 
      END) <= ?
    ");
      $task_stmt->execute($params);
      $sub_tasks = $task_stmt->fetchAll(PDO::FETCH_ASSOC);

      foreach ($stages_sub as $stage) {
        $sub_department_tasks_by_stage[$stage['id']] = array_filter($sub_tasks, fn($t) => $t['stage_id'] == $stage['id']);
      }
    }
  }


  // جلب المهام لجميع المراحل المشتركة التي تم السماح بها
  $stage_ids = array_column($shared_stages, 'id');
  if (!empty($stage_ids)) {
    $placeholders = implode(',', array_fill(0, count($stage_ids), '?'));
    $params = [...$stage_ids, $max_level];

    $task_stmt = $conn->prepare("
  SELECT tasks.*, users.name AS creator_name FROM tasks 
  LEFT JOIN users ON tasks.created_by = users.id 
  WHERE tasks.stage_id IN ($placeholders)
AND tasks.archived_at IS NULL
AND tasks.is_deleted = 0 
AND (CASE tasks.secret_level 


      WHEN 'normal' THEN 1 
      WHEN 'secret' THEN 2 
      WHEN 'top_secret' THEN 3 
    END) <= ?
  ");
    $task_stmt->execute($params);
    $shared_tasks = $task_stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($shared_stages as $stage) {
      if ($stage['department_id'] != $selected_department_id) {
        // المرحلة مشتركة من إدارة غير، نظهر العمود فقط بدون المهام
        $tasks_by_stage[$stage['id']] = [];
      } else {
        // المرحلة مشتركة من نفس الإدارة، نظهر المهام بشكل عادي
        $tasks_by_stage[$stage['id']] = array_filter($shared_tasks, fn($task) => $task['stage_id'] == $stage['id']);
      }
    }
  }
}



?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>المعاملات بالمراحل</title>
  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    body,
    .main-card,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,
    h3,
    option,
    h2,
    h1,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

    .kanban-scroll {
      display: flex;
      overflow-x: auto;
      gap: 1rem;
      scroll-snap-type: x mandatory;
      width: 100%;
    }

    .kanban-scroll>.kanban-column {
      flex: 0 0 280px;
      /* بدل 240 عشان يكون أوسع */
    }

    .task-card {
      user-select: none;
    }

    .text-button {
      color: #ffffff !important;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .move-button:hover,
    .view-tasks:hover {
      background-color: rgb(19, 11, 57) !important;
    }
  </style>
</head>

<body>

  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
  <div class=" p-10">
 
    <div class="flex justify-between items-center mb-6">
      <h1 class="text-2xl font-bold">📌 المعاملات بالمراحل</h1>

      <div class="flex items-center gap-4">
        <?php if ($role === 'admin'): ?>
          <form method="GET">
            <select name="department_id" onchange="this.form.submit()" class="card border rounded px-3 py-2">
              <?php foreach ($departments as $dep): ?>
                <option value="<?= $dep['id'] ?>" <?= $dep['id'] == $selected_department_id ? 'selected' : '' ?>>
                  <?= $dep['name'] ?>
                </option>
              <?php endforeach; ?>
            </select>
          </form>
        <?php endif; ?>

        <input type="text" id="taskSearch" placeholder="🔍 ابحث بعنوان المهمة..."
          class="border rounded px-3 py-2 w-64" oninput="filterTasksByTitle()">

        <!-- ✅ زر إضافة مهمة جديدة -->
        <button onclick="document.getElementById('addTaskModal').classList.remove('hidden')"
          class=" move-button text-button   text-white px-4 py-2 rounded ">
          ➕ إضافة
        </button>
          <!-- زر تعليمات (يسار زر إضافة) -->
  <a href="<?= htmlspecialchars($helpHref) ?>" target="_blank" rel="noopener"
     class="move-button text-button text-white px-4 py-2 rounded no-print inline-flex items-center gap-1"
     title="تعليمات المعاملات">
    ❓ تعليمات
  </a>

      </div>
    </div>

    <div class=" kanban-scroll">
      <?php foreach ($stages as $stage): ?>
        <div class="card kanban-column bg-white rounded shadow border" data-stage-id="<?= $stage['id'] ?>" ondrop="handleDrop(event)" ondragover="event.preventDefault()">
          <div style="background-color: <?= $stage['color'] ?>" class="h-2 rounded-t"></div>
<div class="p-4 min-h-[300px] max-h-[300px] overflow-y-auto">
            <h2 class="font-bold text-center mb-2"><?= htmlspecialchars($stage['name']) ?></h2>
            <?php foreach ($tasks_by_stage[$stage['id']] ?? [] as $task): ?>
              <div class="main-card task-card bg-gray-100 rounded p-2 mb-2 shadow-sm cursor-pointer hover:bg-gray-200" draggable="true" data-id="<?= $task['id'] ?>" ondragstart="handleDrag(event)">
                <div class="main-card text text-xs text-gray-500 mb-1">
                  🧑‍💼 <?= htmlspecialchars($task['creator_name'] ?? 'مجهول') ?> •
                  🕒 <?= date('Y-m-d H:i', strtotime($task['created_at'])) ?>
                </div>
                <div class="text font-semibold text-gray-800"><?= htmlspecialchars($task['title']) ?></div>
                <div class="text text-sm text-gray-600"><?= htmlspecialchars($task['description']) ?></div>

              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <?php if ($can_transfer && !empty($shared_stages)): ?>
      <h2 class="text-lg font-bold mt-10 mb-2">📤 المراحل المشتركة (للإدارات الأخرى):</h2>
      <div class=" kanban-scroll">
        <?php foreach ($shared_stages as $stage): ?>
          <div class="card kanban-column bg-white rounded shadow border" data-stage-id="<?= $stage['id'] ?>" ondrop="handleDrop(event)" ondragover="event.preventDefault()">
            <div style="background-color: <?= $stage['color'] ?>" class="h-2 rounded-t"></div>
<div class="p-4 min-h-[300px] max-h-[300px] overflow-y-auto">
              <h2 class=" font-bold text-center mb-2"><?= htmlspecialchars($stage['name']) ?></h2>
              <?php foreach ($tasks_by_stage[$stage['id']] ?? [] as $task): ?>
                <div class="main-card task-card bg-gray-100 rounded p-2 mb-2 shadow-sm cursor-pointer hover:bg-gray-200" draggable="true" data-id="<?= $task['id'] ?>" ondragstart="handleDrag(event)">
                  <div class="text text-xs text-gray-500 mb-1">
                    🧑‍💼 <?= htmlspecialchars($task['creator_name'] ?? 'مجهول') ?> •
                    🕒 <?= date('Y-m-d H:i', strtotime($task['created_at'])) ?>
                  </div>
                  <div class="text font-semibold"><?= htmlspecialchars($task['title']) ?></div>
                  <div class="text text-sm text-gray-600"><?= htmlspecialchars($task['description']) ?></div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endforeach; ?>

      <?php endif; ?>
      </div>


      <?php if (!empty($sub_departments)): ?>
        <!-- سكشن منفصل علشان ينزل تحت المراحل المشتركة -->
        <div class="w-full mt-16">
          <h2 class="text-xl font-bold mb-6 border-b pb-2">📂 الإدارات التابعة:</h2>

          <?php foreach ($sub_departments as $sub_dep): ?>
            <h3 class="text text-md font-semibold mb-3 text-gray-800"><?= htmlspecialchars($sub_dep['name']) ?></h3>

            <div class="kanban-scroll mb-12">
              <?php foreach ($sub_department_stages[$sub_dep['id']] as $stage): ?>
                <div class="card kanban-column bg-white rounded shadow border" data-stage-id="<?= $stage['id'] ?>" ondrop="handleDrop(event)" ondragover="event.preventDefault()">
                  <div style="background-color: <?= $stage['color'] ?>" class="h-2 rounded-t"></div>
                  <div class="p-4 min-h-[300px] max-h-[300px] overflow-y-auto">
                    <h2 class="font-bold text-center mb-2"><?= htmlspecialchars($stage['name']) ?></h2>
                    <?php foreach ($sub_department_tasks_by_stage[$stage['id']] ?? [] as $task): ?>
                      <div class="main-card task-card bg-gray-100 rounded p-2 mb-2 shadow-sm cursor-pointer hover:bg-gray-200"
                        draggable="true"
                        data-id="<?= $task['id'] ?>"
                        ondragstart="handleDrag(event)">
                        <div class="text text-xs text-gray-500 mb-1">
                          🧑‍💼 <?= htmlspecialchars($task['creator_name'] ?? 'مجهول') ?> •
                          🕒 <?= date('Y-m-d H:i', strtotime($task['created_at'])) ?>
                        </div>
                        <div class="text font-semibold"><?= htmlspecialchars($task['title']) ?></div>
                        <div class="text text-sm text-gray-600"><?= htmlspecialchars($task['description']) ?></div>
                      </div>
                    <?php endforeach; ?>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>





      <div id="taskModal" class="fixed inset-0 bg-black bg-opacity-40 hidden flex items-center justify-center z-50">
        <div class="bg-white w-full max-w-3xl rounded shadow-lg overflow-hidden">
          <div class="flex justify-between items-center p-4 border-b">
            <h3 class="font-bold">تفاصيل المهمة 🛠</h3>
            <button onclick="document.getElementById('taskModal').classList.add('hidden')" class="text-red-600 text-2xl">&times;</button>
          </div>
          <div id="modalContent" class="p-4">جاري التحميل...</div>
        </div>
      </div>

      <script>
        let draggedTaskId = null;

        function handleDrag(event) {
          draggedTaskId = event.target.dataset.id;
        }

        function handleDrop(event) {
          event.preventDefault();
          const stageId = event.currentTarget.dataset.stageId;
          if (!draggedTaskId || !stageId) return;

          fetch('../api/update_task_stage.php', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
              },
              body: `task_id=${encodeURIComponent(draggedTaskId)}&stage_id=${encodeURIComponent(stageId)}`
            })
            .then(res => res.json())
            .then(data => {
              if (data.success) {
                location.reload();
              } else {
                alert('❌ فشل تحديث مرحلة المهمة');
              }
            })
            .catch(err => {
              console.error("⚠️ خطأ في الاتصال:", err);
              alert('⚠️ حدث خطأ في الاتصال بالخادم');
            });
        }

        document.querySelectorAll('.task-card').forEach(card => {
          card.addEventListener('click', () => {
            const id = card.dataset.id;

            fetch('modal_edit_kanban.php?task_id=' + id)
              .then(res => res.text())
              .then(html => {
                const modalContent = document.getElementById("modalContent");
                modalContent.innerHTML = html;
                document.getElementById("taskModal").classList.remove("hidden");



                window.taskId = id;
                window.isManager = true;

                const script = document.createElement('script');
                script.src = '../assets/js/task_modal_functions.js?t=' + Date.now();
                script.onload = () => {
                  if (typeof loadAttachments === 'function') loadAttachments();
                  if (typeof loadComments === 'function') loadComments();
                  if (typeof submitComment === 'function')
                    document.getElementById('submitCommentBtn')?.addEventListener('click', submitComment);
                  if (typeof uploadAttachment === 'function')
                    document.getElementById('uploadAttachmentBtn')?.addEventListener('click', uploadAttachment);
                  if (typeof bindDeleteButtons === 'function')
                    bindDeleteButtons();

                  const saveBtn = document.getElementById('saveEditBtn');
                  if (saveBtn) {
                    saveBtn.addEventListener('click', function() {
                      const form = document.getElementById('editTaskForm');
                      const formData = new FormData(form);

                      fetch('../api/update_task_api.php', {
                          method: 'POST',
                          body: formData
                        })
                        .then(res => res.json())
                        .then(data => {
                          if (data.success) {
                            showToast('✅ تم حفظ التعديلات بنجاح');

                            const cardSelector = `.task-card[data-id="${taskId}"]`;
                            const oldCard = document.querySelector(cardSelector);
                            const newTitle = formData.get('title');
                            const newDescription = formData.get('description');
                            const newStageId = formData.get('stage_id');

                            if (oldCard) oldCard.remove();

                            const newCard = document.createElement('div');
                            newCard.className = 'task-card bg-gray-100 rounded p-2 mb-2 shadow-sm cursor-pointer hover:bg-gray-200';
                            newCard.dataset.id = taskId;
                            newCard.setAttribute('draggable', 'true');
                            newCard.ondragstart = handleDrag;
                            newCard.innerHTML = `
                    <div class="font-semibold">${newTitle}</div>
                    <div class="text-sm text-gray-600">${newDescription}</div>
                  `;

                            const stageColumn = document.querySelector(`.kanban-column[data-stage-id="${newStageId}"] .p-4`);
                            if (stageColumn) {
                              stageColumn.appendChild(newCard);
                            }

                            newCard.addEventListener('click', () => {
                              fetch('modal_edit_kanban.php?task_id=' + taskId)
                                .then(res => res.text())
                                .then(html => {
                                  document.getElementById("modalContent").innerHTML = html;
                                  document.getElementById("taskModal").classList.remove("hidden");
                                });
                            });

                            document.getElementById('taskModal').classList.add('hidden');
                          } else {
                            showToast('❌ فشل الحفظ: ' + (data.message || ''), 'error');
                          }
                        })
                        .catch(err => {
                          console.error(err);
                          showToast('⚠️ حصل خطأ أثناء الاتصال', 'error');
                        });
                    });
                  }
                };
                const signScript = document.createElement('script');
                signScript.src = '../assets/js/sign_template_btn.js?t=' + Date.now();
                document.body.appendChild(signScript);

                script.onerror = () => {
                  alert("❌ فشل تحميل سكربت الوظائف");
                };
                document.body.appendChild(script);
              })
              .catch(err => {
                alert("❌ خطأ في تحميل تفاصيل المهمة");
                console.error(err);
              });
          });
        });
      </script>



      <script>
        function showToast(message, type = 'success') {
          const toast = document.createElement('div');
          toast.textContent = message;
          toast.className = `fixed bottom-5 right-5 z-[9999] px-4 py-2 rounded shadow-lg transition-opacity duration-300 ${
    type === 'success' ? 'bg-green-600 text-white' : 'bg-red-600 text-white'
  }`;
          document.body.appendChild(toast);

          setTimeout(() => {
            toast.classList.add('opacity-0');
            setTimeout(() => toast.remove(), 300); // إزالة العنصر بعد التلاشي
          }, 3000);
        }

        let scrollInterval = null;

        document.addEventListener("dragover", function(e) {
          const container = document.querySelector('.kanban-scroll');
          const edgeThreshold = 80;
          const scrollSpeed = 10;
          const mouseX = e.clientX;

          clearInterval(scrollInterval);

          if (mouseX < edgeThreshold) {
            scrollInterval = setInterval(() => container.scrollLeft -= scrollSpeed, 10);
          } else if (window.innerWidth - mouseX < edgeThreshold) {
            scrollInterval = setInterval(() => container.scrollLeft += scrollSpeed, 10);
          }
        });

        document.addEventListener("dragleave", () => clearInterval(scrollInterval));
        document.addEventListener("drop", () => clearInterval(scrollInterval));
      </script>
      <!-- ✅ نافذة عرض النموذج -->
      <div id="templateOverlay" class="hidden fixed inset-0 z-[9999] bg-black/50 flex items-center justify-center">
        <div class="bg-white rounded-lg shadow-xl w-[90%] max-w-5xl h-[90vh] overflow-hidden relative">
          <button onclick="closeTemplateOverlay()"
            class="absolute top-3 right-3 text-red-600 text-2xl font-bold z-10">&times;</button>
          <iframe id="templateFrame" class="w-full h-full border-0 rounded-b-lg"></iframe>
        </div>
      </div>

      <script>
        function openTemplateOverlay(taskId, templateId) {
          const frame = document.getElementById("templateFrame");
          frame.src = `../templates/view_template_modal.php?task_id=${taskId}&template_id=${templateId}`;
          document.getElementById("templateOverlay").classList.remove("hidden");
        }

        function closeTemplateOverlay() {
          document.getElementById("templateOverlay").classList.add("hidden");
          document.getElementById("templateFrame").src = "";
        }
      </script>
      <!-- ✅ مودال إضافة مهمة -->
      <div id="addTaskModal" class="fixed inset-0 bg-black bg-opacity-40 hidden flex items-center justify-center z-50">
        <div class="bg-white w-full max-w-2xl rounded shadow-lg overflow-hidden">
          <div class="flex justify-between items-center p-4 border-b">
            <h3 class="font-bold">➕ مهمة جديدة</h3>
            <button onclick="closeAddModal()" class="text-red-600 text-2xl">&times;</button>
          </div>
          <div class="p-4">
            <iframe src="add.php" class="w-full h-[500px] border-0"></iframe>
          </div>
        </div>
      </div>

      <script>
        function closeAddModal() {
          document.getElementById("addTaskModal").classList.add("hidden");
        }

        function filterTasksByTitle() {
          const searchText = document.getElementById('taskSearch').value.toLowerCase();
          const taskCards = document.querySelectorAll('.task-card');

          taskCards.forEach(card => {
            const title = card.querySelector('.font-semibold')?.textContent.toLowerCase() || '';
            const description = card.querySelector('.text-sm')?.textContent.toLowerCase() || '';
            if (title.includes(searchText) || description.includes(searchText)) {
              card.style.display = 'block';
            } else {
              card.style.display = 'none';
            }
          });
        }
      </script>

</body>

</html>