<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title><?= $title ?? 'نظام إدارة المهام' ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-900">
    <nav class="bg-white shadow mb-6">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <div class="flex items-center space-x-4 space-x-reverse">
                <a href="/erp_task_system/views/all_tasks.php" class="font-bold text-xl hover:text-blue-600">🏠 الرئيسية</a>
                <a href="/erp_task_system/views/add_task.php" class="text-gray-700 hover:text-blue-600">➕ إضافة مهمة</a>
                <a href="/erp_task_system/views/my_tasks.php" class="text-gray-700 hover:text-blue-600">📋 مهامي</a>
		<a href="/erp_task_system/views/kanban.php" class="text-gray-700 hover:text-blue-600">📌 عرض كانبان</a>


<?php if (isset($_SESSION['user']) && $_SESSION['user']['role'] === 'admin'): ?>
    <a href="/erp_task_system/views/trash.php" class="text-gray-700 hover:text-blue-600">🗑️ سلة المهملات</a>
<?php endif; ?>
            </div>
            <div class="flex items-center space-x-4 space-x-reverse">
                <?php if (isset($_SESSION['user'])): ?>
                    <span class="text-sm text-gray-600">👤 <?= htmlspecialchars($_SESSION['user']['name']) ?></span>
                    <a href="/erp_task_system/logout.php" class="text-red-500 hover:underline">🚪 تسجيل الخروج</a>
                <?php endif; ?>
            </div>
        </div>
    </nav>
    <div class="container mx-auto px-4">
