<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// أول شي نتأكد فيه جلسة تسجيل دخول

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];
$user_id = $user['id'];
$user_secret_level = $user['secret_level'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$currentUserColorId = $user['color_id'];
$searchTerm = $_GET['search'] ?? null;


$levels = ['normal' => 1, 'secret' => 2, 'top_secret' => 3];
$max_level = $levels[$user_secret_level];

$selected_department_id = $_GET['department_id'] ?? null;

if ($role === 'manager') {
  $selected_department_id = $department_id;
}

// جلب الإدارات بناءً على الدور
if ($role === 'admin') {
  $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
} elseif ($role === 'manager') {
  $stmt = $conn->prepare("SELECT id, name FROM departments WHERE manager_id = ?");
  $stmt->execute([$user_id]);
  $departments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// جلب المهام
if ($role === 'admin') {
  $query = "SELECT tasks.*, 
                   users.name AS assigned_name, 
                   departments.name AS department_name, 
                   stages.name AS stage_name
            FROM tasks
            LEFT JOIN users ON tasks.assigned_to = users.id
            LEFT JOIN departments ON tasks.department_id = departments.id
            LEFT JOIN stages ON tasks.stage_id = stages.id
            WHERE (CASE tasks.secret_level
                     WHEN 'normal' THEN 1
                     WHEN 'secret' THEN 2
                     WHEN 'top_secret' THEN 3
                   END) <= ?
              AND tasks.is_deleted = 0
              AND archived_at IS NULL";
  $params = [$max_level];

$secrecyLabel = [
  'normal'     => 'عادي',
  'secret'     => 'سري',
  'top_secret' => 'سري جداً',
];

  if ($selected_department_id) {
    $query .= " AND tasks.department_id = ?";
    $params[] = $selected_department_id;
  }

  if (!empty($searchTerm)) {
    $query .= " AND tasks.title LIKE ?";
    $params[] = '%' . $searchTerm . '%';
  }

  $query .= " ORDER BY tasks.created_at DESC";
  $stmt = $conn->prepare($query);
  $stmt->execute($params);
  $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($role === 'manager') {
  $query = "SELECT tasks.*, users.name AS assigned_name, departments.name AS department_name
            FROM tasks
            LEFT JOIN users ON tasks.assigned_to = users.id
            LEFT JOIN departments ON tasks.department_id = departments.id
            WHERE tasks.department_id = ?
              AND (CASE tasks.secret_level
                     WHEN 'normal' THEN 1
                     WHEN 'secret' THEN 2
                     WHEN 'top_secret' THEN 3
                   END) <= ?
              AND tasks.is_deleted = 0
              AND archived_at IS NULL";
  $params = [($selected_department_id ?? $department_id), $max_level];

  if (!empty($searchTerm)) {
    $query .= " AND tasks.title LIKE ?";
    $params[] = '%' . $searchTerm . '%';
  }

  $query .= " ORDER BY tasks.created_at DESC";
  $stmt = $conn->prepare($query);
  $stmt->execute($params);
  $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
  $query = "SELECT tasks.*, users.name AS assigned_name, departments.name AS department_name
            FROM tasks
            LEFT JOIN users ON tasks.assigned_to = users.id
            LEFT JOIN departments ON tasks.department_id = departments.id
            WHERE tasks.assigned_to = ?
              AND (CASE tasks.secret_level
                     WHEN 'normal' THEN 1
                     WHEN 'secret' THEN 2
                     WHEN 'top_secret' THEN 3
                   END) <= ?
              AND tasks.is_deleted = 0
              AND archived_at IS NULL";
  $params = [$user_id, $max_level];

  if (!empty($searchTerm)) {
    $query .= " AND tasks.title LIKE ?";
    $params[] = '%' . $searchTerm . '%';
  }

  $query .= " ORDER BY tasks.created_at DESC";
  $stmt = $conn->prepare($query);
  $stmt->execute($params);
  $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>قائمة المعاملات</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,
    h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }

    .text-button {
      color: #ffffff !important;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .border {
      border-radius: 15px !important;
    }

    .move-button:hover,
    .view-tasks:hover {
      background-color: rgb(19, 11, 57) !important;
    }



    .delete-button {
      background-color: #FD7474 !important;
      color: #FFFFFF !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }
  </style>
</head>
<script src="../assets/js/task_modal_functions.js"></script>
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<body class="bg-gray-100 text-right">



  <div class="p-6">

    <div class="card shadow rounded mb-4 p-4">
      <form method="GET" class="flex flex-col md:flex-row md:items-center md:space-x-4 rtl:md:space-x-reverse space-y-2 md:space-y-0">

        <h2 class="text-lg font-bold flex-shrink-0">📋 قائمة المعاملات</h2>

        <input type="text" name="search" placeholder="🔍 بحث بالعنوان..." value="<?= htmlspecialchars($_GET['search'] ?? '') ?>"
          class="main-card border rounded px-3 py-2 w-full max-w-xs" />

        <?php if (!empty($departments)): ?>
          <select name="department_id" class="main-card border rounded px-3 py-2 w-full max-w-xs">
            <option value="">-- <?= $role === 'admin' ? 'كل الإدارات' : 'اختر الإدارة' ?> --</option>
            <?php foreach ($departments as $dept): ?>
              <option value="<?= $dept['id'] ?>" <?= $selected_department_id == $dept['id'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($dept['name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        <?php endif; ?>

        <button type="submit" class=" move-button text-button   text-white px-4 py-2 rounded  flex-shrink-0">🔍 بحث</button>

        <button type="button" onclick="document.getElementById('addTaskModal').classList.remove('hidden')"
          class=" move-button text-button   text-white px-4 py-2 rounded  flex-shrink-0">
          ➕ إضافة
        </button>
<!-- زر تعليمات -->
<a href="help_list.php" target="_blank" rel="noopener"
   class="move-button text-button text-white px-4 py-2 rounded no-print inline-flex items-center gap-1"
   title="تعليمات قائمة المعاملات">
  ❓ تعليمات
</a>

        <?php if (!empty($_GET['search'])): ?>
          <a href="list.php" class="text-sm text-red-500 ml-2">✖️ إلغاء</a>
        <?php endif; ?>
      </form>
    </div>

    <div class="card shadow rounded overflow-x-auto">

      <table class="card min-w-full text-sm border border-gray-200">
        <thead class=" ">
          <tr>
            <th class="px-4 py-2 border">#</th>
            <th class="px-4 py-2 border">العنوان</th>
            <th class="px-4 py-2 border">الوصف</th>
            <th class="px-4 py-2 border">المرحلة</th>
            <th class="px-4 py-2 border">المسؤول</th>
            <th class="px-4 py-2 border">الإدارة</th>
            <th class="px-4 py-2 border">السرية</th>
            <th class="px-4 py-2 border">الاستحقاق</th>
            <th class="px-4 py-2 border">الخيارات</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($tasks as $task): ?>
            <tr class=" cursor-pointer transition" onclick="openTaskModal(<?= $task['id'] ?>)">
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= $task['id'] ?></td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= htmlspecialchars($task['title']) ?></td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= htmlspecialchars($task['description']) ?></td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= htmlspecialchars($task['stage_name']) ?></td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= $task['assigned_name'] ?></td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= $task['department_name'] ?></td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)">
                <?= $secrecyLabel[$task['secret_level']] ?? '' ?>
              </td>
              <td class="px-4 py-2 border cursor-pointer" onclick="openTaskModal(<?= $task['id'] ?>)"><?= $task['due_date'] ?></td>
              <td class="px-4 py-2 border text-center" onclick="event.stopPropagation()">
                <div class="mt-2">
                    <form action="delete_task.php" method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟')" class="inline">
                      <input type="hidden" name="task_id" value="<?= $task['id'] ?>">
                      <button type="submit" class="text-red-600 delete-button ml-2">حذف</button>
                    </form>
                </div>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Modal لإضافة  مهمة -->
  <div id="addTaskModal" class="fixed inset-0 bg-black bg-opacity-40 hidden flex items-center justify-center z-50">
    <div class="main-card w-full max-w-2xl rounded shadow-lg overflow-hidden">
      <div class="flex justify-between items-center p-4 border-b">
        <h3 class="font-bold">➕ معاملة جديدة</h3>
        <button onclick="closeAddModal()" class="text-red-600 text-2xl">&times;</button>
      </div>
      <div class="p-4">
        <iframe src="add.php" class="w-full h-[500px] border-0"></iframe>
      </div>
    </div>
  </div>

  <!-- مودال تعديل المهمة -->
  <div id="taskModal" class="fixed inset-0 bg-black bg-opacity-40 hidden flex items-center justify-center z-50">
    <div class="main-card w-full max-w-3xl rounded shadow-lg overflow-hidden">
      <div class="flex justify-between items-center p-4 border-b">
        <h2 class="text-lg font-bold">🛠 تعديل المعاملة</h2>
        <button onclick="document.getElementById('taskModal').classList.add('hidden')" class="text-red-500 text-xl font-bold">&times;</button>
      </div>
      <div id="modalContent" class="flex-1 overflow-auto p-4">
        جاري التحميل...
      </div>
    </div>
  </div>
  <script>
    function bindDeleteButtons() {
      document.querySelectorAll('[data-delete-comment]').forEach(btn => {
        btn.addEventListener('click', function() {
          const commentId = this.getAttribute('data-delete-comment');
          if (confirm('هل أنت متأكد من حذف هذا التعليق؟')) {
            deleteComment(commentId);
          }
        });
      });

      document.querySelectorAll('[data-delete-attachment]').forEach(btn => {
        btn.addEventListener('click', function() {
          const attachmentId = this.getAttribute('data-delete-attachment');
          if (confirm('هل أنت متأكد من حذف هذا المرفق؟')) {
            deleteAttachment(attachmentId);
          }
        });
      });
    }


    function openTaskModal(taskId) {
      const modal = document.getElementById("taskModal");
      const content = document.getElementById("modalContent");


      fetch('modal_edit_kanban.php?task_id=' + taskId)
        .then(res => res.text())
        .then(html => {
          content.innerHTML = html;
          modal.classList.remove("hidden");

          // ✅ تحميل السكربتات من المودال يدويًا
          const scripts = content.querySelectorAll("script");
          scripts.forEach((script) => {
            const s = document.createElement("script");
            if (script.src) {
              s.src = script.src;
            } else {
              s.textContent = script.textContent;
            }
            document.body.appendChild(s);
          });


          window.taskId = taskId;
          window.isManager = <?= ($role === 'admin' || $role === 'manager') ? 'true' : 'false' ?>;

          setTimeout(() => {
            if (typeof loadAttachments === 'function') loadAttachments();
            if (typeof loadComments === 'function') loadComments();

            document.getElementById('submitCommentBtn')?.addEventListener('click', submitComment);
            document.getElementById('uploadAttachmentBtn')?.addEventListener('click', uploadAttachment);
            bindDeleteButtons();
          }, 100);
        });
    }


    function openTaskModalWithLogs(taskId) {
      openTaskModal(taskId);
سر
      setTimeout(() => {
        const tryShowLogs = () => {
          if (typeof showLogs === 'function') {
            showLogs();
          } else {
            setTimeout(tryShowLogs, 100); // نحاول مرة ثانية بعد 100ms
          }
        };
        tryShowLogs();
      }, 500);
    }



    function closeAddModal() {
      document.getElementById("addTaskModal").classList.add("hidden");
    }

    function openTaskModalWithLogs(taskId) {
      openTaskModal(taskId);
      setTimeout(() => {
        if (typeof showLogs === 'function') showLogs();
      }, 500);
    }
  </script>


</body>

</html>