
<?php
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

// أول شي نتأكد فيه جلسة تسجيل دخول

if (!isset($_SESSION['user']) || !isset($_SESSION['user']['name']) || !isset($_SESSION['user']['email']) || !isset($_SESSION['user']['role']) || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])) {
    session_unset();
    session_destroy();
    header('Location: ../../unauthorized.php');
    exit;
}

// بعدين نقرأ الجلسة بأمان
$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];
$user_secret_level = $user['secret_level'];

// بعدين نطبق حماية الدور
allow_roles(['admin', 'manager','user']);


$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
$users = [];

if ($role === 'admin') {
  // المدير العام يشوف كل المستخدمين
  $users = $conn->query("SELECT id, name, department_id FROM users")->fetchAll(PDO::FETCH_ASSOC);

} elseif ($role === 'manager') {
  // المدير يشوف المدير العام + كل المدراء + موظفي إدارته
  $stmt = $conn->prepare("
    SELECT id, name, department_id FROM users
    WHERE role IN ('admin', 'manager') OR (role = 'employee' AND department_id = ?)
  ");
  $stmt->execute([$department_id]);
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

} elseif ($role === 'employee', 'user') {
  // الموظف يشوف المدير حقه وزملائه
  $stmt = $conn->prepare("
    SELECT id, name, department_id FROM users
    WHERE department_id = ? AND role IN ('manager', 'employee')
  ");
  $stmt->execute([$department_id]);
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// تأكد ان المستخدم نفسه موجود بالقائمة
$exists = array_filter($users, fn($u) => $u['id'] == $user['id']);
if (!$exists) {
  $users[] = [
    'id' => $user['id'],
    'name' => $user['name'],
    'department_id' => $user['department_id']
  ];
}
$stages = $conn->query("SELECT id, name, department_id FROM stages")->fetchAll(PDO::FETCH_ASSOC);

$projects = $conn->query("SELECT id, name FROM projects ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

?>
<div class="overflow-y-auto max-h-[calc(100vh-140px)] pr-2">
  <form method="POST" action="store.php" enctype="multipart/form-data" class="space-y-4" id="modalTaskForm">
    
  <div>
    <label class="block text-sm font-medium mb-1">العنوان</label>
    <input type="text" name="title" required class="w-full border rounded px-3 py-2">
  </div>

  <div>
    <label class="block text-sm font-medium mb-1">الوصف</label>
    <textarea name="description" rows="3" required class="w-full border rounded px-3 py-2"></textarea>
  </div>
  
<div>
  <label class="block text-sm font-medium mb-1">المشروع المرتبط (اختياري):</label>
  <select name="project_id" class="w-full border rounded px-3 py-2">
    <option value="">بدون مشروع</option>
    <?php foreach ($projects as $proj): ?>
      <option value="<?= $proj['id'] ?>"><?= htmlspecialchars($proj['name']) ?></option>
    <?php endforeach; ?>
  </select>
</div>

  <div class="grid grid-cols-2 gap-4">
    <div>
      <label class="block text-sm font-medium mb-1">الإدارة</label>
      <select name="department_id" id="modal-department" class="w-full border rounded px-3 py-2" required>
        <option value="">-- اختر الإدارة --</option>
        <?php foreach ($departments as $dep): ?>
          <option value="<?= $dep['id'] ?>"><?= $dep['name'] ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">المرحلة</label>
      <select name="stage_id" id="modal-stage" class="w-full border rounded px-3 py-2" required>
        <option value="">-- اختر المرحلة --</option>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">تعيين إلى</label>
      <select name="assigned_to" id="modal-assigned" class="w-full border rounded px-3 py-2" required>
        <option value="">-- اختر المستخدم --</option>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">الأولوية</label>
      <select name="priority" class="w-full border rounded px-3 py-2">
        <option value="low">منخفضة</option>
        <option value="medium">متوسطة</option>
        <option value="high">عالية</option>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">السرية</label>
      <select name="secret_level" class="w-full border rounded px-3 py-2">
        <option value="normal">عادية</option>
        <option value="secret">سرية</option>
        <option value="top_secret">سرية جداً</option>
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium mb-1">تاريخ الاستحقاق</label>
      <input type="date" name="due_date" class="w-full border rounded px-3 py-2">
    </div>

    <div>
      <label class="block text text-sm font-medium mb-1">📎 المرفقات</label>
      <input type="file" name="attachments[]" multiple class="w-full border rounded px-3 py-2">
    </div>
  </div>

  <!-- الحقول المخصصة -->
  <div id="customFieldsContainer" class="grid grid-cols-2 gap-4"></div>

  <div class="text-center pt-4">
    <button type="submit" class=" text-white px-6 py-2 rounded hover:bg-green-700" style="background-color: #7be667;">📀 حفظ</button>
  </div>
</form>

  </form>

</div>
<script>
const users = <?= json_encode($users) ?>;
const stages = <?= json_encode($stages) ?>;

const deptSelect = document.getElementById("modal-department");
const assignedSelect = document.getElementById("modal-assigned");
const stageSelect = document.getElementById("modal-stage");
const customContainer = document.getElementById("customFieldsContainer");

// تحميل المستخدمين والمراحل عند اختيار الإدارة
deptSelect.addEventListener("change", function () {
  const deptId = this.value;

  // المستخدمين
  assignedSelect.innerHTML = `<option value="">-- اختر المستخدم --</option>`;
  users.filter(u => u.department_id == deptId).forEach(u => {
    const option = document.createElement("option");
    option.value = u.id;
    option.textContent = u.name;
    assignedSelect.appendChild(option);
  });

  // المراحل
  stageSelect.innerHTML = `<option value="">-- اختر المرحلة --</option>`;
  stages.filter(s => s.department_id == deptId).forEach(s => {
    const option = document.createElement("option");
    option.value = s.id;
    option.textContent = s.name;
    stageSelect.appendChild(option);
  });

  // تحميل الحقول المخصصة
  customContainer.innerHTML = "جاري التحميل...";
  fetch(`../api/get_custom_fields_api.php?department_id=${deptId}`)
    .then(res => res.json())
    .then(data => {
      customContainer.innerHTML = "";
      if (data.success && data.fields.length > 0) {
        data.fields.forEach(field => {
          const wrapper = document.createElement("div");
          wrapper.innerHTML = `
            <label class="block text-sm font-medium mb-1">${field.label}</label>
            <input type="${field.type}" name="custom_fields[${field.id}]" class="w-full border rounded px-3 py-2">
          `;
          customContainer.appendChild(wrapper);
        });
      } else {
        customContainer.innerHTML = "";
      }
    });
});

// الحفظ بدون إعادة تحميل
const form = document.getElementById("modalTaskForm");
form.addEventListener("submit", function(e) {
  e.preventDefault();
  const formData = new FormData(this);

fetch("store.php", {
  method: "POST",
  body: formData,
  headers: {
    "X-Requested-With": "XMLHttpRequest"
  }
})
  .then(res => res.json())
  .then(data => {
  if (data.success) {
    window.parent.postMessage("close-modal", "*");
    window.parent.postMessage("refresh-tasks", "*");
  } else {
    alert("❌ فشل في الحفظ: " + (data.message || ''));
  }
})

  .catch(err => {
    console.error(err);
    alert("❌ حصل خطأ أثناء الحفظ");
  });
});
</script>
