<?php
require_once '../config/db.php';
require_once '../auth.php';

$task_id = $_GET['task_id'] ?? null;
if (!$task_id) {
  echo "<p class='text-red-600 text-center mt-10'>المهمة غير موجودة.</p>";
  exit;
}

$stmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
$stmt->execute([$task_id]);
$task = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$task) {
  echo "<p class='text-red-600 text-center mt-10'>تعذر العثور على المهمة.</p>";
  exit;
}

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
$users = $conn->query("SELECT id, name FROM users")->fetchAll(PDO::FETCH_ASSOC);

$due_date = ($task['due_date'] && $task['due_date'] !== '0000-00-00') ? $task['due_date'] : '';

$customStmt = $conn->prepare("SELECT * FROM custom_fields WHERE department_id = ?");
$customStmt->execute([$task['department_id']]);
$customFields = $customStmt->fetchAll(PDO::FETCH_ASSOC);

$valuesStmt = $conn->prepare("SELECT * FROM task_custom_values WHERE task_id = ?");
$valuesStmt->execute([$task_id]);
$customValues = [];
foreach ($valuesStmt->fetchAll(PDO::FETCH_ASSOC) as $cv) {
  $customValues[$cv['field_id']] = $cv['value'];
}
$role = $_SESSION['user']['role'] ?? '';
$isManager = in_array($role, ['manager', 'admin']);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تعديل مهمة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-black bg-opacity-50 flex items-center justify-center min-h-screen p-4">

  <div class="bg-white rounded-2xl shadow-xl w-full max-w-6xl max-h-[95vh] overflow-y-auto p-6" id="taskModal">
    <h2 class="text-lg font-bold mb-4">تعديل مهمة</h2>

    <form id="editTaskForm" class="grid grid-cols-5 gap-6">
      <input type="hidden" name="id" value="<?= $task['id'] ?>">

    <!-- القسم الأيمن (3 أعمدة) -->
    <div class="col-span-3 space-y-4">
      <div>
        <label class="block text-sm font-medium mb-1">العنوان</label>
        <input type="text" name="title" value="<?= htmlspecialchars($task['title']) ?>" required class="w-full border rounded px-3 py-2">
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">الوصف</label>
        <textarea name="description" rows="4" required class="w-full border rounded px-3 py-2"><?= htmlspecialchars($task['description']) ?></textarea>
      </div>
<?php
$templateStmt = $conn->prepare("SELECT * FROM templates WHERE stage_id = ? LIMIT 1");
$templateStmt->execute([$task['stage_id']]);
$template = $templateStmt->fetch(PDO::FETCH_ASSOC);
?>

<?php if ($template): ?>
  <div class="border rounded p-3  mt-4">
    <label class="block text-sm font-medium mb-2">📄 النموذج المرتبط</label>
    <div class="flex gap-3">
      <a href="<?= $template['file_path'] ?>" target="_blank"
         class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">📂 عرض النموذج</a>

      <?php if ($_SESSION['user']['can_sign'] && $_SESSION['user']['id'] == $template['signer_user_id']): ?>
        <form method="POST" action="../templates/sign_template.php" target="_blank"
              onsubmit="return confirm('هل تريد توقيع هذا النموذج الآن؟ سيتم حفظه كمرفق؟')">
          <input type="hidden" name="task_id" value="<?= $task['id'] ?>">
          <input type="hidden" name="template_id" value="<?= $template['id'] ?>">
          <button type="submit" class=" text-white px-4 py-2 rounded hover:bg-green-700" style="background-color: #7be667;">✍️ توقيع النموذج</button>
        </form>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>

      <div>
        <h3 class="font-bold text-sm mb-2">📎 المرفقات</h3>
        <input type="file" id="attachmentInput" class="mb-2">
        <button onclick="uploadAttachment()" type="button" class="bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700">رفع</button>
        <div id="attachmentList" class="grid grid-cols-3 gap-3 mt-4"></div>
      </div>
      <div>
        <h3 class="font-bold text-sm mb-2">💬 التعليقات</h3>
        <textarea id="newComment" rows="2" class="w-full border rounded px-3 py-2 mb-2" placeholder="اكتب تعليقك هنا..."></textarea>
        <button onclick="submitComment()" type="button" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">إرسال</button>
        <div id="commentsList" class="mt-4 space-y-3 text-sm"></div>
      </div>
    </div>

    <!-- القسم الأيسر (2 أعمدة) -->
    <div class="col-span-2 space-y-4">
      <?php
      $stageStmt = $conn->prepare("SELECT id, name FROM stages WHERE department_id = ?");
      $stageStmt->execute([$task['department_id']]);
      $stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);
      ?>
      <div>
        <label class="block text-sm font-medium mb-1">المرحلة</label>
        <select name="stage_id" class="w-full border rounded px-3 py-2">
          <?php foreach ($stages as $stage): ?>
            <option value="<?= $stage['id'] ?>" <?= $task['stage_id'] == $stage['id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($stage['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">الأولوية</label>
        <select name="priority" class="w-full border rounded px-3 py-2">
          <option value="low" <?= $task['priority'] === 'low' ? 'selected' : '' ?>>منخفضة</option>
          <option value="medium" <?= $task['priority'] === 'medium' ? 'selected' : '' ?>>متوسطة</option>
          <option value="high" <?= $task['priority'] === 'high' ? 'selected' : '' ?>>عالية</option>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">السرية</label>
        <select name="secret_level" class="w-full border rounded px-3 py-2">
          <option value="normal" <?= $task['secret_level'] === 'normal' ? 'selected' : '' ?>>عادية</option>
          <option value="secret" <?= $task['secret_level'] === 'secret' ? 'selected' : '' ?>>سرية</option>
          <option value="top_secret" <?= $task['secret_level'] === 'top_secret' ? 'selected' : '' ?>>سرية جداً</option>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">تاريخ الاستحقاق</label>
        <input type="date" name="due_date" value="<?= $due_date ?>" class="w-full border rounded px-3 py-2">
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">الإدارة</label>
        <select name="department_id" class="w-full border rounded px-3 py-2">
          <?php foreach ($departments as $dep): ?>
            <option value="<?= $dep['id'] ?>" <?= $task['department_id'] == $dep['id'] ? 'selected' : '' ?>><?= $dep['name'] ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">تعيين إلى</label>
        <select name="assigned_to" class="w-full border rounded px-3 py-2">
          <?php foreach ($users as $user): ?>
            <option value="<?= $user['id'] ?>" <?= $task['assigned_to'] == $user['id'] ? 'selected' : '' ?>><?= $user['name'] ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <?php foreach ($customFields as $field): ?>
        <div>
          <label class="block text-sm font-medium mb-1"><?= htmlspecialchars($field['label']) ?></label>
          <?php $val = htmlspecialchars($customValues[$field['id']] ?? '') ?>
          <?php if ($field['type'] === 'text'): ?>
            <input type="text" name="custom_fields[<?= $field['id'] ?>]" value="<?= $val ?>" class="w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'number'): ?>
            <input type="number" name="custom_fields[<?= $field['id'] ?>]" value="<?= $val ?>" class="w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'date'): ?>
            <input type="date" name="custom_fields[<?= $field['id'] ?>]" value="<?= $val ?>" class="w-full border rounded px-3 py-2">
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
      <div class="pt-4">
        <button type="submit" class=" text-white px-6 py-2 rounded hover:bg-green-700 w-full" style="background-color: #7be667;">💾 حفظ التعديلات</button>
      </div>
    </div>
  </form>

  <script>
    const taskId = <?= json_encode($task_id) ?>;
const isManager = <?= json_encode($isManager) ?>;

    function uploadAttachment() {
      const input = document.getElementById("attachmentInput");
      const file = input.files[0];
      if (!file) return alert("❗ الرجاء اختيار ملف");

      const data = new FormData();
      data.append("file", file);
      data.append("task_id", taskId);

      fetch("../api/upload_attachment_api.php", {
        method: "POST",
        body: data
      })
      .then(res => res.json())
      .then(res => {
        if (res.success) {
          loadAttachments();
          input.value = "";
        } else {
          alert("❌ فشل في رفع المرفق");
        }
      });
    }

    function deleteAttachment(id) {
      if (!confirm("هل أنت متأكد من الحذف؟")) return;
      fetch(`../api/delete_attachment_api.php?id=${id}`)
        .then(res => res.json())
        .then(res => {
          if (res.success) loadAttachments();
        });
    }

    function loadAttachments() {
      fetch(`../api/get_attachments_api.php?task_id=${taskId}`)
        .then(res => res.json())
        .then(res => {
          const list = document.getElementById("attachmentList");
          list.innerHTML = "";
          if (res.success) {
            res.attachments.forEach(file => {
              const ext = file.file_path.split('.').pop().toLowerCase();
              const isImage = ['jpg','jpeg','png','gif','webp'].includes(ext);
              const box = document.createElement("div");
              box.className = "border rounded overflow-hidden text-sm relative";
              let html = isImage
                ? `<img src="../${file.file_path}" class="w-full h-24 object-cover">`
                : `<div class='flex items-center justify-center h-24 bg-gray-100'>${ext.toUpperCase()}</div>`;
if (isManager) {
  html += `<button type="button" onclick="deleteAttachment(${file.id})" class="absolute top-1 right-1 bg-red-600 text-white text-xs px-1 rounded-full">×</button>`;
}
              box.innerHTML = html;
              list.appendChild(box);
            });
          }
        });
    }

function deleteComment(id) {
  if (!confirm("هل أنت متأكد من حذف هذا التعليق؟")) return;
  fetch(`../api/delete_comment_api.php?id=${id}`)
    .then(res => res.json())
    .then(res => {
      if (res.success) {
        loadComments(); // هنا يتم إعادة تحميل التعليقات
      } else {
        alert("فشل في الحذف: " + (res.message || ""));
      }
    });
}

    function submitComment() {
      const content = document.getElementById("newComment").value;
      if (!content.trim()) return alert("❗ الرجاء كتابة تعليق");

      fetch("../api/add_comment_api.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ task_id: taskId, content })
      })
      .then(res => res.json())
      .then(res => {
        if (res.success) {
          document.getElementById("newComment").value = "";
          loadComments();
        } else {
          alert("❌ فشل في إرسال التعليق");
        }
      });
    }

    function loadComments() {
      fetch(`../api/get_comments_api.php?task_id=${taskId}`)
        .then(res => res.json())
        .then(res => {
          const list = document.getElementById("commentsList");
          list.innerHTML = "";
          if (res.success && res.comments.length > 0) {
            res.comments.forEach(comment => {
              const div = document.createElement("div");
              div.className = "border rounded p-2 card text relative";
              div.innerHTML = `<strong>${comment.author_name}</strong><br>${comment.comment}`;
              if (isManager) {
div.innerHTML += `<button type="button" onclick="deleteComment(${comment.id})" class="absolute top-1 left-1 bg-red-600 text-white text-xs px-1 rounded-full">×</button>`;
              }
              list.appendChild(div);
            });
          } else {
            list.innerHTML = "<p class='text-gray-500'>لا توجد تعليقات بعد.</p>";
          }
        });
    }

document.getElementById("editTaskForm").addEventListener("submit", function(e) {
  e.preventDefault();
  const data = new FormData(this);

  fetch("../api/update_task_api.php", {
    method: "POST",
    body: data
  })
  .then(res => res.json())
  .then(res => {
    if (res.success) {
      if (window.parent !== window) {
        window.parent.postMessage("close-modal", "*"); // يغلق النافذة
        window.parent.postMessage("refresh-tasks", "*"); // يحدث الصفحة الرئيسية (اللي فيها الكانبان أو list)
      } else {
        window.location.href = "list.php"; // fallback إذا ما فيه نافذة أم
      }
    } else {
      alert("❌ فشل في تحديث المهمة");
    }
  });
});

    window.onload = () => {
      loadAttachments();
      loadComments();
    };
window.addEventListener("message", (event) => {
  if (event.data === "close-modal") {
    document.getElementById("taskModal").classList.add("hidden");
  }
  if (event.data === "refresh-tasks") {
    window.location.reload();
  }
});

  </script>
</body>
</html>
