<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../config/db.php';
require_once '../auth.php';
require_once '../vendor/autoload.php'; // تأكد أن المسار صحيح


$task_id = $_GET['task_id'] ?? null;
if (!$task_id) {
  echo "<p class='text-red-600 text-center mt-10'>المهمة غير موجودة.</p>";
  exit;
}

$stmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
$stmt->execute([$task_id]);
$task = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$task) {
  echo "<p class='text-red-600 text-center mt-10'>تعذر العثور على المهمة.</p>";
  exit;
}

$departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
$users = $conn->query("SELECT id, name, role, department_id FROM users")->fetchAll(PDO::FETCH_ASSOC);

$due_date = ($task['due_date'] && $task['due_date'] !== '0000-00-00') ? $task['due_date'] : '';
// جلب كل المشاريع
$projects = $conn->query("SELECT id, name FROM projects ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
// جلب التصنيفات
$types = $conn->query("SELECT id, name FROM task_types ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);


$customStmt = $conn->prepare("SELECT * FROM custom_fields WHERE department_id = ?");
$customStmt->execute([$task['department_id']]);
$customFields = $customStmt->fetchAll(PDO::FETCH_ASSOC);

$valuesStmt = $conn->prepare("SELECT * FROM task_custom_values WHERE task_id = ?");
$valuesStmt->execute([$task_id]);
$customValues = [];
foreach ($valuesStmt->fetchAll(PDO::FETCH_ASSOC) as $cv) {
  $customValues[$cv['field_id']] = $cv['value'];
}

// بعد جلب بيانات المهمة

$current_user = $_SESSION['user'];
$user_id = $current_user['id'];
$can_sign = $current_user['can_sign'] ?? 0;
$user_role = $current_user['role'] ?? '';
$user_department_id = $current_user['department_id'] ?? null;
$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeNavColor = $color['nav_color'];
$chartColor = $color['chart_color'];
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];

// جلب النموذج المرتبط بنفس المرحلة والإدارة
$templateStmt = $conn->prepare("SELECT * FROM templates WHERE stage_id = ? AND department_id = ?");
$templateStmt->execute([$task['stage_id'], $task['department_id']]);
$template = $templateStmt->fetch(PDO::FETCH_ASSOC);

// تحقق من وجود النموذج وصلاحية التوقيع وتطابق الموقّع
function canUserSignTemplate($template, $user)
{
  if (!$template || !$user) return false;

  $isSigner = $template['signer_user_id'] == $user['id'];
  $hasPermission = ($user['can_sign'] ?? 0) || $user['role'] === 'admin';
  $sameDepartment = $user['department_id'] == $template['department_id'];
  $isGlobal = $user['role'] === 'admin';

  return $isSigner && $hasPermission && ($sameDepartment || $isGlobal);
}

// استخدام الدالة
$show_sign_buttons = canUserSignTemplate($template, $current_user);


$role = $_SESSION['user']['role'] ?? '';
$isManager = in_array($role, ['manager', 'admin']);
?>
<style>
  .move-button {
    background-color: #4d70f4;
    border-radius: 15px !important;
  }


  .text,
  label,
  option,
  h2,
  select,
  a {
    color: <?php echo $userThemeTextColor; ?> !important;
  }

  .view-tasks {
    background-color: none !important;
    /* background-color: rgb(19, 11, 57) !important; */
    border: 3px solid rgb(110, 118, 56) !important;
    border-radius: 15px !important;
    color: <?= ($currentUserColorId == 3) ?  htmlspecialchars('#ffffff') : htmlspecialchars('#000000'); ?> !important;

  }

  .view-tasks:hover {
    background-color: <?php echo $userThemeColor; ?> !important;
    border: 3px solid <?= ($currentUserColorId == 3) ?  htmlspecialchars('#ffffff') : htmlspecialchars('#130B39'); ?> !important;
    color: <?= ($currentUserColorId == 3) ?  htmlspecialchars('#ffffff') : htmlspecialchars('#000000'); ?> !important;

  }
</style>


<!-- محتوى المودال الخاص بالكانبان -->
<div class="main-card p-6 bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[80vh] overflow-y-auto animate-fade-in">
  <form id="editTaskForm" class="grid grid-cols-5 gap-6 items-start">
    <input type="hidden" name="id" value="<?= $task['id'] ?>">


    <!-- القسم الأيمن -->
    <div class="col-span-3 space-y-3">
        <!-- شريط معلومات سريع -->
<div class="flex items-center justify-between mb-4">
  <div class="flex items-center gap-3">
    <span class="inline-flex items-center gap-2 px-3 py-1 rounded-full text-sm font-semibold border"
          style="border-color:#e5e7eb;color:#111827;background:#f9fafb;">
      🆔 رقم المعاملة:
      <span id="taskIdText">#<?= (int)$task['id'] ?></span>
    </span>

    <button type="button" id="copyTaskIdBtn"
            class="px-3 py-1 rounded text-sm border hover:bg-gray-100"
            title="نسخ رقم المعاملة">
      📋 نسخ
    </button>

    <!-- رابط سريع لاستعراض المعاملة بصفحة منفصلة (اختياري) -->
    <a href="veiow.php?task_id=<?= (int)$task['id'] ?>" target="_blank"
       class="px-3 py-1 rounded text-sm border hover:bg-gray-100">
      👁️ عرض كامل
    </a>
  </div>

  <!-- تقدر تحط أي وسم ثانوي يمين الشريط (اختياري) -->
  <span class="text-xs text-gray-500">تم الإنشاء: <?= htmlspecialchars(date('Y-m-d H:i', strtotime($task['created_at'] ?? 'now'))) ?></span>
</div>

      <div>
        <label class="block text-sm font-medium mb-1">العنوان</label>
        <input type="text" name="title" value="<?= htmlspecialchars($task['title']) ?>" required class="card w-full border rounded px-3 py-2">
      </div>
      <div id="modalAlert" class="hidden mb-3 px-4 py-2 rounded text-sm font-medium"></div>

      <div>
        <label class="block text-sm font-medium mb-1">الوصف</label>
        <textarea name="description" rows="4" required class="card w-full border rounded px-3 py-2 text"><?= htmlspecialchars($task['description']) ?></textarea>
      </div>
      <?php if ($show_sign_buttons): ?>
        <div class="border-t pt-3 mt-3">
          <h3 class="text-sm font-bold mb-2">نموذج التوقيع المرتبط</h3>
          <div class="flex flex-wrap items-center gap-2">

            <button type="button"
              onclick="openTemplateOverlay(<?= $task['id'] ?>, <?= $template['id'] ?>)"
              class="card bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700">
              📄 عرض النموذج
            </button>




          </div>
        </div>
      <?php endif; ?>



      <div>
        <h3 class="font-bold text-sm mb-2  " style="color: <?php echo $userThemeTextColor; ?> !important;">📎 المرفقات</h3>
        <input type="file" id="attachmentInput" class="mb-2">
        <button id="uploadAttachmentBtn" type="button" class="text view-tasks text-white px-8 py-0 border rounded ">رفع</button>
        <div id="attachmentList" class="grid grid-cols-3 gap-3 mt-4"></div>
      </div>

      <div>
        <div class="flex space-x-2 rtl:space-x-reverse mb-2">
          <button type="button" onclick="showComments()" class=" text-white px-4 border py-1 rounded text-sm move-button">💬 التعليقات</button>
          <button type="button" onclick="showLogs()" class="bg-gray-300 px-4 py-1 border rounded text-sm hover:bg-gray-400 " style="border-radius: 15px !important;">📜 سجل التعديلات</button>
        </div>

        <div id="commentsSection">
          <textarea id="newComment" rows="2" class="w-full card text border rounded px-3 py-2 mb-2" placeholder="اكتب تعليقك هنا..."></textarea>
          <button id="submitCommentBtn" type="button" class="border  text-white px-8 py-0 rounded hover:bg-blue-700 move-button">إرسال</button>
          <div id="commentsList" class="card text mt-4 space-y-3 text-sm"></div>
        </div>

        <div id="logsSection" class="hidden">
          <div id="logsList" class="space-y-3 text-sm text-gray-700">
            <p>📦 تحميل السجل...</p>
          </div>
        </div>
      </div>

    </div> <!-- نهاية القسم الأيمن -->

    <!-- القسم الأيسر -->
    <div class="col-span-2 space-y-4 flex flex-col min-h-[1px]">
      <?php
      $stageStmt = $conn->prepare("SELECT id, name FROM stages WHERE department_id = ?");
      $stageStmt->execute([$task['department_id']]);
      $stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);
      ?>
      <div>
  <label class="block text-sm font-medium mb-1">المشروع</label>
  <select name="project_id" class="card w-full border rounded px-3 py-2">
    <option value="">بدون مشروع</option>
    <?php foreach ($projects as $proj): ?>
      <option value="<?= $proj['id'] ?>" <?= ($task['project_id'] == $proj['id']) ? 'selected' : '' ?>>
        <?= htmlspecialchars($proj['name']) ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>
 
<div>
  <label class="block text-sm font-medium mb-1">التصنيف</label>
  <select name="task_type_id" class="card w-full border rounded px-3 py-2">
    <option value="">بدون تصنيف</option>
    <?php foreach ($types as $type): ?>
      <option value="<?= $type['id'] ?>" <?= ($task['task_type_id'] == $type['id']) ? 'selected' : '' ?>>
        <?= htmlspecialchars($type['name']) ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>

      <div>
        <label class="block text-sm font-medium mb-1">المرحلة</label>
        <select name="stage_id" class="card w-full border rounded px-3 py-2">
          <?php foreach ($stages as $stage): ?>
            <option value="<?= $stage['id'] ?>" <?= $task['stage_id'] == $stage['id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($stage['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">الأولوية</label>
        <select name="priority" class="card w-full border rounded px-3 py-2">
          <option value="low" <?= $task['priority'] === 'low' ? 'selected' : '' ?>>منخفضة</option>
          <option value="medium" <?= $task['priority'] === 'medium' ? 'selected' : '' ?>>متوسطة</option>
          <option value="high" <?= $task['priority'] === 'high' ? 'selected' : '' ?>>عالية</option>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">السرية</label>
        <select name="secret_level" class=" card w-full border rounded px-3 py-2">
          <option value="normal" <?= $task['secret_level'] === 'normal' ? 'selected' : '' ?>>عادية</option>
          <option value="secret" <?= $task['secret_level'] === 'secret' ? 'selected' : '' ?>>سرية</option>
          <option value="top_secret" <?= $task['secret_level'] === 'top_secret' ? 'selected' : '' ?>>سرية جداً</option>
        </select>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">تاريخ الاستحقاق</label>
        <input type="date" name="due_date" value="<?= $due_date ?>" class="card w-full border rounded px-3 py-2">
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">الإدارة</label>
        <?php if ($role === 'employee'): ?>
          <input type="hidden" name="department_id" value="<?= $task['department_id'] ?>">
          <input type="text" class="w-full  border rounded px-3 py-2 bg-gray-100 cursor-not-allowed"
            value="<?= htmlspecialchars(array_values(array_filter($departments, fn($d) => $d['id'] == $task['department_id']))[0]['name'] ?? 'إدارتك') ?>" disabled>
        <?php else: ?>
          <select name="department_id" class="card w-full border rounded px-3 py-2">
            <?php foreach ($departments as $dep): ?>
              <option value="<?= $dep['id'] ?>" <?= $task['department_id'] == $dep['id'] ? 'selected' : '' ?>>
                <?= $dep['name'] ?>
              </option>
            <?php endforeach; ?>
          </select>
        <?php endif; ?>
      </div>
      <div>
        <label class="block text-sm font-medium mb-1">تعيين إلى</label>
        <select name="assigned_to" class="card w-full border rounded px-3 py-2">
          <?php
          foreach ($users as $user):
            $show = false;
            if ($role === 'admin') {
              $show = true;
            } elseif ($role === 'manager') {
              if (
                ($user['role'] === 'employee' && $user['department_id'] == $task['department_id']) ||
                in_array($user['role'], ['manager', 'admin'])
              ) {
                $show = true;
              }
            } elseif ($role === 'employee') {
              if (
                $user['department_id'] == $task['department_id'] &&
                in_array($user['role'], ['employee', 'manager'])
              ) {
                $show = true;
              }
            }
            if ($show): ?>
              <option value="<?= $user['id'] ?>" <?= $task['assigned_to'] == $user['id'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($user['name']) ?>
              </option>
          <?php endif;
          endforeach; ?>
        </select>
      </div>
      <?php foreach ($customFields as $field): ?>
        <div>
          <label class="block text-sm font-medium mb-1"><?= htmlspecialchars($field['label']) ?></label>
          <?php $val = htmlspecialchars($customValues[$field['id']] ?? '') ?>
          <?php if ($field['type'] === 'text'): ?>
            <input type="text" name="custom_fields[<?= $field['id'] ?>]" value="<?= $val ?>" class=" card w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'number'): ?>
            <input type="number" name="custom_fields[<?= $field['id'] ?>]" value="<?= $val ?>" class="card w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'date'): ?>
            <input type="date" name="custom_fields[<?= $field['id'] ?>]" value="<?= $val ?>" class="card w-full border rounded px-3 py-2">
          <?php elseif ($field['type'] === 'dropdown'): ?>
            <select name="custom_fields[<?= $field['id'] ?>]" class="w-full border rounded px-3 py-2">
              <?php
              $options = explode(',', $field['options']);
              foreach ($options as $opt):
              ?>
                <option value="<?= trim($opt) ?>"><?= htmlspecialchars(trim($opt)) ?></option>
              <?php endforeach; ?>
            </select>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
<div class="pt-4 flex gap-2">
  <button type="button" id="saveEditBtn" class="border text-white px-6 py-2 rounded hover:bg-green-700 w-full" style="background-color: #7be667;color:black;">
    💾 حفظ التعديلات
  </button>
  <a href="veiow.php?task_id=<?= $task['id'] ?>" target="_blank"
     class="border px-6 py-2 rounded hover:bg-blue-700 w-full text-white"
     style="background-color: #1c64f2;">
    👁️ عرض المعاملة
  </a>
</div>
    </div>
  </form>



  <div id="toast" class="fixed bottom-5 right-5 text-white px-4 py-2 rounded shadow-lg hidden z-[9999] transition-opacity duration-300" style="background-color: #7be667;"></div>

  <!-- ✅ نافذة عرض النموذج -->
  <div id="templateOverlay" class="hidden fixed inset-0 z-[9999] bg-black/50 flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-xl w-[90%] max-w-5xl h-[90vh] overflow-hidden relative">
      <button onclick="closeTemplateOverlay()"
        class="absolute top-3 right-3 text-red-600 text-2xl font-bold z-10">&times;</button>
      <iframe id="templateFrame" class="w-full h-full border-0 rounded-b-lg"></iframe>
    </div>
  </div>

  <script>
    function openTemplateOverlay(taskId, templateId) {
      const frame = document.getElementById("templateFrame");
      frame.src = `../templates/view_template_modal.php?task_id=${taskId}&template_id=${templateId}`;
      document.getElementById("templateOverlay").classList.remove("hidden");
    }

    function closeTemplateOverlay() {
      document.getElementById("templateOverlay").classList.add("hidden");
      document.getElementById("templateFrame").src = "";
    }
  </script>


  <script>
    window.taskId = <?= json_encode($task_id) ?>;
    window.isManager = <?= json_encode($isManager) ?>;

    if (typeof loadAttachments === 'function') loadAttachments();
    if (typeof loadComments === 'function') loadComments();

    function showComments() {
      document.getElementById('commentsSection').classList.remove('hidden');
      document.getElementById('logsSection').classList.add('hidden');
    }

    function showLogs() {
      document.getElementById('commentsSection').classList.add('hidden');
      document.getElementById('logsSection').classList.remove('hidden');
      loadLogs();
    }

    function showToast(message, type = 'success') {
      const toast = document.getElementById('toast');
      toast.textContent = message;
      toast.className = `fixed bottom-5 right-5 px-4 py-2 rounded shadow-lg z-[9999] transition-opacity duration-300 ${type === 'success' ? 'bg-green-600 text-white' : 'bg-red-600 text-white'}`;
      toast.classList.remove('hidden');
      setTimeout(() => toast.classList.add('hidden'), 3000);
    }

function loadLogs() {
  fetch(`../api/get_task_logs.php?task_id=${taskId}`)
    .then(res => res.json())
    .then(res => {
      const logsList = document.getElementById('logsList');
      logsList.innerHTML = '';
      if (res.success && Array.isArray(res.logs) && res.logs.length) {
        logsList.innerHTML = res.logs.map(log => `
          <div class="border p-2 rounded bg-gray-100">
            <div class="font-semibold">${log.user_name}</div>
            <div>${log.action_type} - ${log.action_details}</div>
            <div class="text-xs text-gray-500 mt-1">${log.created_at}</div>
          </div>
        `).join('');
      } else {
        logsList.innerHTML = '<p class="text-gray-500 text-sm">لا يوجد سجلات حتى الآن.</p>';
      }
    })
    .catch(err => console.error('logs error:', err));
}

  // نسخ رقم المعاملة بضغطة زر
  document.getElementById('copyTaskIdBtn')?.addEventListener('click', async () => {
    try {
      const idText = document.getElementById('taskIdText')?.textContent || '';
      const plainId = idText.replace('#','').trim(); // لو تبي الرقم فقط
      await navigator.clipboard.writeText(plainId);
      showToast('✅ تم نسخ رقم المعاملة');
    } catch (e) {
      console.error(e);
      showToast('⚠️ ما قدرنا ننسخ رقم المعاملة', 'error');
    }
  });


    document.getElementById('saveEditBtn').addEventListener('click', function() {
      const form = document.getElementById('editTaskForm');
      const formData = new FormData(form);

      fetch('../api/update_task_api.php', {
          method: 'POST',
          body: formData
        })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            showToast('✅ تم حفظ التعديلات بنجاح');
            console.log('تم الحفظ بنجاح - بدون تحديث أو إغلاق');
            // إذا تبي تقفل المودال أو تحدث الكانبان لاحقًا، ضيفه هنا
          } else {
            showToast('❌ فشل الحفظ: ' + (data.message || ''), 'error');
          }
        })
        .catch(err => {
          console.error(err);
          showToast('⚠️ حصل خطأ أثناء الاتصال', 'error');
        });
    });