<?php
session_start();
require_once '../config/db.php';
require_once '../auth.php';
require_once '../authorize.php';

if (!isset($_SESSION['user']) || !in_array($_SESSION['user']['role'], ['admin','manager'])) {
  header('Location: ../unauthorized.php'); exit;
}

$task_id           = isset($_POST['task_id']) ? (int)$_POST['task_id'] : 0;
$new_department_id = isset($_POST['new_department_id']) ? (int)$_POST['new_department_id'] : 0;
$new_stage_id      = isset($_POST['new_stage_id']) ? (int)$_POST['new_stage_id'] : 0;
$open_after        = isset($_POST['open_after']) ? 1 : 0;

if ($task_id<=0 || $new_department_id<=0 || $new_stage_id<=0) {
  header('Location: archive_tasks.php?type=archived&error=missing'); exit;
}

// المرحلة لازم تتبع الإدارة
$chk = $conn->prepare("SELECT id, department_id FROM stages WHERE id = ? LIMIT 1");
$chk->execute([$new_stage_id]);
$stage = $chk->fetch(PDO::FETCH_ASSOC);
if (!$stage || (int)$stage['department_id'] !== $new_department_id) {
  header('Location: archive_tasks.php?type=archived&error=stage_dep_mismatch'); exit;
}

// نتحقق إذا فيه عمود updated_at أو لا
$hasUpdatedAt = false;
try {
  $col = $conn->query("SHOW COLUMNS FROM tasks LIKE 'updated_at'");
  $hasUpdatedAt = (bool)$col->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {}

try {
  $conn->beginTransaction();

  // (اختياري) تنظيف جدول archived_tasks لو موجود
  try {
    $del = $conn->prepare("DELETE FROM archived_tasks WHERE original_task_id = ?");
    $del->execute([$task_id]);
  } catch (Exception $e) {}

  // نبني جملة التحديث حسب وجود updated_at
  $updateSql = "
    UPDATE tasks
    SET department_id = ?,
        stage_id      = ?,
        archived_at   = NULL,
        archive_type  = NULL,
        is_deleted    = 0,
        deleted_at    = NULL,
        completed_at  = NULL"
    . ($hasUpdatedAt ? ", updated_at = NOW()" : "") .
    " WHERE id = ?
      LIMIT 1
  ";

  $up = $conn->prepare($updateSql);
  $up->execute([$new_department_id, $new_stage_id, $task_id]);

  // تأكيد التصفير
  $check = $conn->prepare("SELECT archived_at, archive_type FROM tasks WHERE id = ?");
  $check->execute([$task_id]);
  $row = $check->fetch(PDO::FETCH_ASSOC);
  if ($row && ($row['archived_at'] !== null || $row['archive_type'] !== null)) {
    throw new Exception('لم يتم تصفير حقول الأرشفة');
  }

  // لوق (اختياري)
  try {
    $user_id = $_SESSION['user']['id'] ?? null;
    $log = $conn->prepare("
      INSERT INTO task_logs (task_id, action, details, created_by, created_at)
      VALUES (?, 'restore', CONCAT('استعادة إلى إدارة #', ?, '، مرحلة #', ?), ?, NOW())
    ");
    $log->execute([$task_id, $new_department_id, $new_stage_id, $user_id]);
  } catch (Exception $e) {}

  $conn->commit();

  if ($open_after === 1) {
    header("Location: ../kanban.php?open_task_id={$task_id}");
  } else {
    header("Location: archive_tasks.php?type=archived&restored=1");
  }
  exit;

} catch (Exception $e) {
  if ($conn->inTransaction()) $conn->rollBack();
  error_log("Restore error: ".$e->getMessage());
  header("Location: archive_tasks.php?type=archived&error=restore_failed"); exit;
}